/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jeromq.ZLogManager;
import org.jeromq.ZMQ;
import org.jeromq.ZMQException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZLog {
    private static final String SUFFIX = ".dat";
    private final String topic;
    private final ZLogManager.ZLogConfig conf;
    private File path;
    private long start;
    private long pendingMessages;
    private long lastFlush;
    private final TreeMap<Long, Segment> segments;
    private Segment current;
    private static final Pattern pattern = Pattern.compile("\\d{20}\\.dat");
    private static final long LATEST = -1L;
    private static final long EARLIEST = -2L;

    public ZLog(ZLogManager.ZLogConfig conf, String topic) {
        this.topic = topic;
        this.conf = conf;
        this.segments = new TreeMap();
        this.reset();
        this.recover();
    }

    protected void reset() {
        this.close();
        this.start = 0L;
        this.pendingMessages = 0L;
        this.lastFlush = System.currentTimeMillis();
        this.current = null;
        this.path = new File(this.conf.base_path, this.topic);
        if (!this.path.exists() && !this.path.mkdirs()) {
            throw new RuntimeException("Cannot make directory " + this.path.getAbsolutePath());
        }
        File[] files = this.path.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                return arg0.compareTo(arg1);
            }
        });
        this.segments.clear();
        for (File f : files) {
            long offset = Long.valueOf(f.getName().replace(SUFFIX, ""));
            this.segments.put(offset, new Segment(this, offset));
        }
        if (!this.segments.isEmpty()) {
            this.start = this.segments.firstKey();
            this.current = this.segments.lastEntry().getValue();
        }
    }

    public File path() {
        return this.path;
    }

    public long segmentSize() {
        return this.conf.segment_size;
    }

    public int count() {
        return this.segments.size();
    }

    public long start() {
        return this.start;
    }

    public long offset() {
        return this.current == null ? 0L : this.current.offset();
    }

    public long[] offsets() {
        long[] offsets = new long[this.segments.size() + 1];
        int i = 0;
        while (true) {
            try {
                for (Long key : this.segments.keySet()) {
                    offsets[i] = key;
                    ++i;
                }
            }
            catch (ConcurrentModificationException e) {
                offsets = new long[this.segments.size() + 1];
                continue;
            }
            break;
        }
        offsets[i] = this.current == null ? 0L : this.current.size();
        return offsets;
    }

    public long[] offsets(long modifiedBefore, int maxEntry) {
        Segment[] values;
        if (this.segments.isEmpty()) {
            return new long[0];
        }
        if (modifiedBefore == -2L) {
            return new long[]{this.segments.firstKey()};
        }
        if (modifiedBefore == -1L) {
            Map.Entry<Long, Segment> last = this.segments.lastEntry();
            return new long[]{last.getKey(), last.getKey() + last.getValue().size()};
        }
        while (true) {
            try {
                values = this.segments.values().toArray(new Segment[0]);
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
        int idx = values.length / 2;
        int top = values.length;
        int bottom = -1;
        while (idx > bottom && idx < top) {
            Segment v = values[idx];
            long lastMod = v.lastModified();
            if (lastMod < modifiedBefore) {
                bottom = idx;
            } else {
                if (lastMod <= modifiedBefore) break;
                top = idx;
            }
            idx = (top + bottom) / 2;
        }
        if (bottom == -1) {
            return new long[0];
        }
        int start = 0;
        if (maxEntry > 0 && maxEntry < idx + 1) {
            start = idx - maxEntry + 1;
        }
        long[] offsets = new long[idx - start + 1 + (top == values.length ? 1 : 0)];
        for (int i = start; i <= idx; ++i) {
            offsets[i] = values[i].start();
            ++i;
        }
        if (top == values.length) {
            offsets[offsets.length - 1] = this.current.size();
        }
        return offsets;
    }

    public long append(ZMQ.Msg msg) throws IOException {
        long size = msg.size() + msg.headerSize();
        MappedByteBuffer buf = this.getBuffer(size, true);
        buf.put(msg.headerBuf());
        buf.put(msg.buf());
        ++this.pendingMessages;
        this.tryFlush();
        return this.current.offset();
    }

    private MappedByteBuffer getBuffer(long size, boolean writable) throws IOException {
        MappedByteBuffer buf;
        if (this.current == null) {
            this.current = new Segment(this, 0L);
            this.segments.put(0L, this.current);
        }
        if ((long)(buf = this.current.getBuffer(writable)).remaining() < size) {
            this.current.close();
            long offset = this.current.offset();
            this.current = new Segment(this, offset);
            this.segments.put(offset, this.current);
            buf = this.current.getBuffer(writable);
            this.cleanup();
        }
        return buf;
    }

    public List<ZMQ.Msg> readMsg(long start, int max) throws InvalidOffsetException, IOException {
        ZMQ.Msg msg;
        Map.Entry<Long, Segment> entry = this.segments.floorEntry(start);
        ArrayList<ZMQ.Msg> results = new ArrayList<ZMQ.Msg>();
        if (entry == null) {
            return results;
        }
        MappedByteBuffer buf = entry.getValue().getBuffer(false);
        buf.position((int)(start - entry.getKey()));
        while ((msg = ZLog.readMsg(buf)) != null && (max -= msg.size()) > 0) {
            results.add(msg);
        }
        return results;
    }

    public int read(long start, ByteBuffer dst) throws IOException {
        Map.Entry<Long, Segment> entry = this.segments.floorEntry(start);
        FileChannel ch = entry.getValue().getChannel(false);
        ch.position(start - entry.getKey());
        return ch.read(dst);
    }

    public FileChannel open(long start) throws IOException {
        Map.Entry<Long, Segment> entry = this.segments.floorEntry(start);
        FileChannel ch = entry.getValue().getChannel(false);
        ch.position(start - entry.getKey());
        return ch;
    }

    public void flush() {
        if (this.current == null) {
            return;
        }
        this.current.flush();
        this.pendingMessages = 0L;
        this.lastFlush = System.currentTimeMillis();
    }

    private void tryFlush() {
        boolean flush = false;
        if (this.pendingMessages >= this.conf.flush_messages) {
            flush = true;
        }
        if (!flush && System.currentTimeMillis() - this.lastFlush >= this.conf.flush_interval) {
            flush = true;
        }
        if (flush) {
            this.flush();
        }
    }

    private void recover() {
        if (this.current != null) {
            try {
                this.current.recover();
            }
            catch (IOException e) {
                throw new ZMQException.IOException(e);
            }
        }
    }

    private void cleanup() {
        block0: {
            Segment seg;
            long expire = System.currentTimeMillis() - this.conf.cleanup_interval;
            Iterator<Segment> i$ = this.segments.values().iterator();
            if (!i$.hasNext() || (seg = i$.next()).lastModified() >= expire || seg == this.current) break block0;
            seg.delete();
        }
    }

    public void close() {
        if (this.current == null) {
            return;
        }
        this.current.close();
        this.current = null;
    }

    public String toString() {
        if (this.current == null) {
            return super.toString() + "[" + this.topic + "]";
        }
        return super.toString() + "[" + this.topic + "," + this.current.toString() + "]";
    }

    private static ZMQ.Msg readMsg(ByteBuffer buf) throws InvalidOffsetException {
        if (!buf.hasRemaining()) {
            return null;
        }
        ZMQ.Msg msg = null;
        try {
            int length;
            int shortLength = buf.get();
            if (shortLength == 0) {
                return null;
            }
            if (shortLength == -1) {
                long longLength = buf.getLong();
                length = (int)longLength;
                if (length < 255) {
                    throw new InvalidOffsetException();
                }
            } else {
                length = shortLength;
                if (length < 0) {
                    length = 0xFF & length;
                }
            }
            if (length > buf.remaining()) {
                throw new InvalidOffsetException();
            }
            byte flag = buf.get();
            if (flag != 0 && flag != 1) {
                throw new InvalidOffsetException();
            }
            msg = new ZMQ.Msg(length);
            if (flag == 1) {
                msg.setFlags(1);
            }
            buf.get(msg.data());
        }
        catch (BufferUnderflowException e) {
            throw new InvalidOffsetException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidOffsetException(e);
        }
        return msg;
    }

    static /* synthetic */ ZMQ.Msg access$100(ByteBuffer x0) throws InvalidOffsetException {
        return ZLog.readMsg(x0);
    }

    public static class InvalidOffsetException
    extends Exception {
        private static final long serialVersionUID = -1696298215013570232L;

        public InvalidOffsetException(Throwable e) {
            super(e);
        }

        public InvalidOffsetException() {
        }
    }

    private static class Segment {
        private final ZLog zlog;
        private long size;
        private long start;
        private FileChannel channel;
        private MappedByteBuffer buffer;
        private final File path;

        protected Segment(ZLog zlog, long offset) {
            this.zlog = zlog;
            this.start = offset;
            this.size = 0L;
            this.path = new File(zlog.path(), Segment.getName(offset));
            if (this.path.exists()) {
                this.size = this.path.length();
            }
        }

        private static String getName(long offset) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(20);
            nf.setMaximumFractionDigits(0);
            nf.setGroupingUsed(false);
            return nf.format(offset) + ZLog.SUFFIX;
        }

        protected FileChannel getChannel(boolean writable) throws IOException {
            if (writable) {
                if (this.channel == null) {
                    this.channel = new RandomAccessFile(this.path, "rw").getChannel();
                }
                return this.channel;
            }
            return new FileInputStream(this.path).getChannel();
        }

        protected MappedByteBuffer getBuffer(boolean writable) throws IOException {
            if (writable && this.buffer != null) {
                return this.buffer;
            }
            FileChannel ch = this.getChannel(writable);
            if (writable) {
                this.buffer = ch.map(FileChannel.MapMode.READ_WRITE, 0L, this.zlog.segmentSize());
                this.buffer.position((int)this.size);
                return this.buffer;
            }
            MappedByteBuffer rbuf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size());
            ch.close();
            return rbuf;
        }

        protected final long offset() {
            if (this.buffer == null) {
                return this.start + this.size;
            }
            return this.start + (long)this.buffer.position();
        }

        protected final long size() {
            return this.size;
        }

        protected final long start() {
            return this.size;
        }

        protected void flush() {
            if (this.buffer != null) {
                this.buffer.force();
                this.size = this.buffer.position();
            }
        }

        /*
         * Exception decompiling
         */
        protected void recover() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void close() {
            if (this.channel == null) {
                return;
            }
            this.flush();
            try {
                this.channel.truncate(this.size);
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
            this.buffer = null;
        }

        protected long lastModified() {
            return this.path.lastModified();
        }

        protected void delete() {
            this.path.delete();
        }

        public String toString() {
            return this.path.getAbsolutePath() + "(" + this.offset() + ")";
        }
    }
}

