/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.apache.calcite.jdbc.CalciteConnection;
import org.jeecg.modules.jmreport.calcite.connection.JmCalciteDataSource;

public class PooledCalciteConnectionProxy
implements InvocationHandler {
    private final CalciteConnection realConnection;
    private final JmCalciteDataSource dataSource;

    public PooledCalciteConnectionProxy(CalciteConnection realConnection, JmCalciteDataSource dataSource) {
        this.realConnection = realConnection;
        this.dataSource = dataSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            boolean releaseSuccess = this.dataSource.releaseConnection((Connection)((CalciteConnection)proxy));
            if (!releaseSuccess) {
                this.realConnection.close();
            }
            return null;
        }
        return method.invoke((Object)this.realConnection, args);
    }

    public static CalciteConnection newProxyInstance(CalciteConnection realConnection, JmCalciteDataSource dataSource) {
        return (CalciteConnection)Proxy.newProxyInstance(realConnection.getClass().getClassLoader(), new Class[]{CalciteConnection.class, Connection.class}, (InvocationHandler)new PooledCalciteConnectionProxy(realConnection, dataSource));
    }
}

