/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.calcite.jdbc.CalciteConnection;
import org.jeecg.modules.jmreport.calcite.connection.PooledCalciteConnectionProxy;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class JmCalciteDataSource
extends AbstractDataSource {
    private static final String JDBC_URL_CALCITE = "jdbc:calcite:";
    private final BlockingQueue<Connection> connectionPool;
    private final ThreadLocal<Connection> threadConnection;
    private final int poolSize;

    public JmCalciteDataSource(int poolSize) {
        this.poolSize = poolSize;
        this.connectionPool = new LinkedBlockingQueue<Connection>(poolSize);
        this.threadConnection = new ThreadLocal();
        this.initializeConnectionPool();
    }

    private void initializeConnectionPool() {
        for (int i = 0; i < this.poolSize; ++i) {
            this.releaseConnection((Connection)this.createConnection());
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Username and password not supported.");
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.threadConnection.get();
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        conn = (Connection)this.connectionPool.poll();
        if (conn == null) {
            conn = this.createConnection();
        }
        this.threadConnection.set(conn);
        return conn;
    }

    public boolean releaseConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                if (this.threadConnection.get() == connection) {
                    this.threadConnection.remove();
                }
                return this.connectionPool.offer(connection);
            }
            return true;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while releasing connection", e);
        }
    }

    private CalciteConnection createConnection() {
        try {
            Properties info = new Properties();
            info.setProperty("caseSensitive", "false");
            info.setProperty("lex", "JAVA");
            info.setProperty("remarks", "true");
            info.setProperty("parserFactory", "org.apache.calcite.sql.parser.impl.SqlParserImpl#FACTORY");
            info.setProperty("conformance", "MYSQL_5");
            Class.forName("org.apache.calcite.jdbc.Driver");
            Connection connection = DriverManager.getConnection(JDBC_URL_CALCITE, info);
            return PooledCalciteConnectionProxy.newProxyInstance(connection.unwrap(CalciteConnection.class), this);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create Calcite connection", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

