/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.adapter.files;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.poi.ss.usermodel.Sheet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jeecg.modules.jmreport.calcite.adapter.JmCalciteDataConverter;
import org.jeecg.modules.jmreport.calcite.adapter.files.JmExcelEnumerator;
import org.jeecg.modules.jmreport.common.expetion.JimuFileDsParseException;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;

public class JmExcelScannableTable
extends AbstractTable
implements ScannableTable {
    private static final Pattern PATTERN_SPECIAL_CHAR = Pattern.compile("[`\u300a\u300b~!@%^&*()+=|{}':;',/ \\[\\]<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
    private final Sheet sheet;
    private @Nullable RelDataType rowType;
    protected @Nullable List<Object> dataList;

    public JmExcelScannableTable(Sheet sheet) {
        this.sheet = sheet;
    }

    public String toString() {
        return "JmExcelScannableTable";
    }

    public Enumerable<Object[]> scan(final DataContext root) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                JavaTypeFactory typeFactory = root.getTypeFactory();
                return new JmExcelEnumerator(JmExcelScannableTable.this.getDataList((RelDataTypeFactory)typeFactory));
            }
        };
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.rowType = JmExcelEnumerator.deduceRowType(typeFactory, this.sheet).getRelDataType();
        }
        if (OkConvertUtils.isEmpty((Object)this.rowType) || OkConvertUtils.isEmpty((Object)this.rowType.getFieldNames())) {
            throw new JimuReportException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u7b26\u5408\u683c\u5f0f\u8981\u6c42.");
        }
        ArrayList<String> tempFieldNames = new ArrayList<String>();
        List fieldNames = this.rowType.getFieldNames();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = (String)fieldNames.get(i);
            if (tempFieldNames.contains(fieldName)) {
                throw new JimuReportException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u91cd\u590d\u7684\u6807\u9898\u5217:[" + fieldName + "]");
            }
            if (OkConvertUtils.isEmpty((Object)fieldName)) {
                throw new JimuReportException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u4e0d\u80fd\u5b58\u5728\u7a7a\u7684\u6807\u9898\u5217");
            }
            Matcher specialCharMatcher = PATTERN_SPECIAL_CHAR.matcher(fieldName);
            if (specialCharMatcher.find()) {
                throw new JimuFileDsParseException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u6807\u9898[" + fieldName + "]\u4e2d\u4e0d\u80fd\u5b58\u5728\u7279\u6b8a\u5b57\u7b26");
            }
            tempFieldNames.add(fieldName);
        }
        return this.rowType;
    }

    public List<Object> getDataList(RelDataTypeFactory typeFactory) {
        if (this.dataList == null) {
            JmCalciteDataConverter excelDataConverter = JmExcelEnumerator.deduceRowType(typeFactory, this.sheet);
            this.dataList = excelDataConverter.getDataList();
        }
        return this.dataList;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }
}

