/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.adapter.files;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.file.CsvEnumerator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Source;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.expetion.JimuFileDsParseException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;

public class JmCsvScannableTable
extends AbstractTable
implements ScannableTable {
    private static final Pattern PATTERN_SPECIAL_CHAR = Pattern.compile("[`\u300a\u300b~!@%^&*()+=|{}':;',/ \\[\\]<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]");
    protected final Source source;
    @Nullable
    protected final RelProtoDataType protoRowType;
    @Nullable
    private RelDataType rowType;
    @Nullable
    private List<RelDataType> fieldTypes;

    JmCsvScannableTable(Source source, @Nullable RelProtoDataType protoRowType) {
        this.source = source;
        this.protoRowType = protoRowType;
    }

    public String toString() {
        return "JmCsvScannableTable";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        if (this.rowType == null) {
            this.rowType = CsvEnumerator.deduceRowType((JavaTypeFactory)((JavaTypeFactory)typeFactory), (Source)this.source, (List)null, (Boolean)this.isStream());
        }
        if (OkConvertUtils.isEmpty((Object)this.rowType) || OkConvertUtils.isEmpty((Object)this.rowType.getFieldNames())) {
            throw new JimuAlertException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u7b26\u5408\u683c\u5f0f.");
        }
        ArrayList<String> tempFieldNames = new ArrayList<String>();
        List fieldNames = this.rowType.getFieldNames();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = (String)fieldNames.get(i);
            if (tempFieldNames.contains(fieldName)) {
                throw new JimuFileDsParseException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u91cd\u590d\u7684\u6807\u9898\u5217:[" + fieldName + "]");
            }
            if (OkConvertUtils.isEmpty((Object)fieldName)) {
                throw new JimuFileDsParseException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u4e0d\u80fd\u5b58\u5728\u7a7a\u7684\u6807\u9898\u5217");
            }
            Matcher specialCharMatcher = PATTERN_SPECIAL_CHAR.matcher(fieldName);
            if (specialCharMatcher.find()) {
                throw new JimuFileDsParseException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:\u7b2c" + (i + 1) + "\u5217,\u6807\u9898[" + fieldName + "]\u4e2d\u4e0d\u80fd\u5b58\u5728\u7279\u6b8a\u5b57\u7b26");
            }
            tempFieldNames.add(fieldName);
        }
        return this.rowType;
    }

    public List<RelDataType> getFieldTypes(RelDataTypeFactory typeFactory) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList<RelDataType>();
            CsvEnumerator.deduceRowType((JavaTypeFactory)((JavaTypeFactory)typeFactory), (Source)this.source, this.fieldTypes, (Boolean)this.isStream());
        }
        return this.fieldTypes;
    }

    protected boolean isStream() {
        return false;
    }

    public Enumerable<Object[]> scan(DataContext root) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        final List<RelDataType> fieldTypes = this.getFieldTypes((RelDataTypeFactory)typeFactory);
        ImmutableIntList fields = ImmutableIntList.identity((int)fieldTypes.size());
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>((List)fields){
            final /* synthetic */ List val$fields;
            {
                this.val$fields = list2;
            }

            public Enumerator<Object[]> enumerator() {
                return new CsvEnumerator(JmCsvScannableTable.this.source, cancelFlag, false, (String[])null, CsvEnumerator.arrayConverter((List)fieldTypes, (List)this.val$fields, (boolean)false));
            }
        };
    }
}

