/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.SchemaPlus;
import org.jeecg.modules.jmreport.calcite.JmSchemaFactory;
import org.jeecg.modules.jmreport.calcite.connection.JmCalciteDataSource;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.SqlInjectionUtil;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class JmCalciteHandler {
    private static final Logger log = LoggerFactory.getLogger(JmCalciteHandler.class);
    JmCalciteDataSource calciteDataSource;
    JmSchemaFactory schemaFactory;

    public JmCalciteHandler(JmCalciteDataSource CalciteDataSource, JmSchemaFactory schemaFactory) {
        this.calciteDataSource = CalciteDataSource;
        this.schemaFactory = schemaFactory;
    }

    public boolean testConnection(JmreportDynamicDataSourceVo dbSource) {
        log.info("calcite test connection dbUrl:{}, dbType:{}", (Object)dbSource.getDbUrl(), (Object)dbSource.getDbType());
        try {
            CalciteConnection connection;
            try {
                connection = (CalciteConnection)this.calciteDataSource.getConnection();
            }
            catch (SQLException e) {
                throw new JimuReportException("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002", (Throwable)e);
            }
            SchemaPlus rootSchema = connection.getRootSchema();
            this.schemaFactory.create(rootSchema, String.valueOf(UUID.randomUUID()), dbSource);
        }
        catch (JimuReportException e) {
            return false;
        }
        return true;
    }

    public List<Map<String, Object>> findList(String dbKey, String sql, Map<String, Object> param) {
        return this.findList(dbKey, sql, param, null);
    }

    public List<Map<String, Object>> findList(String dbKey, String sql, Map<String, Object> param, Map<String, String> fieldMapping) {
        List respData;
        CalciteConnection connection;
        long startTime = System.currentTimeMillis();
        log.info("calcite findList \u6267\u884csql:{}, dbKey:{}, param:{}", new Object[]{sql, dbKey, param});
        SqlInjectionUtil.specialFilterContentForOnlineReport((String)sql);
        JmreportDynamicDataSourceVo dbSourceVo = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel((String)dbKey);
        try {
            connection = (CalciteConnection)this.calciteDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new JimuReportException("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002", (Throwable)e);
        }
        SchemaPlus rootSchema = connection.getRootSchema();
        this.schemaFactory.create(rootSchema, dbSourceVo.getId(), dbSourceVo);
        if (OkConvertUtils.isEmpty(param)) {
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)((Object)this.calciteDataSource));
            respData = jdbcTemplate.queryForList(sql);
        } else {
            NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)((Object)this.calciteDataSource));
            respData = jdbcTemplate.queryForList(sql, param);
        }
        JmCalciteHandler.FixIllegalFiled(respData);
        if (OkConvertUtils.isNotEmpty(fieldMapping)) {
            this.replaceDataField(respData, fieldMapping);
        }
        return respData;
    }

    private void replaceDataField(List<Map<String, Object>> respData, Map<String, String> fieldMapping) {
        if (OkConvertUtils.isNotEmpty(respData)) {
            Map<String, Object> firstData = respData.get(0);
            List hasMappingFields = firstData.keySet().stream().filter(fieldMapping::containsKey).collect(Collectors.toList());
            if (OkConvertUtils.isNotEmpty(hasMappingFields)) {
                respData.forEach(data -> {
                    for (String field : hasMappingFields) {
                        String newField = (String)fieldMapping.get(field);
                        if (!OkConvertUtils.isNotEmpty((Object)newField)) continue;
                        data.put(newField, data.get(field));
                        data.remove(field);
                    }
                });
            }
        }
    }

    private static void FixIllegalFiled(List<Map<String, Object>> respData) {
        Map<String, Object> firstData;
        List hasBarreField;
        if (OkConvertUtils.isNotEmpty(respData) && OkConvertUtils.isNotEmpty(hasBarreField = (firstData = respData.get(0)).keySet().stream().filter(field -> field.contains("-")).collect(Collectors.toList()))) {
            respData.forEach(data -> {
                for (String field : hasBarreField) {
                    String newField = field.replace("-", "_");
                    data.put(newField, data.get(newField));
                    data.remove(field);
                }
            });
        }
    }

    public Object findOne(String dbKey, String sql, Map<String, Object> param) {
        return this.findOne(dbKey, sql, param, null);
    }

    public Object findOne(String dbKey, String sql, Map<String, Object> param, Map<String, String> fieldMapping) {
        SqlInjectionUtil.specialFilterContentForOnlineReport((String)sql);
        List<Map<String, Object>> list = this.findList(dbKey, sql, param, fieldMapping);
        if (OkConvertUtils.isEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }
}

