/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;

public class MongoSchema
extends AbstractSchema {
    final MongoDatabase mongoDb;
    private Map<String, Table> tableMap;

    MongoSchema(MongoClientSettings settings, String database) {
        MongoClient mongo = MongoClients.create((MongoClientSettings)settings);
        try {
            this.mongoDb = mongo.getDatabase(database);
        }
        catch (Exception e) {
            mongo.close();
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    MongoSchema(MongoDatabase mongoDb) {
        this.mongoDb = Objects.requireNonNull(mongoDb, "mongoDb");
    }

    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String collectionName : this.mongoDb.listCollectionNames()) {
                builder.put((Object)collectionName, (Object)new MongoTable(this.mongoDb, collectionName));
            }
            this.tableMap = builder.build();
        }
        return this.tableMap;
    }
}

