/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchEnumerators;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchJson;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTableScan;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchTransport;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchVersion;
import org.apache.calcite.adapter.elasticsearch.Scrolling;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchTable
extends AbstractQueryableTable
implements TranslatableTable {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchTable.class);
    private static final String AGGREGATIONS = "aggregations";
    private final ElasticsearchVersion version;
    private final String indexName;
    final ObjectMapper mapper;
    final ElasticsearchTransport transport;

    ElasticsearchTable(ElasticsearchTransport transport) {
        super(Object[].class);
        this.transport = Objects.requireNonNull(transport, "transport");
        this.version = transport.version;
        this.indexName = transport.indexName;
        this.mapper = transport.mapper();
    }

    String scriptedFieldPrefix() {
        return this.version == ElasticsearchVersion.ES2 ? "_source" : "params._source";
    }

    private Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Long offset, Long fetch) throws IOException {
        Iterable iter;
        if (!aggregations.isEmpty() || !groupBy.isEmpty()) {
            return this.aggregate(ops, fields, sort, groupBy, aggregations, mappings, offset, fetch);
        }
        ObjectNode query = this.mapper.createObjectNode();
        Iterator<String> iterator = ops.iterator();
        while (iterator.hasNext()) {
            String op;
            String processedOp = op = iterator.next();
            for (int i = 0; i < fields.size(); ++i) {
                Map.Entry<String, Class> field = fields.get(i);
                String placeholder = "\\$" + i;
                processedOp = processedOp.replaceAll(placeholder, field.getKey());
            }
            query.setAll((ObjectNode)this.mapper.readTree(processedOp));
        }
        if (!sort.isEmpty()) {
            ArrayNode sortNode = query.withArray("sort");
            sort.forEach(e -> sortNode.add((JsonNode)this.mapper.createObjectNode().put((String)e.getKey(), ((RelFieldCollation.Direction)e.getValue()).isDescending() ? "desc" : "asc")));
        }
        if (offset != null) {
            query.put("from", offset);
        }
        if (fetch != null) {
            query.put("size", fetch);
        }
        Function1 getter = ElasticsearchEnumerators.getter(fields, (Map)ImmutableMap.copyOf(mappings));
        if (offset == null) {
            iter = () -> new Scrolling(this.transport).query(query);
        } else {
            ElasticsearchJson.Result search = (ElasticsearchJson.Result)this.transport.search().apply(query);
            iter = () -> search.searchHits().hits().iterator();
        }
        return Linq4j.asEnumerable(iter).select(getter);
    }

    private Enumerable<Object> aggregate(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mapping, Long offset, Long fetch) throws IOException {
        ObjectNode parent;
        if (!groupBy.isEmpty() && offset != null) {
            String message = "Currently ES doesn't support generic pagination with aggregations. You can still use LIMIT keyword (without OFFSET). For more details see https://github.com/elastic/elasticsearch/issues/4915";
            throw new IllegalStateException(message);
        }
        ObjectNode query = this.mapper.createObjectNode();
        for (String op : ops) {
            query.setAll((ObjectNode)this.mapper.readTree(op));
        }
        query.put("_source", false);
        query.put("size", 0);
        query.remove("script_fields");
        query.put("stored_fields", "_none_");
        Predicate<Map.Entry> isCountStar = e -> ((String)e.getValue()).contains("\"_id\"");
        Set countAll = aggregations.stream().filter(isCountStar).map(Map.Entry::getKey).collect(Collectors.toSet());
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        LinkedHashSet<String> orderedGroupBy = new LinkedHashSet<String>();
        orderedGroupBy.addAll(sort.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        orderedGroupBy.addAll(groupBy);
        if (query.has(AGGREGATIONS)) {
            parent = (ObjectNode)query.get(AGGREGATIONS);
        } else {
            parent = this.mapper.createObjectNode();
            query.set(AGGREGATIONS, (JsonNode)parent);
        }
        for (String string : orderedGroupBy) {
            ObjectNode terms;
            ObjectNode section;
            String aggName = "g_" + string;
            fieldMap.put(aggName, string);
            if (parent.has(aggName)) {
                section = (ObjectNode)parent.get(aggName);
            } else {
                section = this.mapper.createObjectNode();
                parent.set(aggName, (JsonNode)section);
            }
            if (section.has("terms")) {
                terms = (ObjectNode)section.get("terms");
            } else {
                terms = this.mapper.createObjectNode();
                section.set("terms", (JsonNode)terms);
            }
            terms.put("field", string);
            this.transport.mapping.missingValueFor(string).ifPresent(m -> terms.set("missing", m));
            if (fetch != null) {
                terms.put("size", fetch);
            }
            sort.stream().filter(e -> ((String)e.getKey()).equals(name)).findAny().ifPresent(s -> {
                ObjectNode order;
                if (terms.has("order")) {
                    order = (ObjectNode)terms.get("order");
                } else {
                    order = this.mapper.createObjectNode();
                    terms.set("order", (JsonNode)order);
                }
                order.put("_key", ((RelFieldCollation.Direction)s.getValue()).isDescending() ? "desc" : "asc");
            });
            if (section.has(AGGREGATIONS)) {
                parent = (ObjectNode)section.get(AGGREGATIONS);
                continue;
            }
            parent = this.mapper.createObjectNode();
            section.set(AGGREGATIONS, (JsonNode)parent);
        }
        if (!groupBy.isEmpty() || !aggregations.stream().allMatch(isCountStar)) {
            for (Map.Entry entry : aggregations) {
                JsonNode value = this.mapper.readTree((String)entry.getValue());
                parent.set((String)entry.getKey(), value);
            }
        }
        Consumer<JsonNode> emptyAggRemover = new Consumer<JsonNode>(){

            @Override
            public void accept(JsonNode node) {
                if (!node.has(ElasticsearchTable.AGGREGATIONS)) {
                    node.elements().forEachRemaining(this);
                    return;
                }
                JsonNode agg = node.get(ElasticsearchTable.AGGREGATIONS);
                if (agg.isEmpty()) {
                    ((ObjectNode)node).remove(ElasticsearchTable.AGGREGATIONS);
                } else {
                    this.accept(agg);
                }
            }
        };
        emptyAggRemover.accept((JsonNode)query);
        if (groupBy.isEmpty() && this.version.elasticVersionMajor() >= ElasticsearchVersion.ES6.elasticVersionMajor()) {
            query.put("track_total_hits", true);
        }
        log.info("\u5f00\u59cb\u67e5\u8be2\u6570\u636e-elasticsearch");
        long l = System.currentTimeMillis();
        ElasticsearchJson.Result res = (ElasticsearchJson.Result)this.transport.search(Collections.emptyMap()).apply(query);
        log.info("\u67e5\u8be2\u6570\u636e\u5b8c\u6210-elasticsearch,\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - l));
        ArrayList result = new ArrayList();
        if (res.aggregations() != null) {
            ElasticsearchJson.visitValueNodes((ElasticsearchJson.Aggregations)res.aggregations(), m -> {
                LinkedHashMap newMap = new LinkedHashMap();
                for (String key : m.keySet()) {
                    newMap.put(fieldMap.getOrDefault(key, key), m.get(key));
                }
                result.add(newMap);
            });
        } else {
            result.add(new LinkedHashMap());
        }
        long total = res.searchHits().total().value();
        if (groupBy.isEmpty()) {
            for (String expr : countAll) {
                result.forEach(m -> m.put(expr, total));
            }
        }
        Function1 getter = ElasticsearchEnumerators.getter(fields, (Map)ImmutableMap.copyOf(mapping));
        ElasticsearchJson.SearchHits hits = new ElasticsearchJson.SearchHits(res.searchHits().total(), result.stream().map(r -> new ElasticsearchJson.SearchHit("_id", r, null)).collect(Collectors.toList()));
        return Linq4j.asEnumerable((List)hits.hits()).select(getter);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(typeFactory);
        if (OkConvertUtils.isNotEmpty((Object)this.transport.mapping) && OkConvertUtils.isNotEmpty((Object)this.transport.mapping.mapping())) {
            this.transport.mapping.mapping().forEach((name, datatype) -> {
                if (OkConvertUtils.isNotEmpty((Object)name)) {
                    String dataTypeStr = "";
                    if (OkConvertUtils.isNotEmpty((Object)datatype)) {
                        dataTypeStr = datatype.name();
                    }
                    RelDataType relDataType = this.mapElasticTypeToRelType(typeFactory, dataTypeStr);
                    builder.add(name, relDataType);
                }
            });
        }
        return builder.build();
    }

    private RelDataType mapElasticTypeToRelType(RelDataTypeFactory typeFactory, String elasticType) {
        switch (elasticType) {
            case "text": 
            case "keyword": {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
            case "long": 
            case "integer": {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case "double": 
            case "float": {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case "date": {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        }
        return typeFactory.createSqlType(SqlTypeName.ANY);
    }

    public String toString() {
        return "ElasticsearchTable{" + this.indexName + "}";
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ElasticsearchQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new ElasticsearchTableScan(cluster, cluster.traitSetOf((RelTrait)ElasticsearchRel.CONVENTION), relOptTable, this, null);
    }

    public static class ElasticsearchQueryable<T>
    extends AbstractTableQueryable<T> {
        ElasticsearchQueryable(QueryProvider queryProvider, SchemaPlus schema, ElasticsearchTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            throw new UnsupportedOperationException("enumerator");
        }

        private ElasticsearchTable getTable() {
            return (ElasticsearchTable)this.table;
        }

        public Enumerable<Object> find(List<String> ops, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, RelFieldCollation.Direction>> sort, List<String> groupBy, List<Map.Entry<String, String>> aggregations, Map<String, String> mappings, Long offset, Long fetch) {
            try {
                return this.getTable().find(ops, fields, sort, groupBy, aggregations, mappings, offset, fetch);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to query " + this.getTable().indexName, e);
            }
        }
    }
}

