/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

public class PlatformUtils {
    public static String OS = System.getProperty("os.name").toLowerCase();
    public static String ARCH = System.getProperty("os.arch").toLowerCase();

    private PlatformUtils() {
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean is64() {
        return System.getProperty("os.arch").contains("64");
    }

    public static boolean is32() {
        return !PlatformUtils.is64();
    }

    public static Platform platform() {
        return new Platform(){

            @Override
            public OperatingSystem os() {
                if (PlatformUtils.isWindows()) {
                    return OperatingSystem.WINDOWS;
                }
                if (PlatformUtils.isUnix()) {
                    return OperatingSystem.UNIX;
                }
                if (PlatformUtils.isMac()) {
                    return OperatingSystem.MACOSX;
                }
                if (PlatformUtils.isSolaris()) {
                    return OperatingSystem.SOLARIS;
                }
                return OperatingSystem.UNKNOWN;
            }

            @Override
            public Architecture arch() {
                return PlatformUtils.is64() ? Architecture.BIT64 : Architecture.BIT32;
            }
        };
    }

    public static interface Platform {
        public OperatingSystem os();

        public Architecture arch();
    }

    public static enum Architecture {
        BIT64,
        BIT32;

    }

    public static enum OperatingSystem {
        WINDOWS,
        UNIX,
        MACOSX,
        SOLARIS,
        UNKNOWN;

    }
}

