/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.process;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.arquillian.spacelift.process.OutputTransformer;
import org.arquillian.spacelift.process.ProcessInteraction;
import org.jboss.arquillian.drone.webdriver.utils.Validate;

public class BinaryInteraction {
    private List<Pattern> allowedOutput = new ArrayList<Pattern>();
    private OutputTransformer transformer = output -> {
        this.checkCountDownLatch(output.toString());
        return output;
    };
    private Pattern expectedPattern;
    private CountDownLatch countDownLatch;

    public MatchedOutputProcessInteractionBuilder when(String pattern) {
        this.expectedPattern = Pattern.compile(pattern);
        return new MatchedOutputProcessInteractionBuilder();
    }

    public BinaryInteraction printToOut(String pattern) {
        this.allowedOutput.add(Pattern.compile(pattern));
        return this;
    }

    public BinaryInteraction outputPrefix(String prefix) {
        if (!Validate.empty(prefix)) {
            this.transformer = output -> {
                this.checkCountDownLatch(output.toString());
                return output.prepend((CharSequence)prefix);
            };
        }
        return this;
    }

    private void checkCountDownLatch(String string) {
        if (this.countDownLatch != null && this.countDownLatch.getCount() > 0L && !Validate.empty(string) && string.matches(this.expectedPattern.toString())) {
            this.countDownLatch.countDown();
        }
    }

    public ProcessInteraction build() {
        return new ProcessInteractionImpl(this.transformer, this.allowedOutput);
    }

    public class MatchedOutputProcessInteractionBuilder {
        public BinaryInteraction thenCountDown(CountDownLatch countDownLatch) {
            BinaryInteraction.this.countDownLatch = countDownLatch;
            return BinaryInteraction.this;
        }
    }

    private static class ProcessInteractionImpl
    implements ProcessInteraction {
        private final List<Pattern> allowedOutput;
        private final OutputTransformer transformer;

        ProcessInteractionImpl(OutputTransformer outputTransformer, List<Pattern> allowedOutput) {
            this.transformer = outputTransformer;
            this.allowedOutput = allowedOutput;
        }

        public List<Pattern> allowedOutput() {
            return this.allowedOutput;
        }

        public List<Pattern> errorOutput() {
            return new ArrayList<Pattern>();
        }

        public Map<Pattern, String> replyMap() {
            return new LinkedHashMap<Pattern, String>();
        }

        public List<Pattern> terminatingOutput() {
            return new ArrayList<Pattern>();
        }

        public String textTypedIn() {
            return "";
        }

        public OutputTransformer transformer() {
            return this.transformer;
        }
    }
}

