/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.SeleniumGoogleStorageSource;
import org.jboss.arquillian.drone.webdriver.binary.handler.AbstractBinaryHandler;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleniumServerBinaryHandler
extends AbstractBinaryHandler {
    public static final String SELENIUM_SERVER_VERSION_PROPERTY = "seleniumServerVersion";
    private static final String SELENIUM_SERVER_SYSTEM_DRIVER_BINARY_PROPERTY = "selenium.server.binary.path";
    private static final String SELENIUM_SERVER_DRIVER_BINARY_PROPERTY = "seleniumServerBinary";
    private static final String SELENIUM_SERVER_URL_PROPERTY = "seleniumServerUrl";
    private Logger log = Logger.getLogger(SeleniumServerBinaryHandler.class.toString());
    private DesiredCapabilities capabilities;

    public SeleniumServerBinaryHandler(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    protected String getArquillianCacheSubdirectory() {
        return "selenium-server";
    }

    @Override
    protected String getDesiredVersionProperty() {
        return SELENIUM_SERVER_VERSION_PROPERTY;
    }

    @Override
    protected String getUrlToDownloadProperty() {
        return SELENIUM_SERVER_URL_PROPERTY;
    }

    @Override
    protected ExternalBinarySource getExternalBinarySource() {
        return new SeleniumServerStorage((String)this.capabilities.getCapability(SELENIUM_SERVER_VERSION_PROPERTY), new HttpClient());
    }

    @Override
    protected DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected String getBinaryProperty() {
        return SELENIUM_SERVER_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public String getSystemBinaryProperty() {
        return SELENIUM_SERVER_SYSTEM_DRIVER_BINARY_PROPERTY;
    }

    static class SeleniumServerStorage
    extends SeleniumGoogleStorageSource {
        private String version;

        SeleniumServerStorage(String version, HttpClient httpClient) {
            super(httpClient);
            this.version = version;
        }

        @Override
        protected String getExpectedKeyRegex(String requiredVersion, String directory) {
            if (Validate.empty(this.version)) {
                return directory + "/" + this.getFileNameRegexToDownload(directory + ".*");
            }
            return this.getDirectoryFromFullVersion(this.version) + "/" + this.getFileNameRegexToDownload(this.version);
        }

        @Override
        public String getFileNameRegexToDownload(String version) {
            return String.format("selenium-server-standalone-%s.jar", version);
        }
    }
}

