/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.io.File;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.SeleniumGoogleStorageSource;
import org.jboss.arquillian.drone.webdriver.binary.handler.AbstractBinaryHandler;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.utils.HttpClient;
import org.jboss.arquillian.drone.webdriver.utils.PlatformUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.remote.DesiredCapabilities;

public class InternetExplorerBinaryHandler
extends AbstractBinaryHandler {
    public static final String IE_SYSTEM_DRIVER_BINARY_PROPERTY = "webdriver.ie.driver";
    private static final String IE_DRIVER_BINARY_PROPERTY = "ieDriverBinary";
    private static final String IE_DRIVER_VERSION_PROPERTY = "ieDriverVersion";
    private static final String IE_DRIVER_URL_PROPERTY = "ieDriverUrl";
    private static final String IE_DRIVER_ARCH_PROPERTY = "ieDriverArch";
    private static final String ARCH_32 = "Win32";
    private static final String ARCH_64 = "x64";
    private DesiredCapabilities capabilities;

    public InternetExplorerBinaryHandler(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    protected String getArquillianCacheSubdirectory() {
        return new BrowserCapabilitiesList.InternetExplorer().getReadableName();
    }

    @Override
    protected String getDesiredVersionProperty() {
        return IE_DRIVER_VERSION_PROPERTY;
    }

    @Override
    protected String getUrlToDownloadProperty() {
        return IE_DRIVER_URL_PROPERTY;
    }

    @Override
    protected ExternalBinarySource getExternalBinarySource() {
        return new IeStorageSource((String)this.capabilities.getCapability(IE_DRIVER_VERSION_PROPERTY), (String)this.capabilities.getCapability(IE_DRIVER_ARCH_PROPERTY), new HttpClient());
    }

    @Override
    protected DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected String getBinaryProperty() {
        return IE_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public String getSystemBinaryProperty() {
        return IE_SYSTEM_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public File downloadAndPrepare() throws Exception {
        return super.downloadAndPrepare();
    }

    static class IeStorageSource
    extends SeleniumGoogleStorageSource {
        private String version;
        private String architecture;

        protected IeStorageSource(String version, String architecture, HttpClient httpClient) {
            super(httpClient);
            this.version = version;
            if (!Validate.empty(architecture)) {
                if (!architecture.equals(InternetExplorerBinaryHandler.ARCH_32) && !architecture.equals(InternetExplorerBinaryHandler.ARCH_64)) {
                    throw new InvalidArgumentException("Invalid value for \"ieDriverArch\"; valid values are: Win32, x64");
                }
                this.architecture = architecture;
            } else {
                this.architecture = PlatformUtils.is32() ? InternetExplorerBinaryHandler.ARCH_32 : InternetExplorerBinaryHandler.ARCH_64;
            }
        }

        @Override
        protected String getExpectedKeyRegex(String requiredVersion, String directory) {
            if (Validate.empty(this.version)) {
                return directory + "/" + this.getFileNameRegexToDownload(directory + ".*");
            }
            return this.getDirectoryFromFullVersion(this.version) + "/" + this.getFileNameRegexToDownload(this.version);
        }

        @Override
        public String getFileNameRegexToDownload(String version) {
            StringBuffer regexBuffer = new StringBuffer("IEDriverServer_");
            regexBuffer.append(this.architecture).append("_").append(version).append(".zip");
            return regexBuffer.toString();
        }
    }
}

