/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.CacheProviderFacade;

public class MapCacheProvider<K extends Serializable, V>
implements Map<K, V> {
    private final CacheProviderFacade cacheProviderFacade;
    private final CachingModel cachingModel;
    private final FlushingModel flushModel;

    public MapCacheProvider(CacheProviderFacade cacheProviderFacade, CachingModel cachingModel, FlushingModel flushModel) {
        Validate.notNull((Object)cacheProviderFacade, (String)"cacheProviderFacade can not be null");
        Validate.notNull((Object)cachingModel, (String)"cachingModel can not be null");
        Validate.notNull((Object)flushModel, (String)"flushModel can not be null");
        this.cacheProviderFacade = cacheProviderFacade;
        this.cachingModel = cachingModel;
        this.flushModel = flushModel;
    }

    @Override
    public void clear() {
        this.cacheProviderFacade.flushCache(this.flushModel);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        return (V)this.cacheProviderFacade.getFromCache((Serializable)key, this.cachingModel);
    }

    @Override
    public V put(K key, V value) {
        V old = this.get(key);
        this.cacheProviderFacade.putInCache(key, this.cachingModel, value);
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            Serializable key = (Serializable)e.getKey();
            V value = e.getValue();
            this.cacheProviderFacade.putInCache(key, this.cachingModel, value);
        }
    }

    @Override
    public V remove(Object key) {
        V old = this.get(key);
        this.cacheProviderFacade.removeFromCache((Serializable)key, this.cachingModel);
        return old;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MapCacheProvider)) {
            return false;
        }
        MapCacheProvider rhs = (MapCacheProvider)object;
        return new EqualsBuilder().append((Object)this.cacheProviderFacade, (Object)rhs.cacheProviderFacade).append((Object)this.cachingModel, (Object)rhs.cachingModel).append((Object)this.flushModel, (Object)rhs.flushModel).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(-1916800777, 1589715735).append((Object)this.cacheProviderFacade).append((Object)this.cachingModel).append((Object)this.flushModel).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("cacheProviderFacade", (Object)this.cacheProviderFacade).append("cachingModel", (Object)this.cachingModel).append("flushModel", (Object)this.flushModel).toString();
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<K> keySet() {
        return Collections.emptySet();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Collection<V> values() {
        return Collections.emptySet();
    }
}

