/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.beans.PropertyEditor;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.ObjectUtils;
import org.springmodules.cache.CacheException;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.AbstractCacheProviderFacade;
import org.springmodules.cache.provider.CacheAccessException;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheNotFoundException;
import org.springmodules.cache.provider.ReflectionCacheModelEditor;
import org.springmodules.cache.provider.ehcache.EhCacheCachingModel;
import org.springmodules.cache.provider.ehcache.EhCacheFlushingModel;
import org.springmodules.cache.provider.ehcache.EhCacheModelValidator;

public class EhCacheFacade
extends AbstractCacheProviderFacade {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final MapCachingDoubleCheckedCreator<String, Cache> cacheLoader = new MapCachingCacheLoader();
    private final CacheModelValidator cacheModelValidator = new EhCacheModelValidator();
    private CacheManager cacheManager;
    private boolean createMissingCaches = false;

    public boolean isCreateMissingCaches() {
        return this.createMissingCaches;
    }

    public void setCreateMissingCaches(boolean createMissingCaches) {
        this.createMissingCaches = createMissingCaches;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Required
    public void setCacheManager(CacheManager newCacheManager) {
        Validate.notNull((Object)newCacheManager, (String)"cacheManager can not be null");
        this.cacheManager = newCacheManager;
    }

    public CacheModelValidator modelValidator() {
        return this.cacheModelValidator;
    }

    public PropertyEditor getCachingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(EhCacheCachingModel.class);
        return editor;
    }

    public PropertyEditor getFlushingModelEditor() {
        ReflectionCacheModelEditor editor = new ReflectionCacheModelEditor();
        editor.setCacheModelClass(EhCacheFlushingModel.class);
        return editor;
    }

    protected Cache getCache(CachingModel model) throws CacheNotFoundException, CacheAccessException {
        EhCacheCachingModel ehCacheCachingModel = (EhCacheCachingModel)model;
        String cacheName = ehCacheCachingModel.getCacheName();
        return this.getCache(cacheName);
    }

    protected Cache getCache(String name) throws CacheNotFoundException, CacheAccessException {
        return (Cache)this.cacheLoader.get(name);
    }

    protected boolean isSerializableCacheElementRequired() {
        return false;
    }

    protected void onFlushCache(FlushingModel model) throws CacheException {
        EhCacheFlushingModel flushingModel = (EhCacheFlushingModel)model;
        Object[] cacheNames = flushingModel.getCacheNames();
        if (!ObjectUtils.isEmpty((Object[])cacheNames)) {
            CacheException cacheException = null;
            try {
                for (Object cacheName : cacheNames) {
                    Cache cache = this.getCache((String)cacheName);
                    cache.removeAll();
                }
            }
            catch (CacheException exception) {
                cacheException = exception;
            }
            catch (Exception exception) {
                cacheException = new CacheAccessException((Throwable)exception);
            }
            if (cacheException != null) {
                throw cacheException;
            }
        }
    }

    protected Object onGetFromCache(Serializable key, CachingModel model) throws CacheException {
        Cache cache = this.getCache(model);
        Object cachedObject = null;
        try {
            Element cacheElement = cache.get(key);
            if (cacheElement != null) {
                cachedObject = cacheElement.getObjectValue();
            }
        }
        catch (Exception exception) {
            throw new CacheAccessException((Throwable)exception);
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable key, CachingModel model, Object obj) throws CacheException {
        Cache cache = this.getCache(model);
        Element newCacheElement = new Element((Object)key, obj);
        try {
            cache.put(newCacheElement);
        }
        catch (Exception exception) {
            throw new CacheAccessException((Throwable)exception);
        }
    }

    protected void onRemoveFromCache(Serializable key, CachingModel model) throws CacheException {
        Cache cache = this.getCache(model);
        try {
            cache.remove(key);
        }
        catch (Exception exception) {
            throw new CacheAccessException((Throwable)exception);
        }
    }

    protected void validateCacheManager() throws FatalCacheException {
        this.assertCacheManagerIsNotNull(this.cacheManager);
    }

    private final class MapCachingCacheLoader
    extends MapCachingDoubleCheckedCreator<String, Cache> {
        private MapCachingCacheLoader() {
            super(new ReferenceMap(0, 2));
        }

        @Override
        protected Cache createInternal(String name, Object ... args) {
            Cache cache;
            CacheManager cacheManager = EhCacheFacade.this.cacheManager;
            Log logger = EhCacheFacade.this.logger;
            try {
                if (cacheManager.cacheExists(name)) {
                    cache = cacheManager.getCache(name);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using existing EhCache for '" + name + "'"));
                    }
                } else if (EhCacheFacade.this.createMissingCaches) {
                    cacheManager.addCache(name);
                    cache = cacheManager.getCache(name);
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Created new default EhCache for '" + name + "'"));
                    }
                } else {
                    cache = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No EhCache exists for '" + name + "' and createMissingCaches is false"));
                    }
                }
            }
            catch (Exception exception) {
                throw new CacheAccessException((Throwable)exception);
            }
            if (cache == null) {
                throw new CacheNotFoundException(name);
            }
            return cache;
        }

        @Override
        protected String getKey(Object ... args) {
            return (String)args[0];
        }
    }
}

