/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class EhCacheExpirationManager
implements Runnable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Required
    public void setCacheManager(CacheManager cacheManager) {
        Validate.notNull((Object)cacheManager);
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        long startEvictions = System.currentTimeMillis();
        long evictions = 0L;
        String[] cacheNames = this.cacheManager.getCacheNames();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + cacheNames.length + " caches to clean."));
        }
        for (String cacheName : cacheNames) {
            Ehcache cache = this.cacheManager.getEhcache(cacheName);
            long preEvictSize = cache.getMemoryStoreSize();
            long startEviction = System.currentTimeMillis();
            cache.evictExpiredElements();
            if (!this.logger.isDebugEnabled()) continue;
            long evicted = preEvictSize - cache.getMemoryStoreSize();
            evictions += evicted;
            this.logger.debug((Object)("Evicted " + evicted + " expired elements from cache '" + cacheName + "' in " + (System.currentTimeMillis() - startEviction) + "ms"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scanned " + cacheNames.length + " caches and evicted " + evictions + " elements in " + (System.currentTimeMillis() - startEvictions) + "ms."));
        }
    }
}

