/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils.cache;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.cache.CacheFactory;
import org.jasig.portal.utils.cache.ICacheModelFactory;
import org.jasig.portal.utils.cache.MapCacheProvider;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.annotation.Required;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.provider.CacheProviderFacade;

public class CacheProviderFactory
implements CacheFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final MapCacheCreator mapCacheCreator = new MapCacheCreator();
    private CacheProviderFacade cacheProviderFacade;
    private ICacheModelFactory cacheModelFactory;

    public CacheProviderFacade getCacheProviderFacade() {
        return this.cacheProviderFacade;
    }

    @Required
    public void setCacheProviderFacade(CacheProviderFacade cacheProviderFacade) {
        Validate.notNull((Object)cacheProviderFacade);
        this.cacheProviderFacade = cacheProviderFacade;
    }

    public ICacheModelFactory getCacheModelFactory() {
        return this.cacheModelFactory;
    }

    @Required
    public void setCacheModelFactory(ICacheModelFactory cacheModelFactory) {
        Validate.notNull((Object)cacheModelFactory);
        this.cacheModelFactory = cacheModelFactory;
    }

    @Override
    public <K extends Serializable, V> Map<K, V> getCache() {
        return this.getCache("org.jasig.portal.utils.cache.DEFAULT_CACHE");
    }

    @Override
    public <K extends Serializable, V> Map<K, V> getCache(String cacheName) throws IllegalArgumentException {
        return (Map)this.mapCacheCreator.get(cacheName);
    }

    private class MapCacheCreator
    extends MapCachingDoubleCheckedCreator<String, Map<?, ?>> {
        public MapCacheCreator() {
            super(new ReferenceMap(0, 1));
        }

        @Override
        protected String getKey(Object ... args) {
            return (String)args[0];
        }

        @Override
        protected Map<?, ?> createInternal(String cacheName, Object ... args) {
            FlushingModel flushingModel = CacheProviderFactory.this.cacheModelFactory.getFlushingModel(cacheName);
            CachingModel cachingModel = CacheProviderFactory.this.cacheModelFactory.getCachingModel(cacheName);
            return new MapCacheProvider(CacheProviderFactory.this.cacheProviderFacade, cachingModel, flushingModel);
        }
    }
}

