/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import org.jasig.portal.utils.ThreadPoolWorker;

public class ThreadPoolReceipt {
    protected ThreadPoolWorker worker;
    protected boolean jobdone;
    protected boolean jobsuccessful;
    protected Throwable thrownException;

    public ThreadPoolReceipt(ThreadPoolWorker w) {
        this.worker = w;
        this.jobdone = false;
        this.jobsuccessful = false;
        this.thrownException = null;
    }

    public String toString() {
        String s = new String("done=" + this.jobdone + ", successful=" + this.jobsuccessful);
        if (this.thrownException != null) {
            s = s + "\n" + this.thrownException;
        }
        return s;
    }

    public synchronized void updateStatus(ThreadPoolWorker currentWorker, boolean isdone, boolean issuccessful, Throwable ex) {
        this.worker = currentWorker;
        this.jobdone = isdone;
        this.jobsuccessful = issuccessful;
        this.thrownException = ex;
        this.notifyAll();
    }

    public synchronized void killJob() {
        if (!this.jobdone && this.worker != null) {
            this.worker.killRequest();
        }
    }

    public synchronized void releaseWorker() {
        if (!this.jobdone && this.worker != null) {
            this.worker.completeRequest();
        }
    }

    public Throwable getThrownException() {
        return this.thrownException;
    }

    public boolean isJobsuccessful() {
        return this.jobsuccessful;
    }

    public synchronized boolean isJobdone() {
        return this.jobdone;
    }
}

