/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.utils.BlockingStack;
import org.jasig.portal.utils.ResourceLimits;
import org.jasig.portal.utils.ThreadPoolReceipt;
import org.jasig.portal.utils.ThreadPoolWorker;

public class ThreadPool
extends ThreadGroup {
    private static final Log log = LogFactory.getLog(ThreadPool.class);
    BlockingStack idleWorkers;
    List workers;
    ResourceLimits limits;

    public ThreadPool(String name, ResourceLimits rl) {
        super(name);
        if (rl == null) {
            this.limits = new ResourceLimits();
            this.limits.maxSize = 10;
            this.limits.optimalSize = 3;
        } else {
            this.limits = rl;
        }
        this.idleWorkers = new BlockingStack();
        this.workers = Collections.synchronizedList(new ArrayList(this.limits.optimalSize));
        for (int i = 0; i < this.limits.optimalSize; ++i) {
            ThreadPoolWorker w = new ThreadPoolWorker(this);
            this.workers.add(w);
            w.start();
        }
    }

    public ThreadPoolReceipt execute(Runnable target) throws InterruptedException {
        if (this.idleWorkers.empty()) {
            this.addWorker();
        }
        return ((ThreadPoolWorker)this.idleWorkers.pop()).process(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void adjustSize(int newSize) {
        if (newSize <= this.limits.maxSize) {
            List list = this.workers;
            synchronized (list) {
                int adjustment = newSize - this.workers.size();
                if (adjustment < 0) {
                    while (adjustment++ < 0) {
                        if (!this.idleWorkers.empty()) {
                            try {
                                this.releaseWorker((ThreadPoolWorker)this.idleWorkers.nonBlockingPop());
                            }
                            catch (EmptyStackException ese) {
                                --adjustment;
                            }
                            continue;
                        }
                        for (int i = 0; i < this.workers.size() && adjustment < 0; ++i) {
                            ThreadPoolWorker w = (ThreadPoolWorker)this.workers.get(i);
                            if (!this.releaseWorker(w)) continue;
                            ++adjustment;
                        }
                    }
                }
                if (adjustment > 0) {
                    for (int i = 0; i < adjustment; ++i) {
                        this.addNewWorker();
                    }
                }
            }
        }
    }

    protected synchronized void addWorker() {
        this.adjustSize(this.workers.size() + 1);
    }

    protected void stopWorker(ThreadPoolWorker worker) {
        worker.stopRequest();
    }

    protected boolean releaseWorker(ThreadPoolWorker worker) {
        return worker.completeRequest();
    }

    protected void addNewWorker() {
        ThreadPoolWorker w = new ThreadPoolWorker(this);
        this.workers.add(w);
        w.start();
    }

    public void clearIdle() {
        try {
            Object[] idle = new Object[this.idleWorkers.size() - this.idleWorkers.getMinSize()];
            int index = 0;
            while (index < idle.length) {
                idle[index++] = this.idleWorkers.pop();
            }
            for (int i = 0; i < idle.length; ++i) {
                ((ThreadPoolWorker)idle[i]).stopRequest();
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public void clear() {
        this.clearIdle();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        for (int i = 0; i < this.workers.size(); ++i) {
            if (!((ThreadPoolWorker)this.workers.get(i)).isAlive()) continue;
            ((ThreadPoolWorker)this.workers.get(i)).stopRequest();
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error((Object)("Registered an uncaught exception by thread " + t.getName()), e);
        if (t instanceof ThreadPoolWorker && !(e instanceof ThreadDeath)) {
            ThreadPoolWorker w = (ThreadPoolWorker)t;
            try {
                if (w.currentReceipt != null) {
                    w.currentReceipt.updateStatus(null, true, false, e);
                }
            }
            catch (Exception bad) {
                // empty catch block
            }
            this.notifyWorkerRestart(w);
        }
    }

    protected void notifyWorkerRestart(ThreadPoolWorker pw) {
        this.notifyWorkerFinished(pw);
        this.addWorker();
    }

    protected void killWorkerThread(ThreadPoolWorker pw) {
        try {
            if (pw.currentReceipt != null) {
                pw.currentReceipt.updateStatus(null, true, false, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyWorkerFinished(pw);
        pw.interrupt();
        this.addWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWorkerFinished(ThreadPoolWorker pw) {
        this.idleWorkers.remove(pw);
        List list = this.workers;
        synchronized (list) {
            int index = this.workers.indexOf(pw);
            if (index != -1) {
                this.workers.remove(index);
            }
        }
    }
}

