/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import java.util.HashMap;

public class SmartCache
extends HashMap {
    protected int iExpirationTimeout = 3600000;

    public SmartCache(int iExpirationTimeout) {
        this.iExpirationTimeout = iExpirationTimeout * 1000;
    }

    public SmartCache() {
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        ValueWrapper valueWrapper = new ValueWrapper(value);
        return super.put(key, valueWrapper);
    }

    public synchronized Object put(Object key, Object value, long lCacheInterval) {
        ValueWrapper valueWrapper = new ValueWrapper(value, lCacheInterval);
        return super.put(key, valueWrapper);
    }

    @Override
    public synchronized Object get(Object key) {
        ValueWrapper valueWrapper = (ValueWrapper)super.get(key);
        if (valueWrapper != null) {
            long creationTime = valueWrapper.getCreationTime();
            long cacheInterval = valueWrapper.getCacheInterval();
            long currentTime = System.currentTimeMillis();
            if (cacheInterval >= 0L && creationTime + cacheInterval < currentTime) {
                this.remove(key);
                return null;
            }
            return valueWrapper.getValue();
        }
        return null;
    }

    protected void sweepCache() {
        for (Object key : this.keySet()) {
            ValueWrapper valueWrapper = (ValueWrapper)super.get(key);
            long creationTime = valueWrapper.getCreationTime();
            long cacheInterval = valueWrapper.getCacheInterval();
            long currentTime = System.currentTimeMillis();
            if (cacheInterval < 0L || creationTime + cacheInterval >= currentTime) continue;
            this.remove(key);
        }
    }

    private class ValueWrapper {
        private long lCreationTime = System.currentTimeMillis();
        private long lCacheInterval;
        private Object oValue;

        protected ValueWrapper(Object oValue) {
            this.lCacheInterval = SmartCache.this.iExpirationTimeout;
            this.oValue = oValue;
        }

        protected ValueWrapper(Object oValue, long lCacheInterval) {
            this.lCacheInterval = SmartCache.this.iExpirationTimeout;
            this.oValue = oValue;
            this.lCacheInterval = lCacheInterval * 1000L;
        }

        protected Object getValue() {
            return this.oValue;
        }

        protected void setValue(Object oValue) {
            this.oValue = oValue;
        }

        protected long getCreationTime() {
            return this.lCreationTime;
        }

        protected void setCreationTime(long lCreationTime) {
            this.lCreationTime = lCreationTime;
        }

        protected long getCacheInterval() {
            return this.lCacheInterval;
        }

        protected void setCacheInterval(long lCacheInterval) {
            this.lCacheInterval = lCacheInterval;
        }
    }
}

