/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.utils;

import org.jasig.portal.PortalException;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.jasig.portal.utils.WMLURLFilter;
import org.jasig.portal.utils.XHTMLURLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbsoluteURLFilter
extends SAX2FilterImpl {
    protected String baseUrl = null;

    protected AbsoluteURLFilter(ContentHandler handler) {
        super(handler);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final AbsoluteURLFilter newAbsoluteURLFilter(String mimeType, String baseUrl, ContentHandler handler) throws PortalException {
        void var3_6;
        Object var3_3 = null;
        if (mimeType == null) throw new PortalException("AbsoluteURLFilter.newAbsoluteURLFilter(): Unable to create AbsoluteURLFilter. Mime type is null.");
        if (mimeType.equals("text/html")) {
            XHTMLURLFilter xHTMLURLFilter = new XHTMLURLFilter(handler);
        } else {
            if (!mimeType.equals("text/vnd.wap.wml")) throw new PortalException("AbsoluteURLFilter.newAbsoluteURLFilter(): Unable to locate AbsoluteURLFilter for mime type '" + mimeType + "'");
            WMLURLFilter wMLURLFilter = new WMLURLFilter(handler);
        }
        var3_6.baseUrl = baseUrl;
        return var3_6;
    }

    protected void setBaseUrl(String url) {
        if (url != null) {
            this.baseUrl = url;
        }
    }

    protected final void fixURL(String elementName, String attName, String qName, Attributes atts, AttributesImpl attsImpl) {
        String attValue;
        if (qName.equalsIgnoreCase(elementName) && (attValue = atts.getValue(attName)) != null) {
            int i = attValue.indexOf(":");
            if (i == -1 || i != -1 && attValue.substring(0, i).indexOf("/") != -1) {
                i = this.baseUrl.indexOf("://");
                int i2 = this.baseUrl.indexOf("/", i + 3);
                if (attValue.startsWith("/")) {
                    if (i != -1) {
                        attValue = i2 != -1 ? this.baseUrl.substring(0, i2).concat(attValue) : this.baseUrl.concat(attValue);
                    }
                } else {
                    attValue = attValue.trim().equals("") ? this.baseUrl : (attValue.trim().startsWith("?") || attValue.trim().startsWith("#") ? this.baseUrl.concat(attValue) : (i2 != -1 ? (this.baseUrl.indexOf("?") != -1 ? this.baseUrl.substring(0, this.baseUrl.substring(0, this.baseUrl.indexOf("?")).lastIndexOf("/") + 1).concat(attValue) : this.baseUrl.substring(0, this.baseUrl.lastIndexOf("/") + 1).concat(attValue)) : this.baseUrl.concat("/").concat(attValue)));
                }
                if (attValue.indexOf("/../") != -1) {
                    attValue = this.removeUpDirs(attValue);
                }
            }
            int index = atts.getIndex(attName);
            attsImpl.setAttribute(index, atts.getURI(index), atts.getLocalName(index), attName, atts.getType(index), attValue);
        }
    }

    private String removeUpDirs(String url) {
        int upDirIndex;
        int endProtoIndex = url.indexOf("//");
        while ((upDirIndex = url.indexOf("/../")) != -1) {
            String end = url.substring(upDirIndex + 4);
            String begin = url.substring(0, upDirIndex);
            begin = begin.indexOf("/", endProtoIndex + 2) != -1 ? url.substring(0, begin.lastIndexOf("/") + 1) : begin + "/";
            url = begin.concat(end);
        }
        return url;
    }
}

