/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.user;

import java.util.Map;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.support.UserLoggedOutPortalEvent;
import org.jasig.portal.events.support.UserSessionDestroyedPortalEvent;
import org.jasig.portal.security.IPerson;
import org.jasig.services.persondir.support.CachingPersonAttributeDaoImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class UserAttributesCacheCleaner
implements ApplicationListener,
ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private Map<String, CachingPersonAttributeDaoImpl> cachingAttributeDaos;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.cachingAttributeDaos = this.applicationContext.getBeansOfType(CachingPersonAttributeDaoImpl.class);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!(event instanceof UserLoggedOutPortalEvent) && !(event instanceof UserSessionDestroyedPortalEvent)) {
            return;
        }
        PortalEvent portalEvent = (PortalEvent)event;
        IPerson person = portalEvent.getPerson();
        String userName = person.getUserName();
        for (CachingPersonAttributeDaoImpl cachingAttributeDao : this.cachingAttributeDaos.values()) {
            cachingAttributeDao.removeUserAttributes(userName);
        }
    }
}

