/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.url;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.dao.usertype.FunctionalNameType;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.ITransientPortletWindowRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.IBasePortalUrl;
import org.jasig.portal.url.IPortalPortletUrl;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IUrlGenerator;
import org.jasig.portal.url.InvalidPortalRequestException;
import org.jasig.portal.url.PortalLayoutUrlImpl;
import org.jasig.portal.url.PortalPortletUrlImpl;
import org.jasig.portal.url.PortalRequestInfoImpl;
import org.jasig.portal.url.UrlState;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.web.util.UrlPathHelper;

public class PortalUrlProviderImpl
implements IPortalUrlProvider,
IUrlGenerator {
    public static final String SEPERATOR = "_";
    public static final String PORTAL_PARAM_PREFIX = "uP_";
    public static final String PORTLET_CONTROL_PREFIX = "pltc_";
    public static final String PORTLET_PARAM_PREFIX = "pltp_";
    public static final String PARAM_REQUEST_TARGET = "pltc_target";
    public static final String PARAM_WINDOW_STATE = "pltc_state";
    public static final String PARAM_PORTLET_MODE = "pltc_mode";
    public static final String NO_STATE_REGEX = ".*(normal|max|detached|exclusive|legacy).*";
    private static final Pattern NO_STATE_PATTERN = Pattern.compile(".*(normal|max|detached|exclusive|legacy).*");
    public static final String PORTAL_REQUEST_REGEX = "^(?:([^/]*)/)*(normal|max|detached|exclusive|legacy)/(?:([^/]*)/)?(render\\.uP|action\\.uP|)$";
    private static final Pattern PORTAL_REQUEST_PATTERN = Pattern.compile("^(?:([^/]*)/)*(normal|max|detached|exclusive|legacy)/(?:([^/]*)/)?(render\\.uP|action\\.uP|)$");
    private static final String PORTAL_REQUEST_INFO_ATTR = PortalUrlProviderImpl.class.getName() + ".PORTAL_REQUEST_INFO";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String defaultEncoding = "UTF-8";
    private IUserInstanceManager userInstanceManager;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private ITransientPortletWindowRegistry portletWindowRegistry;
    private IChannelRegistryStore channelRegistryStore;

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public void setPortletWindowRegistry(ITransientPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    @Override
    public IPortalRequestInfo getPortalRequestInfo(HttpServletRequest request) throws InvalidPortalRequestException {
        IPortalRequestInfo portalRequestInfo = (IPortalRequestInfo)request.getAttribute(PORTAL_REQUEST_INFO_ATTR);
        if (portalRequestInfo != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"short-circuit: found portalRequestInfo within request attributes");
            }
            return portalRequestInfo;
        }
        String requestPath = new UrlPathHelper().getPathWithinApplication(request);
        Matcher firstPass = NO_STATE_PATTERN.matcher(requestPath);
        if (!firstPass.matches()) {
            PortalRequestInfoImpl requestInfo = new PortalRequestInfoImpl();
            requestInfo.setUrlState(UrlState.NORMAL);
            requestInfo.setAction(false);
            String[] folderElements = requestPath.split("\\/");
            if (folderElements.length > 0) {
                requestInfo.setTargetedLayoutNodeId(folderElements[folderElements.length - 1]);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("finished building requestInfo: " + requestInfo));
            }
            return requestInfo;
        }
        Matcher m = PORTAL_REQUEST_PATTERN.matcher(requestPath);
        if (m.matches()) {
            String[] folderElements;
            PortalRequestInfoImpl requestInfo = new PortalRequestInfoImpl();
            String folderInformation = m.group(1);
            String stateInformation = m.group(2);
            String channelInformation = m.group(3);
            String renderInformation = m.group(4);
            requestInfo.setUrlState(UrlState.valueOf(stateInformation.toUpperCase()));
            requestInfo.setAction("action.uP".equals(renderInformation));
            if (null != channelInformation) {
                if (channelInformation.contains(".")) {
                    String[] channelElements = channelInformation.split("\\.");
                    IPortletWindowId portletWindowId = this.portletWindowRegistry.getPortletWindowId(channelElements[0]);
                    requestInfo.setTargetedPortletWindowId(portletWindowId);
                    requestInfo.setTargetedChannelSubscribeId(channelElements[1]);
                } else {
                    IPortletWindowId portletWindowId = this.portletWindowRegistry.getPortletWindowId(channelInformation);
                    requestInfo.setTargetedPortletWindowId(portletWindowId);
                }
            }
            if (!StringUtils.isBlank((String)folderInformation) && (folderElements = folderInformation.split("\\/")).length > 0) {
                requestInfo.setTargetedLayoutNodeId(folderElements[folderElements.length - 1]);
            }
            request.setAttribute(PORTAL_REQUEST_INFO_ATTR, (Object)requestInfo);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("finished building requestInfo: " + requestInfo));
            }
            return requestInfo;
        }
        throw new InvalidPortalRequestException("could not extract portal request from " + requestPath);
    }

    @Override
    public IBasePortalUrl getDefaultUrl(HttpServletRequest request) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String rootFolderId = userLayoutManager.getRootFolderId();
        return this.getFolderUrlByNodeId(request, rootFolderId);
    }

    @Override
    public IBasePortalUrl getFolderUrlByNodeId(HttpServletRequest request, String folderNodeId) {
        String resolvedFolderId = this.verifyFolderId(request, folderNodeId);
        return new PortalLayoutUrlImpl(request, this, resolvedFolderId);
    }

    @Override
    public IPortalPortletUrl getPortletUrl(HttpServletRequest request, IPortletWindowId portletWindowId) {
        return new PortalPortletUrlImpl(request, this, portletWindowId);
    }

    @Override
    public IPortalPortletUrl getPortletUrlByFName(HttpServletRequest request, String portletFName) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String channelSubscribeId = userLayoutManager.getSubscribeId(portletFName);
        if (channelSubscribeId == null) {
            throw new IllegalArgumentException("No channel subscribe ID found for fname '" + portletFName + "'.");
        }
        return this.getPortletUrlByNodeId(request, channelSubscribeId);
    }

    @Override
    public IPortalPortletUrl getPortletUrlByNodeId(HttpServletRequest request, String portletNodeId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)userLayoutManager.getNode(portletNodeId);
        String channelPublishId = channelNode.getChannelPublishId();
        IChannelDefinition channelDefinition = this.channelRegistryStore.getChannelDefinition(channelPublishId);
        if (null == channelDefinition) {
            throw new IllegalArgumentException("No channel definition found for publish id: " + channelPublishId);
        }
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(channelDefinition.getId());
        if (portletDefinition == null) {
            throw new IllegalArgumentException("No portlet defintion found for channel definition '" + channelDefinition.getId() + "'.");
        }
        IPerson person = userInstance.getPerson();
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(portletDefinition.getPortletDefinitionId(), portletNodeId, person.getID());
        IPortletWindow defaultPortletWindow = this.portletWindowRegistry.createDefaultPortletWindow(request, portletEntity.getPortletEntityId());
        IPortletWindowId portletWindowId = this.portletWindowRegistry.createTransientPortletWindowId(request, defaultPortletWindow.getPortletWindowId());
        return this.getPortletUrl(request, portletWindowId);
    }

    protected String verifyFolderId(HttpServletRequest request, String folderNodeId) {
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayoutNodeDescription node = userLayoutManager.getNode(folderNodeId);
        if (node == null) {
            throw new IllegalArgumentException("No layout node exists for id: " + folderNodeId);
        }
        if (node.getType() != 2) {
            throw new IllegalArgumentException("Layout node is not a folder for id: " + folderNodeId);
        }
        String resolvedFolderId = node.getId();
        return resolvedFolderId;
    }

    protected String getEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.defaultEncoding;
    }

    protected void encodeAndAppend(StringBuilder url, String encoding, String name, String ... values) {
        this.encodeAndAppend(url, encoding, name, Arrays.asList(values));
    }

    protected void encodeAndAppend(StringBuilder url, String encoding, String name, List<String> values) {
        try {
            name = URLEncoder.encode(name, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to encode portlet URL parameter name '" + name + "' for encoding '" + encoding + "'");
        }
        if (values.size() == 0) {
            url.append(name).append("=");
        } else {
            Iterator<String> valueItr = values.iterator();
            while (valueItr.hasNext()) {
                String value = valueItr.next();
                if (value == null) {
                    value = "";
                }
                try {
                    value = URLEncoder.encode(value, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Failed to encode portlet URL parameter value '" + value + "' for encoding '" + encoding + "'");
                }
                url.append(name).append("=").append(value);
                if (!valueItr.hasNext()) continue;
                url.append("&");
            }
        }
    }

    protected StringBuilder getUrlBase(HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getContextPath());
        if (url.charAt(0) != '/') {
            url.insert(0, '/');
        }
        if (url.charAt(url.length() - 1) != '/') {
            url.append('/');
        }
        return url;
    }

    @Override
    public String generatePortalUrl(HttpServletRequest request, IBasePortalUrl basePortalUrl, String targetFolderId) {
        String folderId;
        XPathExpression findChannelTabExpression;
        StringBuilder url = this.getUrlBase(request);
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        IUserLayout userLayout = userLayoutManager.getUserLayout();
        String tabId = userLayout.findNodeId(findChannelTabExpression = this.getFindChannelTabIdExpression(targetFolderId));
        if (tabId != null) {
            folderId = this.verifyFolderId(request, tabId);
            url.append("/").append(folderId);
        }
        folderId = this.verifyFolderId(request, targetFolderId);
        url.append("/").append(folderId);
        url.append("/").append((Object)UrlState.NORMAL);
        url.append("/render.uP");
        Map<String, List<String>> portalParameters = basePortalUrl.getPortalParameters();
        if (portalParameters.size() > 0) {
            String encoding = this.getEncoding(request);
            String seperator = "?";
            for (Map.Entry<String, List<String>> paramEntry : portalParameters.entrySet()) {
                String name = paramEntry.getKey();
                List<String> values = paramEntry.getValue();
                this.encodeAndAppend(url.append(seperator), encoding, PORTAL_PARAM_PREFIX + name, values);
                seperator = "&";
            }
        }
        return url.toString();
    }

    @Override
    public String generatePortletUrl(HttpServletRequest request, IPortalPortletUrl portalPortletUrl, IPortletWindowId portletWindowId) {
        XPathExpression findChannelTabExpression;
        IUserInstance userInstance;
        IUserPreferencesManager preferencesManager;
        IUserLayoutManager userLayoutManager;
        IUserLayout userLayout;
        String tabId;
        Validate.notNull((Object)request, (String)"HttpServletRequest was null");
        Validate.notNull((Object)portalPortletUrl, (String)"IPortalPortletUrl was null");
        Validate.notNull((Object)portletWindowId, (String)"IPortletWindowId was null");
        StringBuilder url = this.getUrlBase(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.getPortletWindow(request, portletWindowId);
        IPortletEntity portletEntity = this.portletEntityRegistry.getPortletEntity(portletWindow.getPortletEntityId());
        String channelSubscribeId = portletEntity.getChannelSubscribeId();
        if (!channelSubscribeId.startsWith("ctf") && (tabId = (userLayout = (userLayoutManager = (preferencesManager = (userInstance = this.userInstanceManager.getUserInstance(request)).getPreferencesManager()).getUserLayoutManager()).getUserLayout()).findNodeId(findChannelTabExpression = this.getFindChannelTabIdExpression(channelSubscribeId))) != null) {
            String folderId = this.verifyFolderId(request, tabId);
            url.append(folderId);
            url.append("/");
        }
        WindowState requestedWindowState = portalPortletUrl.getWindowState();
        WindowState currentWindowState = portletWindow.getWindowState();
        WindowState urlWindowState = requestedWindowState != null ? requestedWindowState : currentWindowState;
        String windowStateString = UrlState.NORMAL.toString().toLowerCase();
        if (WindowState.MAXIMIZED.equals((Object)urlWindowState)) {
            windowStateString = UrlState.MAX.toString().toLowerCase();
        } else if (IPortletAdaptor.DETACHED.equals((Object)urlWindowState)) {
            windowStateString = UrlState.DETACHED.toString().toLowerCase();
        } else if (IPortletAdaptor.EXCLUSIVE.equals((Object)urlWindowState)) {
            windowStateString = UrlState.EXCLUSIVE.toString().toLowerCase();
        } else {
            this.logger.warn((Object)("Unknown WindowState '" + urlWindowState + "' specified for portlet window " + portletWindow + ", defaulting to NORMAL"));
        }
        url.append(windowStateString);
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(portletEntity.getPortletDefinitionId());
        IChannelDefinition channelDefinition = portletDefinition.getChannelDefinition();
        String fname = channelDefinition.getFName();
        String validFname = FunctionalNameType.INVALID_CHARS_PATTERN.matcher(fname).replaceAll(SEPERATOR);
        url.append("/").append(validFname).append(".").append(channelSubscribeId);
        if (portalPortletUrl.isAction()) {
            url.append("/action.uP");
        } else {
            url.append("/render.uP");
        }
        String encoding = this.getEncoding(request);
        this.encodeAndAppend(url.append("?"), encoding, PARAM_REQUEST_TARGET, portletWindowId.getStringId());
        PortletMode portletMode = portalPortletUrl.getPortletMode();
        if (portletMode != null && !portletMode.equals((Object)portletWindow.getPortletMode())) {
            this.encodeAndAppend(url.append("&"), encoding, PARAM_PORTLET_MODE, portletMode.toString());
        }
        if (requestedWindowState != null && !requestedWindowState.equals((Object)currentWindowState) && (WindowState.MINIMIZED.equals((Object)urlWindowState) || WindowState.NORMAL.equals((Object)urlWindowState))) {
            this.encodeAndAppend(url.append("&"), encoding, PARAM_WINDOW_STATE, requestedWindowState.toString());
        }
        Map<String, List<String>> portalParameters = portalPortletUrl.getPortalParameters();
        for (Map.Entry<String, List<String>> paramEntry : portalParameters.entrySet()) {
            String name = paramEntry.getKey();
            List<String> values = paramEntry.getValue();
            this.encodeAndAppend(url.append("&"), encoding, PORTAL_PARAM_PREFIX + name, values);
        }
        Map<String, List<String>> portletParameters = portalPortletUrl.getPortletParameters();
        for (Map.Entry<String, List<String>> paramEntry : portletParameters.entrySet()) {
            String name = paramEntry.getKey();
            List<String> values = paramEntry.getValue();
            this.encodeAndAppend(url.append("&"), encoding, PORTLET_PARAM_PREFIX + name, values);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("finished portlet url: " + url.toString()));
        }
        return url.toString();
    }

    protected XPathExpression getFindChannelTabIdExpression(String channelNodeId) {
        String expression = "/layout/folder/folder[descendant::channel[@ID='" + channelNodeId + "']]/@ID";
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            return xPath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath expression: " + expression, e);
        }
    }

    protected XPathExpression getFindTabIdExpression(String tabNodeId) {
        String expression = "/layout/folder/folder[@ID='" + tabNodeId + "']/@ID";
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            return xPath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath expression: " + expression, e);
        }
    }
}

