/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.versioning;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.tools.versioning.Version;

public class VersionsManager {
    private static final Log log = LogFactory.getLog(VersionsManager.class);
    private static final Version[] VERSIONS_ARRAY_TYPE = new Version[0];
    private static final VersionsManager instance = new VersionsManager();
    private static LinkedList versions = VersionsManager.loadVersions();

    private VersionsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedList loadVersions() {
        LinkedList<Version> list = new LinkedList<Version>();
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement sql = con.createStatement();
            try {
                sql.execute("SELECT FNAME, DESCRIPTION, MAJOR, MINOR, MICRO FROM UP_VERSIONS");
                ResultSet rs = sql.getResultSet();
                try {
                    while (rs.next()) {
                        list.add(new Version(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getInt(5)));
                    }
                }
                finally {
                    VersionsManager.close(rs);
                }
            }
            finally {
                VersionsManager.close(sql);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to load Version information for uPortal objects.", (Throwable)e);
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    private static synchronized void updateVersions() {
        versions = VersionsManager.loadVersions();
    }

    public static final VersionsManager getInstance() {
        return instance;
    }

    public Version[] getVersions() {
        return versions.toArray(VERSIONS_ARRAY_TYPE);
    }

    public Version getVersion(String fname) {
        for (Version v : versions) {
            if (!v.getFname().equals(fname)) continue;
            return v;
        }
        return null;
    }

    public synchronized boolean removeVersion(String fname) {
        Version v = this.getVersion(fname);
        if (v == null) {
            return false;
        }
        boolean changed = this.remove(v);
        VersionsManager.updateVersions();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Version v) {
        block8: {
            Connection con = null;
            try {
                boolean bl;
                con = RDBMServices.getConnection();
                PreparedStatement sql = con.prepareStatement("DELETE FROM UP_VERSIONS WHERE FNAME=? AND MAJOR=? AND MINOR=? AND MICRO=?");
                try {
                    sql.setString(1, v.getFname());
                    sql.setInt(2, v.getMajor());
                    sql.setInt(3, v.getMinor());
                    sql.setInt(4, v.getMicro());
                    bl = sql.executeUpdate() >= 1;
                }
                catch (Throwable throwable) {
                    try {
                        VersionsManager.close(sql);
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to remove Version information for " + v.toString()), (Throwable)e);
                        break block8;
                    }
                }
                VersionsManager.close(sql);
                return bl;
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
        return false;
    }

    public synchronized boolean setVersion(String fname, String description, int major, int minor, int micro) {
        Version v = this.getVersion(fname);
        boolean changed = false;
        changed = v == null ? this.insertVersion(fname, description, major, minor, micro) : this.updateVersion(v, new Version(fname, description, major, minor, micro));
        VersionsManager.updateVersions();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateVersion(Version old, Version next) {
        block9: {
            Connection con = null;
            try {
                boolean bl;
                con = RDBMServices.getConnection();
                PreparedStatement sql = con.prepareStatement("UPDATE UP_VERSIONS SET MAJOR=?, MINOR=?, MICRO=?, DESCRIPTION=? WHERE FNAME=? AND MAJOR=? AND MINOR=? AND MICRO=?");
                try {
                    sql.setInt(1, next.getMajor());
                    sql.setInt(2, next.getMinor());
                    sql.setInt(3, next.getMicro());
                    sql.setString(4, next.getDescription());
                    sql.setString(5, old.getFname());
                    sql.setInt(6, old.getMajor());
                    sql.setInt(7, old.getMinor());
                    sql.setInt(8, old.getMicro());
                    int modifiedCount = sql.executeUpdate();
                    if (modifiedCount > 1) {
                        log.error((Object)"Warning: Multiple version entries detected in UP_VERSION table. Primary keys must be used in this table when coordinating version information from multiple portals running against the same database.");
                    }
                    bl = modifiedCount >= 1;
                }
                catch (Throwable throwable) {
                    try {
                        VersionsManager.close(sql);
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to update version information for " + old.toString() + ". Update from external source assumed. Abandoning update."), (Throwable)e);
                        break block9;
                    }
                }
                VersionsManager.close(sql);
                return bl;
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertVersion(String fname, String description, int major, int minor, int micro) {
        block8: {
            Connection con = null;
            Version v = new Version(fname, description, major, minor, micro);
            try {
                boolean bl;
                con = RDBMServices.getConnection();
                PreparedStatement sql = con.prepareStatement("INSERT INTO UP_VERSIONS (FNAME, DESCRIPTION, MAJOR, MINOR, MICRO) VALUES (?,?,?,?,?)");
                try {
                    sql.setString(1, fname);
                    sql.setString(2, description);
                    sql.setInt(3, major);
                    sql.setInt(4, minor);
                    sql.setInt(5, micro);
                    bl = sql.executeUpdate() == 1;
                }
                catch (Throwable throwable) {
                    try {
                        VersionsManager.close(sql);
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to insert version information for " + v.toString() + ". Abandoning insert."), (Throwable)e);
                        break block8;
                    }
                }
                VersionsManager.close(sql);
                return bl;
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
        return false;
    }

    private static void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            log.warn((Object)"failed to close statement", (Throwable)e);
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException e) {
            log.warn((Object)"failed to close resultset", (Throwable)e);
        }
    }
}

