/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.versioning;

public class Version {
    private String fname = null;
    private String description = null;
    private int major = 0;
    private int minor = 0;
    private int micro = 0;

    public Version(String fname, String description, int major, int minor, int micro) {
        this.fname = fname;
        this.description = description;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public String getFname() {
        return this.fname;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String toString() {
        return this.getFname() + ": " + this.getMajor() + "." + this.getMinor() + "." + this.getMicro() + " [" + this.getDescription() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        return this.fname.equals(v.getFname()) && this.equalTo(v);
    }

    public boolean equalTo(Version v) {
        return this.major == v.getMajor() && this.minor == v.getMinor() && this.micro == v.getMicro();
    }

    public boolean lessThan(Version v) {
        return this.major < v.getMajor() || this.major == v.getMajor() && this.minor < v.getMinor() || this.major == v.getMajor() && this.minor == v.getMinor() && this.micro < v.getMicro();
    }

    public boolean greaterThan(Version v) {
        return this.major > v.getMajor() || this.major == v.getMajor() && this.minor > v.getMinor() || this.major == v.getMajor() && this.minor == v.getMinor() && this.micro > v.getMicro();
    }

    public String dottedTriple() {
        return this.major + "." + this.minor + "." + this.micro;
    }
}

