/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class DbLoaderConfiguration {
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Resource tablesFile;
    private final Resource dataFile;
    private final String scriptFile;
    private final boolean dropTables;
    private final boolean createTables;
    private final boolean populateTables;

    public static Options getOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)"tables.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"useTables");
        OptionBuilder.withDescription((String)"The tables.xml file to use");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withArgName((String)"data.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"useData");
        OptionBuilder.withDescription((String)"The data.xml file to use");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"scriptFile");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"scriptFile");
        OptionBuilder.withDescription((String)"Create a SQL script of drop and create operations");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"dropTables");
        OptionBuilder.withDescription((String)"Drop tables");
        options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"createTables");
        OptionBuilder.withDescription((String)"Create tables");
        options.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"populateTables");
        OptionBuilder.withDescription((String)"Populate tables");
        options.addOption(OptionBuilder.create((char)'P'));
        return options;
    }

    public DbLoaderConfiguration(CommandLine commandLine) {
        String tablesFileString = commandLine.getOptionValue('t', "classpath:/properties/db/tables.xml");
        this.tablesFile = this.resourceLoader.getResource(tablesFileString);
        String dataFileString = commandLine.getOptionValue('d', "classpath:/properties/db/data.xml");
        this.dataFile = this.resourceLoader.getResource(dataFileString);
        this.scriptFile = commandLine.getOptionValue('c');
        this.dropTables = commandLine.hasOption('D');
        this.createTables = commandLine.hasOption('C');
        this.populateTables = commandLine.hasOption('P');
    }

    public DbLoaderConfiguration(boolean dropTables, boolean createTables, boolean populateTables, Resource tablesFile, Resource dataFile, String scriptFile) {
        this.dropTables = dropTables;
        this.createTables = createTables;
        this.populateTables = populateTables;
        this.tablesFile = tablesFile;
        this.dataFile = dataFile;
        this.scriptFile = scriptFile;
    }

    public Resource getTablesFile() {
        return this.tablesFile;
    }

    public Resource getDataFile() {
        return this.dataFile;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public boolean isCreateTables() {
        return this.createTables;
    }

    public boolean isPopulateTables() {
        return this.populateTables;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DbLoaderConfiguration)) {
            return false;
        }
        DbLoaderConfiguration rhs = (DbLoaderConfiguration)object;
        return new EqualsBuilder().append((Object)this.scriptFile, (Object)rhs.scriptFile).append(this.dropTables, rhs.dropTables).append(this.createTables, rhs.createTables).append((Object)this.tablesFile, (Object)rhs.tablesFile).append((Object)this.dataFile, (Object)rhs.dataFile).append(this.populateTables, rhs.populateTables).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1864980211, 1008139621).append((Object)this.scriptFile).append(this.dropTables).append(this.createTables).append((Object)this.tablesFile).append((Object)this.dataFile).append(this.populateTables).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("tablesFile", (Object)this.tablesFile).append("dataFile", (Object)this.dataFile).append("scriptFile", (Object)this.scriptFile).append("dropTables", this.dropTables).append("createTables", this.createTables).append("populateTables", this.populateTables).toString();
    }
}

