/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.dbloader;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.tools.dbloader.ISchemaExport;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class DataSourceSchemaExportRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        Option beanNameOpt = new Option("b", "beanName", true, "The name of the ISchemaExport bean to execute.");
        beanNameOpt.setRequired(true);
        options.addOption(beanNameOpt);
        Option exportOpt = new Option("e", "export", false, "If the generated SQL should be run against the database");
        options.addOption(exportOpt);
        Option dropOpt = new Option("d", "drop", false, "If the database objects should be dropped before creation");
        options.addOption(dropOpt);
        Option createOpt = new Option("c", "create", false, "If the creation of the database objects should be done");
        options.addOption(createOpt);
        Option outputFileOpt = new Option("o", "outputFile", true, "The file to write out the SQL to; optional.");
        options.addOption(outputFileOpt);
        Option ignoreNotFoundOpt = new Option("i", "ignoreNotFound", false, "If not finding the specified Spring bean should result in an exception.");
        options.addOption(ignoreNotFoundOpt);
        try {
            PosixParser cliParser = new PosixParser();
            commandLine = cliParser.parse(options, args);
        }
        catch (ParseException exp) {
            DataSourceSchemaExportRunner.printHelp(options);
            return;
        }
        if (commandLine.getOptions().length == 0) {
            DataSourceSchemaExportRunner.printHelp(options);
            return;
        }
        String beanName = commandLine.getOptionValue(beanNameOpt.getOpt());
        boolean export = commandLine.hasOption(exportOpt.getOpt());
        boolean create = commandLine.hasOption(createOpt.getOpt());
        boolean drop = commandLine.hasOption(dropOpt.getOpt());
        String outputFile = commandLine.getOptionValue(outputFileOpt.getOpt());
        boolean ignoreNotFound = commandLine.hasOption(ignoreNotFoundOpt.getOpt());
        try {
            ISchemaExport schemaExport;
            ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
            try {
                schemaExport = (ISchemaExport)applicationContext.getBean(beanName, ISchemaExport.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                if (ignoreNotFound) {
                    PortalApplicationContextLocator.shutdown();
                    return;
                }
                throw new IllegalArgumentException("Could not find ISchemaExport bean named '" + beanName + "'", e);
            }
            schemaExport.hbm2ddl(export, create, drop, outputFile);
        }
        finally {
            PortalApplicationContextLocator.shutdown();
        }
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(120, "DataSourceSchemaExportRunner", "", options, "", true);
    }
}

