/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.util.Comparator;
import org.jasig.portal.tools.checks.BaseCheck;
import org.jasig.portal.tools.checks.CheckResult;
import org.jasig.portal.utils.compare.EqualsComparator;

public class SystemPropertyCheck
extends BaseCheck {
    private final String property;
    private final String expected;
    private final Comparator<String> comparator;
    private String remediation;

    public SystemPropertyCheck(String property, String expected) {
        this(property, expected, new EqualsComparator());
    }

    public SystemPropertyCheck(String property, String expected, Comparator<String> comparator) {
        this.property = property;
        this.expected = expected;
        this.comparator = comparator;
        this.setDescription("Checking system property '" + this.property + "' against '" + this.expected + "' using " + this.comparator);
        this.setRemediation("");
    }

    public String getRemediation() {
        return this.remediation;
    }

    public void setRemediation(String remediation) {
        this.remediation = remediation;
    }

    @Override
    protected CheckResult doCheckInternal() {
        String sysProp = System.getProperty(this.property);
        int compareResult = this.comparator.compare(sysProp, this.expected);
        if (compareResult == 0) {
            return CheckResult.createSuccess("System property '" + this.property + "' passed comparison to '" + this.expected + "' using " + this.comparator);
        }
        return CheckResult.createFailure("System property '" + this.property + "' FAILED comparison to '" + this.expected + "' using " + this.comparator, this.remediation);
    }
}

