/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.tools.checks.CheckAndResult;
import org.jasig.portal.tools.checks.CheckResult;
import org.jasig.portal.tools.checks.ICheck;
import org.jasig.portal.tools.checks.ICheckRunner;

public class SafeCheckRunner
implements ICheckRunner {
    private static final String CHECK_FAILED_DESCRIPTION = "Check failed to provide a description.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<?> checks = Collections.emptyList();

    public List<?> getChecks() {
        return this.checks;
    }

    public void setChecks(List<?> checks) {
        Validate.notNull(checks, (String)"The List of IChecks cannot be null");
        this.checks = checks;
    }

    @Override
    public List<CheckAndResult> doChecks() {
        ArrayList<CheckAndResult> results = new ArrayList<CheckAndResult>(this.checks.size());
        for (Object check : this.checks) {
            if (check instanceof ICheck) {
                CheckAndResult checkResult = this.executeCheck((ICheck)check);
                results.add(checkResult);
                continue;
            }
            String classWas = check == null ? "null" : check.getClass().getName();
            CheckResult entryNotAnICheck = CheckResult.createFailure("Entry in list of checks did not implement ICheck.  It was an instance of [" + classWas + "]", "Fix the list of checks to include only instances of ICheck.");
            CheckAndResult notAnEntryCheckAndResult = new CheckAndResult("Check whether entries in the list of checks we're going to execute implement the required ICheck interface.", entryNotAnICheck);
            results.add(notAnEntryCheckAndResult);
        }
        return results;
    }

    private CheckAndResult executeCheck(ICheck check) {
        String checkDescription = CHECK_FAILED_DESCRIPTION;
        try {
            checkDescription = check.getDescription();
            CheckResult result = check.doCheck();
            return new CheckAndResult(checkDescription, result);
        }
        catch (Throwable t) {
            this.logger.error((Object)"Check failed by throwing.", t);
            String message = "Check failed by throwing exception. " + t;
            String remediation = "Since the check failed by throwing an exception, we cannot advise any particular solution.";
            CheckResult result = CheckResult.createFailure(message, remediation);
            return new CheckAndResult(checkDescription, result);
        }
    }
}

