/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.tools.checks.CheckAndResult;
import org.jasig.portal.tools.checks.InitializingCheckRunner;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ChecksServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String RERUN_PARAM = "rerun";

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (RERUN_PARAM.equals(request.getParameter(RERUN_PARAM))) {
            ServletContext servletContext = this.getServletContext();
            WebApplicationContext webAppCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            InitializingCheckRunner checkRunner = (InitializingCheckRunner)webAppCtx.getBean("initializingCheckRunning", InitializingCheckRunner.class);
            servletContext.setAttribute("INIT_CHECK_RESULTS", (Object)checkRunner);
        }
        this.doGet(request, response);
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List results = (List)this.getServletContext().getAttribute("INIT_CHECK_RESULTS");
        response.setHeader("pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate");
        response.setDateHeader("Expires", 0L);
        PrintWriter writer = response.getWriter();
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>");
        writer.println("uPortal instrumentation");
        writer.println("</title>");
        writer.println("</head>");
        writer.println("<body>");
        if (results == null) {
            writer.println("<p>Could not find check results in servlet context.</p>");
        } else {
            List<CheckAndResult> failedChecks = this.failedChecks(results);
            if (!failedChecks.isEmpty()) {
                writer.println("<h3>Failed checks</h3>");
                writer.println("<p>" + failedChecks.size() + " checks failed.</p>");
                this.printChecksAsTable(failedChecks, writer);
            }
            writer.println("<h3>Results of all checks:</h3>");
            this.printChecksAsTable(results, writer);
            writer.println("<form action='instrumentation' method='post'>");
            writer.println("<input name='rerun' value='rerun' type='submit'/>");
            writer.println("</form>");
        }
        writer.println("<br/>");
        writer.println("<h3>Package information.</h3>");
        writer.println("<table>");
        writer.println("<tr>");
        writer.println("<td>");
        writer.println("Implementation title");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Implementation version");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Package name");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Implementation vendor");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Specification title");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Specification vendor");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Specification version");
        writer.println("</td>");
        writer.println("</tr>");
        Package[] packs = Package.getPackages();
        for (int i = 0; i < packs.length; ++i) {
            Package pack = packs[i];
            writer.println("<tr>");
            writer.println("<td>");
            writer.println(pack.getImplementationTitle());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getImplementationVersion());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getName());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getImplementationVendor());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getSpecificationTitle());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getSpecificationVendor());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(pack.getSpecificationVersion());
            writer.println("</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
    }

    private List<CheckAndResult> failedChecks(List<CheckAndResult> checks) {
        if (checks == null) {
            throw new IllegalArgumentException("Checks must not be null.");
        }
        ArrayList<CheckAndResult> failedChecks = new ArrayList<CheckAndResult>();
        for (CheckAndResult checkAndResult : checks) {
            if (checkAndResult.isSuccess()) continue;
            failedChecks.add(checkAndResult);
        }
        return failedChecks;
    }

    private void printChecksAsTable(List<CheckAndResult> checks, PrintWriter writer) {
        writer.println("<table>");
        writer.println("<tr>");
        writer.println("<td>");
        writer.println("Status");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Check description");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Check result message");
        writer.println("</td>");
        writer.println("<td>");
        writer.println("Remediation advice");
        writer.println("</td>");
        writer.println("</tr>");
        for (CheckAndResult checkAndResult : checks) {
            writer.println("<tr>");
            writer.println("<td>");
            if (checkAndResult.isSuccess()) {
                writer.println("OK");
            } else {
                writer.println("FAILURE");
            }
            writer.println("</td>");
            writer.println("<td>");
            writer.println(checkAndResult.getCheckDescription());
            writer.println("</td>");
            writer.println("<td>");
            writer.println(checkAndResult.getResult().getMessage());
            writer.println("</td>");
            writer.println("<td>");
            if (checkAndResult.isSuccess()) {
                writer.println("Not applicable.");
            } else {
                writer.println(checkAndResult.getResult().getRemediationAdvice());
            }
            writer.println("</td>");
            writer.println("</tr>");
        }
        writer.println("</table>");
    }
}

