/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.chanpub;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aopalliance.aop.Advice;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.channel.IChannelPublishingService;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.dao.jpa.ChannelParameterImpl;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.spring.locator.ChannelPublishingServiceLocator;
import org.jasig.portal.spring.locator.JpaInterceptorLocator;
import org.jasig.portal.spring.locator.PortletDefinitionRegistryLocator;
import org.jasig.portal.tools.chanpub.ChannelDefDtdResolver;
import org.jasig.portal.tools.chanpub.IChannelPublisher;
import org.jasig.portal.utils.XML;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.orm.jpa.JpaInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Deprecated
public class ChannelPublisher
implements ErrorHandler,
IChannelPublisher {
    private static final Log log = LogFactory.getLog(ChannelPublisher.class);
    private static final String FRAMEWORK_OWNER = "UP_FRAMEWORK";
    private static final String SUBSCRIBER_ACTIVITY = "SUBSCRIBE";
    private static final String GRANT_PERMISSION_TYPE = "GRANT";
    private IPerson systemUser;
    private DocumentBuilder domParser;
    private IChannelRegistryStore crs;
    private Map<String, Integer> chanTypesNamesToIds;
    private boolean mOnCommandLine = false;
    private boolean mOverrideExisting = false;

    public static void main(String[] args) throws Exception {
        try {
            IChannelPublisher publisher = ChannelPublisher.getCommandLineInstance();
            File[] files = publisher.parseCommandLine(args);
            for (File file : files) {
                try {
                    publisher.publishChannel(file);
                }
                catch (Exception e) {
                    throw new Exception("Unable to publish file: " + file, e);
                }
                System.out.println("Published channel " + file);
            }
            System.out.println("Publishing finished.");
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    @Override
    public File[] parseCommandLine(String[] args) throws ParseException {
        File[] files;
        CommandLine line;
        Option fileOpt = new Option("f", "file", true, "A single chanpub file to publish.");
        Option dirOpt = new Option("d", "dir", true, "A directory of chanpub files to publish. (all .xml files in the directory will be processed)");
        OptionGroup optGroup = new OptionGroup();
        optGroup.addOption(fileOpt);
        optGroup.addOption(dirOpt);
        optGroup.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(optGroup);
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(120, "java " + this.getClass().getName(), "", options, "", true);
            throw exp;
        }
        if (line.hasOption(fileOpt.getOpt())) {
            String chanPubName = line.getOptionValue(fileOpt.getOpt());
            File chanPubFile = new File(chanPubName);
            files = new File[]{chanPubFile};
        } else if (line.hasOption(dirOpt.getOpt())) {
            String chanPubDirName = line.getOptionValue(dirOpt.getOpt());
            File chanPubDir = new File(chanPubDirName);
            if (!chanPubDir.exists()) {
                throw new IllegalArgumentException("Directory '" + chanPubDir + "' does not exist.");
            }
            files = chanPubDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
        } else {
            throw new IllegalStateException("Should not be possible");
        }
        return files;
    }

    private void setupSystemUser() {
        this.systemUser = PersonFactory.createSystemPerson();
    }

    @Override
    public IChannelDefinition publishChannel(File filename) throws Exception {
        ChannelInfo ci = this.getChannelInfo(filename);
        return this.publishChannel(ci);
    }

    @Override
    public IChannelDefinition publishChannel(InputStream is) throws Exception {
        ChannelInfo ci = this.getChannelInfo(is);
        return this.publishChannel(ci);
    }

    private IChannelDefinition publishChannel(ChannelInfo ci) throws Exception {
        if (ci == null) {
            return null;
        }
        try {
            IGroupMember[] groupMembers;
            IChannelPublishingService channelPublishingService = ChannelPublishingServiceLocator.getIChannelPublishingService();
            if (!(ci.groups != null && ci.groups.length != 0 || ci.users != null && ci.users.length != 0)) {
                groupMembers = new IGroupMember[]{};
            } else if (ci.groups == null || ci.groups.length == 0) {
                groupMembers = ci.users;
            } else if (ci.users == null || ci.users.length == 0) {
                groupMembers = ci.groups;
            } else {
                groupMembers = new IGroupMember[ci.groups.length + ci.users.length];
                System.arraycopy(ci.groups, 0, groupMembers, 0, ci.groups.length);
                System.arraycopy(ci.users, 0, groupMembers, ci.groups.length, ci.users.length);
            }
            if (ci.categories == null) {
                ci.categories = new ChannelCategory[0];
            }
            ci.chanDef = channelPublishingService.saveChannelDefinition(ci.chanDef, this.systemUser, ci.categories, groupMembers);
        }
        catch (Exception e) {
            log.error((Object)("publishChannel() :: Exception while attempting to publish channel to database. Channel name = " + ci.chanDef.getName()));
            throw e;
        }
        return ci.chanDef;
    }

    private void setupDomParser() throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            this.domParser = dbf.newDocumentBuilder();
            this.domParser.setEntityResolver(new ChannelDefDtdResolver());
            this.domParser.setErrorHandler(this);
        }
        catch (Exception e) {
            log.error((Object)"setupDomParser() :: creating Dom Parser. ", (Throwable)e);
            throw e;
        }
    }

    private ChannelInfo getChannelInfo(File chanDefFile) throws Exception {
        FileInputStream is = new FileInputStream(chanDefFile);
        return this.getChannelInfo(is);
    }

    private ChannelInfo getChannelInfo(InputStream is) throws Exception {
        ChannelInfo ci = new ChannelInfo();
        Document doc = null;
        doc = this.domParser.parse(is);
        Element chanDefE = doc.getDocumentElement();
        String id = this.getId(chanDefE);
        if (id != null) {
            log.warn((Object)"The channel XML file specified an id element which is no longer supported.");
        }
        String fname = this.getFname(chanDefE);
        ci.chanDef = this.crs.getChannelDefinition(fname);
        if (ci.chanDef != null && !this.mOverrideExisting) {
            log.error((Object)("chanDef with fname " + fname + " already exists " + "and override is false. Terminating publication."));
            return null;
        }
        if (ci.chanDef == null) {
            String clazz = null;
            String name = null;
            String title = null;
            int typeId = -1;
            for (Node param = chanDefE.getFirstChild(); param != null; param = param.getNextSibling()) {
                if (!(param instanceof Element)) continue;
                Element pele = (Element)param;
                String tagname = pele.getTagName();
                if (tagname.equals("title")) {
                    title = XML.getElementText(pele).trim();
                    continue;
                }
                if (tagname.equals("name")) {
                    name = XML.getElementText(pele).trim();
                    continue;
                }
                if (tagname.equals("type")) {
                    typeId = this.getType(XML.getElementText(pele).trim());
                    continue;
                }
                if (!tagname.equals("class")) continue;
                clazz = XML.getElementText(pele).trim();
            }
            ci.chanDef = this.crs.newChannelDefinition(typeId, fname, clazz, name, title);
        }
        for (Node param = chanDefE.getFirstChild(); param != null; param = param.getNextSibling()) {
            if (!(param instanceof Element)) continue;
            Element pele = (Element)param;
            String tagname = pele.getTagName();
            String value = XML.getElementText(pele).trim();
            if (tagname.equals("title")) {
                ci.chanDef.setTitle(value);
                continue;
            }
            if (tagname.equals("name")) {
                ci.chanDef.setName(value);
                continue;
            }
            if (tagname.equals("makeFNameAccessibleOnly")) {
                ci.fNameAccessibleOnly = true;
                continue;
            }
            if (tagname.equals("fname")) {
                ci.chanDef.setFName(value);
                continue;
            }
            if (tagname.equals("desc")) {
                ci.chanDef.setDescription(value);
                continue;
            }
            if (tagname.equals("type")) {
                int typeId = this.getType(value);
                IChannelType channelType = this.crs.getChannelType(typeId);
                if (channelType == null) {
                    throw new IllegalArgumentException("No IChannelType exists for ID " + typeId);
                }
                ci.chanDef.setType(channelType);
                continue;
            }
            if (tagname.equals("class")) {
                ci.chanDef.setJavaClass(value);
                continue;
            }
            if (tagname.equals("timeout")) {
                ci.chanDef.setTimeout(Integer.parseInt(value));
                continue;
            }
            if (tagname.equals("hasedit")) {
                ci.chanDef.setEditable(value != null && value.equals("Y"));
                continue;
            }
            if (tagname.equals("hashelp")) {
                ci.chanDef.setHasHelp(value != null && value.equals("Y"));
                continue;
            }
            if (tagname.equals("hasabout")) {
                ci.chanDef.setHasAbout(value != null && value.equals("Y"));
                continue;
            }
            if (tagname.equals("secure")) {
                ci.chanDef.setIsSecure(value != null && value.equals("Y"));
                continue;
            }
            if (this.mOnCommandLine && tagname.equals("categories")) {
                this.getCategories(ci, pele);
                continue;
            }
            if (this.mOnCommandLine && tagname.equals("groups")) {
                this.getGroups(ci, pele);
                continue;
            }
            if (this.mOnCommandLine && tagname.equals("users")) {
                this.getUsers(ci, pele);
                continue;
            }
            if (tagname.equals("parameters")) {
                this.getParameters(ci, pele);
                continue;
            }
            if (!tagname.equals("portletPreferences")) continue;
            this.getPreferences(ci, pele);
        }
        ci.chanDef.setApproverId(0);
        ci.chanDef.setApprovalDate(new Date());
        ci.chanDef.setPublisherId(0);
        ci.chanDef.setPublishDate(new Date());
        if (ci.groups == null && !this.mOnCommandLine) {
            ci.groups = this.getAdminGroup();
        }
        if (ci.categories == null && !this.mOnCommandLine) {
            ci.categories = this.getDefaultCategory(ci.fNameAccessibleOnly);
        }
        return ci;
    }

    private String getFname(Element chanDefE) throws Exception {
        String fname = null;
        for (Node n = chanDefE.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals("fname")) continue;
            fname = XML.getElementText((Element)n).trim();
        }
        if (fname == null) {
            throw new Exception("Missing required fname element");
        }
        return fname;
    }

    private String getId(Element chanDefE) throws Exception {
        String id = null;
        for (Node n = chanDefE.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !n.getNodeName().equals("channelId")) continue;
            id = XML.getElementText((Element)n).trim();
        }
        return id;
    }

    private int getType(String value) throws Exception {
        Integer typeId = this.chanTypesNamesToIds.get(value);
        if (typeId != null) {
            return typeId;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        for (String channelTypeName : this.chanTypesNamesToIds.keySet()) {
            if (pw == null) {
                pw = new PrintWriter(sw);
                pw.print("['");
                pw.print(channelTypeName);
                pw.print("'");
                continue;
            }
            pw.print(" | '");
            pw.print(channelTypeName);
            pw.print("'");
        }
        pw.print("]");
        pw.flush();
        throw new Exception("Invalid entry '" + value + "' for Channel Type. Must be one of " + sw.toString());
    }

    private void getCategories(ChannelInfo ci, Element pele) throws Exception {
        NodeList anodes = pele.getElementsByTagName("category");
        if (anodes.getLength() != 0) {
            ci.categories = new ChannelCategory[anodes.getLength()];
            for (int j = 0; j < anodes.getLength(); ++j) {
                Element anode = (Element)anodes.item(j);
                String catString = XML.getElementText(anode).trim();
                IEntityGroup cat = ChannelPublisher.getGroup(catString, IChannelDefinition.class);
                if (cat == null) {
                    throw new Exception("Invalid entry '" + catString + "' for category.");
                }
                ci.categories[j] = this.crs.getChannelCategory(cat.getKey());
            }
        }
    }

    private void getParameters(ChannelInfo ci, Element pele) {
        HashSet<IChannelParameter> parameters = new HashSet<IChannelParameter>();
        NodeList anodes = pele.getElementsByTagName("parameter");
        if (anodes.getLength() > 0) {
            for (int j = 0; j < anodes.getLength(); ++j) {
                NodeList ovrdnodes;
                NodeList descnodes;
                NodeList valuenodes;
                String pname = null;
                String pvalue = null;
                String povrd = null;
                String pdescr = null;
                Element anode = (Element)anodes.item(j);
                NodeList namenodes = anode.getElementsByTagName("name");
                if (namenodes.getLength() > 0) {
                    pname = XML.getElementText((Element)namenodes.item(0)).trim();
                }
                if ((valuenodes = anode.getElementsByTagName("value")).getLength() > 0) {
                    pvalue = XML.getElementText((Element)valuenodes.item(0)).trim();
                }
                if ((descnodes = anode.getElementsByTagName("description")).getLength() > 0) {
                    pdescr = XML.getElementText((Element)descnodes.item(0)).trim();
                }
                if ((ovrdnodes = anode.getElementsByTagName("ovrd")).getLength() > 0) {
                    povrd = XML.getElementText((Element)ovrdnodes.item(0)).trim();
                }
                ChannelParameterImpl chanParam = new ChannelParameterImpl(pname, pvalue, RDBMServices.dbFlag(povrd));
                chanParam.setDescription(pdescr);
                parameters.add(chanParam);
            }
        }
        ci.chanDef.replaceParameters(parameters);
    }

    private void getPreferences(ChannelInfo ci, Element pele) {
        LinkedList<IPortletPreference> preferences = new LinkedList<IPortletPreference>();
        NodeList portletPreferenceNodes = pele.getElementsByTagName("portletPreference");
        if (portletPreferenceNodes.getLength() > 0) {
            for (int preferenceNodeIndex = 0; preferenceNodeIndex < portletPreferenceNodes.getLength(); ++preferenceNodeIndex) {
                NodeList valuesNodes;
                boolean readOnly = false;
                List<String> values = Collections.emptyList();
                Element portletPreferenceNode = (Element)portletPreferenceNodes.item(preferenceNodeIndex);
                NodeList nameNodes = portletPreferenceNode.getElementsByTagName("name");
                if (nameNodes.getLength() != 1) {
                    throw new IllegalArgumentException("Illegal number of 'name' elements under a 'portletPreference' element: was " + nameNodes.getLength() + " expected 1");
                }
                String name = XML.getElementText((Element)nameNodes.item(0)).trim();
                NodeList readOnlyNodes = portletPreferenceNode.getElementsByTagName("read-only");
                if (readOnlyNodes.getLength() > 1) {
                    throw new IllegalArgumentException("Illegal number of 'read-only' elements under a 'portletPreference' element: was " + nameNodes.getLength() + " expected 0 or 1");
                }
                if (readOnlyNodes.getLength() == 1) {
                    readOnly = Boolean.parseBoolean(XML.getElementText((Element)readOnlyNodes.item(0)).trim());
                }
                if ((valuesNodes = portletPreferenceNode.getElementsByTagName("values")).getLength() > 1) {
                    throw new IllegalArgumentException("Illegal number of 'values' elements under a 'portletPreference' element: was " + nameNodes.getLength() + " expected 0 or 1");
                }
                if (valuesNodes.getLength() == 1) {
                    Element valuesNode = (Element)valuesNodes.item(0);
                    NodeList valueNodes = valuesNode.getElementsByTagName("value");
                    values = new ArrayList(valueNodes.getLength());
                    for (int valueNodeIndex = 0; valueNodeIndex < valueNodes.getLength(); ++valueNodeIndex) {
                        Element valueNode = (Element)valueNodes.item(valueNodeIndex);
                        values.add(XML.getElementText(valueNode).trim());
                    }
                }
                PortletPreferenceImpl portletPreference = new PortletPreferenceImpl(name, readOnly, values.toArray(new String[values.size()]));
                preferences.add(portletPreference);
            }
        }
        IPortletDefinitionRegistry portletDefinitionRegistry = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry();
        IPortletDefinition portletDefinition = portletDefinitionRegistry.getPortletDefinition(ci.chanDef.getId());
        IPortletPreferences portletPreferences = portletDefinition.getPortletPreferences();
        portletPreferences.setPortletPreferences(preferences);
    }

    private void getGroups(ChannelInfo ci, Element pele) throws Exception {
        NodeList anodes = pele.getElementsByTagName("group");
        if (anodes.getLength() != 0) {
            ci.groups = new IEntityGroup[anodes.getLength()];
            for (int j = 0; j < anodes.getLength(); ++j) {
                Element anode = (Element)anodes.item(j);
                String groupStr = XML.getElementText(anode).trim();
                IEntityGroup group = ChannelPublisher.getGroup(groupStr, IPerson.class);
                if (group == null) {
                    throw new Exception("Invalid entry '" + groupStr + "' for group.");
                }
                ci.groups[j] = group;
            }
        }
    }

    private void getUsers(ChannelInfo ci, Element pele) throws Exception {
        NodeList anodes = pele.getElementsByTagName("user");
        if (anodes.getLength() != 0) {
            ci.users = new IEntity[anodes.getLength()];
            for (int j = 0; j < anodes.getLength(); ++j) {
                Element anode = (Element)anodes.item(j);
                String userStr = XML.getElementText(anode).trim();
                IEntity user = GroupService.getEntity(userStr, IPerson.class);
                if (user == null) {
                    throw new Exception("Invalid entry '" + userStr + "' for user.");
                }
                ci.users[j] = user;
            }
        }
    }

    private IEntityGroup[] getAdminGroup() throws Exception {
        String dg = GroupService.PORTAL_ADMINISTRATORS;
        IEntityGroup e = GroupService.getDistinguishedGroup(dg);
        return new IEntityGroup[]{e};
    }

    private ChannelCategory[] getDefaultCategory(boolean fNameAccessibleOnly) throws Exception {
        ChannelCategory rootCat = this.crs.getTopLevelChannelCategory();
        if (fNameAccessibleOnly) {
            return new ChannelCategory[]{rootCat};
        }
        ChannelCategory[] topCats = this.crs.getChildCategories(rootCat);
        ChannelCategory autoCat = null;
        for (int i = 0; i < topCats.length; ++i) {
            if (!topCats[i].getName().equals("Auto-Published")) continue;
            autoCat = topCats[i];
            break;
        }
        if (autoCat == null) {
            autoCat = this.crs.newChannelCategory("Auto-Published", "Holds Auto-published Channels.", "system");
            this.crs.addCategoryToCategory(autoCat, rootCat);
        }
        return new ChannelCategory[]{autoCat};
    }

    private static IEntityGroup getGroup(String groupName, Class<? extends IBasicEntity> entityType) throws Exception {
        IEntityGroup group = null;
        EntityIdentifier[] groups = GroupService.searchForGroups(groupName, 1, entityType);
        group = groups != null && groups.length > 0 ? GroupService.findGroup(groups[0].getKey()) : GroupService.findGroup(groupName);
        return group;
    }

    private void initChanTypeMap() throws Exception {
        if (this.chanTypesNamesToIds == null) {
            this.chanTypesNamesToIds = new HashMap<String, Integer>();
            List<IChannelType> types = this.crs.getChannelTypes();
            for (IChannelType type : types) {
                this.chanTypesNamesToIds.put(type.getName(), new Integer(type.getId()));
            }
        }
    }

    private ChannelPublisher(boolean onCommandLine) throws Exception {
        this.mOnCommandLine = onCommandLine;
        this.crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
        this.initChanTypeMap();
        this.setupSystemUser();
        this.setupDomParser();
    }

    @Override
    public void setOverride(boolean b) {
        this.mOverrideExisting = b;
    }

    public static IChannelPublisher getCommandLineInstance() throws Exception {
        ChannelPublisher publisher = new ChannelPublisher(true);
        publisher.setOverride(true);
        return ChannelPublisher.wrapChannelPublisher(publisher);
    }

    public static IChannelPublisher getChannelArchiveInstance() throws Exception {
        ChannelPublisher publisher = new ChannelPublisher(false);
        publisher.setOverride(true);
        return ChannelPublisher.wrapChannelPublisher(publisher);
    }

    private static IChannelPublisher wrapChannelPublisher(IChannelPublisher channelPublisher) {
        JpaInterceptor jpaInterceptor = JpaInterceptorLocator.getJpaInterceptor();
        ProxyFactoryBean pfb = new ProxyFactoryBean();
        pfb.setTarget((Object)channelPublisher);
        pfb.setInterfaces((Class[])channelPublisher.getClass().getInterfaces());
        pfb.addAdvice((Advice)jpaInterceptor);
        return (IChannelPublisher)pfb.getObject();
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Warning occurred while parsing channel definition.", (Throwable)arg0);
        }
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
        throw new SAXException("Error occurred while parsing channel definition.", arg0);
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
        throw new SAXException("Fatal Error occurred while parsing channel definition.", arg0);
    }

    private static class ChannelInfo {
        IChannelDefinition chanDef;
        IEntityGroup[] groups;
        ChannelCategory[] categories;
        boolean fNameAccessibleOnly = false;
        IEntity[] users;

        private ChannelInfo() {
        }
    }
}

