/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools;

import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;

public class RegisterStylesheet {
    public static void main(String[] args) {
        String stylesheetURI = null;
        String stylesheetDescriptionURI = null;
        int stylesheetId = -1;
        boolean isTheme = true;
        boolean update = false;
        boolean delete = false;
        if (args.length < 3) {
            RegisterStylesheet.printHelp();
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                if (update) {
                    if (i <= 1 || args.length < i + 3) {
                        RegisterStylesheet.printHelp();
                    }
                    stylesheetURI = args[i];
                    stylesheetDescriptionURI = args[++i];
                    stylesheetId = Integer.parseInt(args[++i]);
                    continue;
                }
                if (delete) {
                    stylesheetId = Integer.parseInt(args[i]);
                    continue;
                }
                if (i < 1 || args.length < i + 2) {
                    RegisterStylesheet.printHelp();
                }
                stylesheetURI = args[i];
                stylesheetDescriptionURI = args[++i];
                continue;
            }
            if (args[i].equals("-s")) {
                isTheme = false;
                continue;
            }
            if (args[i].equals("-t")) {
                isTheme = true;
                continue;
            }
            if (args[i].equals("-u")) {
                update = true;
                continue;
            }
            if (args[i].equals("-d")) {
                delete = true;
                continue;
            }
            RegisterStylesheet.printHelp();
            return;
        }
        if (delete) {
            if (stylesheetId == -1) {
                RegisterStylesheet.printHelp();
                return;
            }
        } else if (stylesheetURI == null || stylesheetDescriptionURI == null) {
            RegisterStylesheet.printHelp();
            return;
        }
        IUserLayoutStore ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        try {
            if (update) {
                if (isTheme) {
                    ulsdb.updateThemeStylesheetDescription(stylesheetDescriptionURI, stylesheetURI, stylesheetId);
                } else {
                    ulsdb.updateStructureStylesheetDescription(stylesheetDescriptionURI, stylesheetURI, stylesheetId);
                }
                if (isTheme) {
                    ThemeStylesheetDescription tsd = UserLayoutStoreFactory.getUserLayoutStoreImpl().getThemeStylesheetDescription(stylesheetId);
                } else {
                    StructureStylesheetDescription ssd = UserLayoutStoreFactory.getUserLayoutStoreImpl().getStructureStylesheetDescription(stylesheetId);
                }
            } else if (delete) {
                if (isTheme) {
                    ulsdb.removeThemeStylesheetDescription(stylesheetId);
                } else {
                    ulsdb.removeStructureStylesheetDescription(stylesheetId);
                }
            } else {
                Integer id = null;
                id = isTheme ? ulsdb.addThemeStylesheetDescription(stylesheetDescriptionURI, stylesheetURI) : ulsdb.addStructureStylesheetDescription(stylesheetDescriptionURI, stylesheetURI);
                if (id == null) {
                    System.out.println("Save failed!");
                    return;
                }
                stylesheetId = id;
                System.out.println("Save successfull! The new stylehseet was assigned Id=" + id);
                if (isTheme) {
                    ThemeStylesheetDescription tsd = UserLayoutStoreFactory.getUserLayoutStoreImpl().getThemeStylesheetDescription(stylesheetId);
                } else {
                    StructureStylesheetDescription ssd = UserLayoutStoreFactory.getUserLayoutStoreImpl().getStructureStylesheetDescription(stylesheetId);
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error has been encountered:");
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: RegisterStylesheet -(s|t) [-(u|d)] [stylesheetURI] [stylesheetDescriptionURI] [stylesheetId]");
        System.out.println("The stylesheetId must be specified for update and delete operations.");
        System.out.println("The URIs must be specified for add and update operations.");
        System.out.println("The CLASSPATH environment variable should be set up to include\nboth \"uPortal/build\" and \"uPortal/build/WEB-INF/classes\" dirs.\n\nFor deployment all stylesheets are moved under the \"/stylesheet/\" directory,\nso the URI for a stylesheet will always begin with \"/stylesheet/\", unless\nyou're specifying a global URL (which is not recommended).\nStylesheet description files (.sdf) are moved to the same location, so\ntheir URI should be specified in the same manner.\n\nFor example to specify a URI for a tab-column.xsl (part of the distribution),\nuse \"/stylesheets/org/jasig/portal/layout/tab-column/tab-column.xsl\".\n");
        System.out.println("Flag specification:");
        System.out.println("\t-s : process structure stylesheet (either \"-t\" or \"-s\" are required on the command line)");
        System.out.println("\t-t : process theme stylesheet (either \"-t\" or \"-s\" are required on the command line)");
        System.out.println("\t-u : update stylesheet definition");
        System.out.println("\t-d : delete stylesheet definition");
        System.exit(0);
    }
}

