/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.servlet.view;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.XMLWriter;
import org.springframework.web.servlet.view.AbstractView;

public class XmlView
extends AbstractView {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String xmlKey = "xml";

    public XmlView() {
        this.setContentType("text/xml;charset=ISO-8859-1");
    }

    public void setXmlKey(String xmlKey) {
        this.xmlKey = xmlKey;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        ServletOutputStream output = response.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)output, "ISO-8859-1");
        Object obj = model.get(this.xmlKey);
        if (obj instanceof Document) {
            Document document = (Document)model.get(this.xmlKey);
            try {
                XMLWriter writer = new XMLWriter((Writer)out);
                writer.write(document);
                writer.flush();
            }
            catch (IOException ex) {
                this.logger.error((Object)"IOException writing XML", (Throwable)ex);
            }
        } else if (obj instanceof String) {
            String xml = (String)model.get(this.xmlKey);
            out.write(xml);
            out.flush();
        }
    }
}

