/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.web.context.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class FailsafeSingletonScope
implements Scope,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, InstanceHolder> instances = new HashMap<String, InstanceHolder>();
    private final Scope delegateScope;

    public FailsafeSingletonScope(Scope delegateScope) {
        this.delegateScope = delegateScope;
    }

    public void destroy() throws Exception {
        for (InstanceHolder instanceHolder : this.instances.values()) {
            if (instanceHolder.destructionCallback == null) continue;
            try {
                instanceHolder.destructionCallback.run();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Destruction callback for bean named '" + instanceHolder.name + "' failed."), (Throwable)e);
            }
        }
        this.instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        try {
            return this.delegateScope.get(name, objectFactory);
        }
        catch (IllegalStateException ise) {
            Map<String, InstanceHolder> map = this.instances;
            synchronized (map) {
                InstanceHolder instanceHolder = this.instances.get(name);
                if (instanceHolder == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Creating singleton instance for bean '" + name + "'"));
                    }
                    instanceHolder = new InstanceHolder(name);
                    this.instances.put(name, instanceHolder);
                    instanceHolder.instance = objectFactory.getObject();
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Using existing singleton instance for bean '" + name + "'"));
                }
                return instanceHolder.instance;
            }
        }
    }

    public String getConversationId() {
        try {
            return this.delegateScope.getConversationId();
        }
        catch (IllegalStateException ise) {
            return "NO_SESSION_SINGLETON";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        block7: {
            try {
                this.delegateScope.registerDestructionCallback(name, callback);
            }
            catch (IllegalStateException ise) {
                InstanceHolder instanceHolder;
                Map<String, InstanceHolder> map = this.instances;
                synchronized (map) {
                    instanceHolder = this.instances.get(name);
                }
                if (instanceHolder != null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Adding destruction callback singleton for bean '" + name + "'"));
                    }
                    instanceHolder.destructionCallback = callback;
                }
                if (!this.logger.isInfoEnabled()) break block7;
                this.logger.info((Object)("Ignoring destruction callback for singleton bean '" + name + "' because there currently is no instance"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String name) {
        try {
            return this.delegateScope.remove(name);
        }
        catch (IllegalStateException ise) {
            InstanceHolder instanceHolder;
            Map<String, InstanceHolder> map = this.instances;
            synchronized (map) {
                instanceHolder = this.instances.remove(name);
            }
            if (instanceHolder != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Removing singleton bean '" + name + "'"));
                }
                return instanceHolder.instance;
            }
            return null;
        }
    }

    private static class InstanceHolder {
        public final String name;
        public Object instance;
        public Runnable destructionCallback;

        public InstanceHolder(String name) {
            this.name = name;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof InstanceHolder)) {
                return false;
            }
            InstanceHolder rhs = (InstanceHolder)object;
            return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(217891979, 1307635269).append((Object)this.name).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("instance", this.instance).append("destructionCallback", (Object)this.destructionCallback).toString();
        }
    }
}

