/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.beans.factory;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public class MediatingFactoryBean
extends AbstractFactoryBean
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private List<String> delegateBeanNames;
    private Class<?> type = null;

    public List<String> getDelegateBeanNames() {
        return this.delegateBeanNames;
    }

    public void setDelegateBeanNames(List<String> delegateBeanNames) {
        this.delegateBeanNames = delegateBeanNames;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.delegateBeanNames, (String)"delegateBeanNames list cannot be empty");
        super.afterPropertiesSet();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Object createInstance() throws Exception {
        for (String beanName : this.delegateBeanNames) {
            try {
                Object bean = this.type == null ? this.applicationContext.getBean(beanName) : this.applicationContext.getBean(beanName, this.type);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loaded bean for name " + beanName));
                }
                return bean;
            }
            catch (Exception e) {
                String msg = "Failed to load bean '" + beanName + "' from ApplicationContext" + (this.type != null ? " expecting type: " + this.type : "") + ". Will try to load the next bean in the list instead. Error message from the attempt to load this bean ('" + beanName + "'): ";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)msg, (Throwable)e);
                    continue;
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)(msg + " " + e.getMessage() + " (enable debug for stack trace)"));
            }
        }
        throw new BeanCreationException("None of the configured bean names could be loaded. BeanNames: " + this.delegateBeanNames);
    }

    public Class<?> getObjectType() {
        return this.type;
    }
}

