/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.properties.PropertiesManager;

public class HttpClientManager {
    private static final Log log = LogFactory.getLog(HttpClientManager.class);
    private static final int POOL_SIZE = PropertiesManager.getPropertyAsInt("org.jasig.portal.services.HttpClientManager.poolSize", 20);
    private static final int HOST_CONNECTIONS = PropertiesManager.getPropertyAsInt("org.jasig.portal.services.HttpClientManager.hostConnections", 2);
    private static final int DEFAULT_CONNECTION_TIMEOUT = PropertiesManager.getPropertyAsInt("org.jasig.portal.services.HttpClientManager.connectionTimeout", 5000);
    private static final int DEFAULT_READ_TIMEOUT = PropertiesManager.getPropertyAsInt("org.jasig.portal.services.HttpClientManager.readTimeout", 2000);
    private static final String PROXY_HOST = PropertiesManager.getProperty("org.jasig.portal.services.HttpClientManager.proxyHost", null);
    private static final int PROXY_PORT = PropertiesManager.getPropertyAsInt("org.jasig.portal.services.HttpClientManager.proxyPort", 8080);
    private static final MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();

    public static HttpClient getNewHTTPClient() {
        if (PROXY_HOST == null) {
            return new HttpClient((HttpConnectionManager)connectionManager);
        }
        HttpClient result = new HttpClient((HttpConnectionManager)connectionManager);
        result.getHostConfiguration().setProxy(PROXY_HOST, PROXY_PORT);
        return result;
    }

    public static int getActiveConnections() {
        return connectionManager.getConnectionsInPool();
    }

    public static int getMaxConnections() {
        return POOL_SIZE;
    }

    static {
        HttpConnectionManagerParams pars = connectionManager.getParams();
        pars.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
        pars.setSoTimeout(DEFAULT_READ_TIMEOUT);
        pars.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        pars.setMaxTotalConnections(POOL_SIZE);
        pars.setDefaultMaxConnectionsPerHost(HOST_CONNECTIONS);
    }
}

