/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.concurrency.IEntityLock;
import org.jasig.portal.concurrency.IEntityLockService;
import org.jasig.portal.concurrency.IEntityLockServiceFactory;
import org.jasig.portal.concurrency.LockingException;
import org.jasig.portal.properties.PropertiesManager;

public class EntityLockService {
    private static final Log log = LogFactory.getLog(EntityLockService.class);
    private static EntityLockService instance = null;
    private IEntityLockService lockService = null;

    private EntityLockService() throws LockingException {
        this.initialize();
    }

    private void initialize() throws LockingException {
        String eMsg = null;
        String factoryName = PropertiesManager.getProperty("org.jasig.portal.concurrency.IEntityLockServiceFactory", null);
        if (factoryName == null) {
            log.warn((Object)"Property org.jasig.portal.concurrency.IEntityLockServiceFactory not configured in PropertiesManager.  Defaulting to  org.jasig.portal.concurrency.locking.ReferenceEntityLockServiceFactory");
            factoryName = "org.jasig.portal.concurrency.locking.ReferenceEntityLockServiceFactory";
        }
        try {
            IEntityLockServiceFactory lockServiceFactory = (IEntityLockServiceFactory)Class.forName(factoryName).newInstance();
            this.lockService = lockServiceFactory.newLockService();
        }
        catch (Exception e) {
            eMsg = "EntityLockService.initialize(): Problem creating entity lock service...";
            log.error((Object)eMsg, (Throwable)e);
            throw new LockingException(eMsg, (Throwable)e);
        }
    }

    public static synchronized EntityLockService instance() throws LockingException {
        if (instance == null) {
            instance = new EntityLockService();
        }
        return instance;
    }

    public IEntityLock newReadLock(Class entityType, String entityKey, String owner) throws LockingException {
        return this.lockService.newLock(entityType, entityKey, 0, owner);
    }

    public IEntityLock newReadLock(Class entityType, String entityKey, String owner, int duration) throws LockingException {
        return this.lockService.newLock(entityType, entityKey, 0, owner, duration);
    }

    public IEntityLock newReadLock(EntityIdentifier entityID, String owner) throws LockingException {
        return this.lockService.newLock(entityID.getType(), entityID.getKey(), 0, owner);
    }

    public IEntityLock newReadLock(EntityIdentifier entityID, String owner, int durationSecs) throws LockingException {
        return this.lockService.newLock(entityID.getType(), entityID.getKey(), 0, owner, durationSecs);
    }

    public IEntityLock newWriteLock(Class entityType, String entityKey, String owner) throws LockingException {
        return this.lockService.newLock(entityType, entityKey, 1, owner);
    }

    public IEntityLock newWriteLock(Class entityType, String entityKey, String owner, int durationSecs) throws LockingException {
        return this.lockService.newLock(entityType, entityKey, 1, owner, durationSecs);
    }

    public IEntityLock newWriteLock(EntityIdentifier entityID, String owner) throws LockingException {
        return this.lockService.newLock(entityID.getType(), entityID.getKey(), 1, owner);
    }

    public IEntityLock newWriteLock(EntityIdentifier entityID, String owner, int durationSecs) throws LockingException {
        return this.lockService.newLock(entityID.getType(), entityID.getKey(), 1, owner, durationSecs);
    }
}

