/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.xslt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.xslt.IXalanGroupMembershipHelper;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Required;

public class XalanGroupMembershipHelperBean
implements IXalanGroupMembershipHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IChannelRegistryStore channelRegistryStore;

    public IChannelRegistryStore getChannelRegistryStore() {
        return this.channelRegistryStore;
    }

    @Required
    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    @Override
    public boolean isChannelDeepMemberOf(String fname, String groupKey) {
        IChannelDefinition channelDefinition;
        IEntityGroup distinguishedGroup = GroupService.findGroup(groupKey);
        if (distinguishedGroup == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No group found for key '" + groupKey + "'"));
            }
            return false;
        }
        try {
            channelDefinition = this.channelRegistryStore.getChannelDefinition(fname);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Caught exception while retrieving channel definition for fname '" + fname + "'"), (Throwable)e);
            return false;
        }
        if (channelDefinition == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No channel found for key '" + fname + "'"));
            }
            return false;
        }
        Integer channelId = channelDefinition.getId();
        IEntity entity = GroupService.getEntity(channelId.toString(), IChannelDefinition.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No channel found for id '" + channelId + "'"));
            }
            return false;
        }
        return distinguishedGroup.deepContains(entity);
    }

    @Override
    public boolean isUserDeepMemberOf(String userName, String groupKey) {
        IEntityGroup distinguishedGroup = GroupService.findGroup(groupKey);
        if (distinguishedGroup == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No group found for key '" + groupKey + "'"));
            }
            return false;
        }
        IEntity entity = GroupService.getEntity(userName, IPerson.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No user found for key '" + userName + "'"));
            }
            return false;
        }
        return distinguishedGroup.deepContains(entity);
    }

    @Override
    public boolean isUserDeepMemberOfGroupName(String userName, String groupName) {
        EntityIdentifier[] results = GroupService.searchForGroups(groupName, 1, IPerson.class);
        if (results == null || results.length == 0) {
            return false;
        }
        if (results.length > 1) {
            this.logger.warn((Object)(results.length + " groups were found for '" + groupName + "'. The first result will be used."));
        }
        IGroupMember group = GroupService.getGroupMember(results[0]);
        IEntity entity = GroupService.getEntity(userName, IPerson.class);
        if (entity == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No user found for key '" + userName + "'"));
            }
            return false;
        }
        return group.deepContains(entity);
    }
}

