/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider.cas;

import java.util.Enumeration;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.LocalConnectionContext;
import org.jasig.portal.security.provider.cas.CasProxyTicketAcquisitionException;
import org.jasig.portal.security.provider.cas.ICasSecurityContext;

public class CasConnectionContext
extends LocalConnectionContext {
    private ChannelStaticData staticData = null;
    private IPerson person = null;
    private ICasSecurityContext casSecurityContext = null;

    @Override
    public void init(ChannelStaticData sd) {
        this.staticData = sd;
        this.person = sd.getPerson();
        ISecurityContext ic = this.person.getSecurityContext();
        if (ic instanceof ICasSecurityContext && ic.isAuthenticated()) {
            this.casSecurityContext = (ICasSecurityContext)((Object)ic);
        }
        Enumeration en = ic.getSubContexts();
        while (en.hasMoreElements()) {
            ISecurityContext sctx = (ISecurityContext)en.nextElement();
            if (!(sctx instanceof ICasSecurityContext) || !sctx.isAuthenticated()) continue;
            this.casSecurityContext = (ICasSecurityContext)((Object)sctx);
        }
        if (this.casSecurityContext == null) {
            this.log.error((Object)"Unable to find authenticated ICasSecurityContext");
        }
    }

    @Override
    public String getDescriptor(String descriptor, ChannelRuntimeData rd) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getDescriptor(" + descriptor + ", " + rd + ")"));
        }
        if (rd.getHttpRequestMethod().equals("GET")) {
            String proxyTicket = null;
            if (this.casSecurityContext != null) {
                try {
                    proxyTicket = this.casSecurityContext.getCasServiceToken(descriptor);
                }
                catch (CasProxyTicketAcquisitionException casex) {
                    this.log.error((Object)"getDescriptor() - Error retreiving proxy ticket.", (Throwable)casex);
                }
            }
            if (descriptor == null) {
                return proxyTicket;
            }
            if (proxyTicket != null) {
                descriptor = descriptor.indexOf("?") != -1 ? descriptor + "&ticket=" + proxyTicket : descriptor + "?ticket=" + proxyTicket;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("returning from getDescriptor() with [" + descriptor + "]"));
        }
        return descriptor;
    }

    public String getDescriptor(String descriptor) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("entering getDescriptor(" + descriptor + ")"));
        }
        String proxyTicket = null;
        if (this.casSecurityContext != null) {
            try {
                String casUri = this.staticData.getParameter("upc_cas_service_uri");
                proxyTicket = casUri != null ? this.casSecurityContext.getCasServiceToken(casUri) : this.casSecurityContext.getCasServiceToken(descriptor);
            }
            catch (CasProxyTicketAcquisitionException casex) {
                this.log.error((Object)"CasConnectionContext::getDescriptor() - Error retreiving proxy ticket.", (Throwable)casex);
            }
        }
        if (proxyTicket != null) {
            descriptor = descriptor.indexOf("?") != -1 ? descriptor + "&ticket=" + proxyTicket : descriptor + "?ticket=" + proxyTicket;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("returning from getDescriptor() with [" + descriptor + "]"));
        }
        return descriptor;
    }

    public String getPostData(ChannelRuntimeData rd) {
        String proxyTicket = null;
        if (this.casSecurityContext != null) {
            try {
                String xmlUri = rd.getParameter("cw_xml");
                if (xmlUri == null) {
                    xmlUri = this.staticData.getParameter("cw_xml");
                }
                proxyTicket = this.casSecurityContext.getCasServiceToken(xmlUri);
            }
            catch (CasProxyTicketAcquisitionException casex) {
                this.log.error((Object)"sendLocalData() - Error retreiving proxy ticket.", (Throwable)casex);
            }
        }
        return "ticket=" + proxyTicket;
    }

    @Override
    public void sendLocalData(Object conParam, ChannelRuntimeData rd) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" staticData:");
        sb.append(this.staticData);
        sb.append(" person:");
        sb.append(this.person);
        sb.append(" casSecurityContext:");
        sb.append(this.casSecurityContext);
        return sb.toString();
    }
}

