/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.url;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.Constants;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.url.IPortletUrlSyntaxProvider;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.portlet.url.RequestType;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Required;

public class PortletUrlSyntaxProviderImpl
implements IPortletUrlSyntaxProvider {
    private static final String SEPERATOR = "_";
    private static final String PORTLET_CONTROL_PREFIX = "pltc_";
    private static final String PORTLET_PARAM_PREFIX = "pltp_";
    private static final String PARAM_REQUEST_TARGET = "pltc_target";
    private static final String PARAM_REQUEST_TYPE_PREFIX = "pltc_type";
    private static final String PARAM_WINDOW_STATE_PREFIX = "pltc_state";
    private static final String PARAM_PORTLET_MODE_PREFIX = "pltc_mode";
    private static final String PARAM_DELEGATE_PREFIX = "pltc_delegate";
    private static final Pattern URL_PARAM_NAME = Pattern.compile("&([^&?=\n]*)");
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String defaultEncoding = "UTF-8";
    private int bufferLength = 512;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IUserInstanceManager userInstanceManager;
    private IPortletDelegationManager portletDelegationManager;
    private boolean useAnchors = true;
    private Set<WindowState> transientWindowStates = new HashSet<WindowState>(Arrays.asList(IPortletAdaptor.EXCLUSIVE, IPortletAdaptor.DETACHED));
    private Set<WindowState> anchoringWindowStates = new HashSet<WindowState>(Arrays.asList(WindowState.MINIMIZED, WindowState.NORMAL));

    public boolean isUseAnchors() {
        return this.useAnchors;
    }

    public void setUseAnchors(boolean useAnchors) {
        this.useAnchors = useAnchors;
    }

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        Validate.notNull((Object)defaultEncoding, (String)"defaultEncoding can not be null");
        this.defaultEncoding = defaultEncoding;
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public void setBufferLength(int bufferLength) {
        if (bufferLength < 1) {
            throw new IllegalArgumentException("bufferLength must be at least 1");
        }
        this.bufferLength = bufferLength;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry, (String)"portletWindowRegistry can not be null");
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IUserInstanceManager getUserInstanceManager() {
        return this.userInstanceManager;
    }

    @Required
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public Set<WindowState> getTransientWindowStates() {
        return this.transientWindowStates;
    }

    public void setTransientWindowStates(Set<WindowState> transientWindowStates) {
        this.transientWindowStates = transientWindowStates == null ? Collections.emptySet() : new LinkedHashSet<WindowState>(transientWindowStates);
    }

    public Set<WindowState> getAnchoringWindowStates() {
        return this.anchoringWindowStates;
    }

    public void setAnchoringWindowStates(Set<WindowState> anchoringWindowStates) {
        this.anchoringWindowStates = anchoringWindowStates == null ? Collections.emptySet() : new LinkedHashSet<WindowState>(anchoringWindowStates);
    }

    public IPortletDelegationManager getPortletDelegationManager() {
        return this.portletDelegationManager;
    }

    public void setPortletDelegationManager(IPortletDelegationManager portletDelegationManager) {
        this.portletDelegationManager = portletDelegationManager;
    }

    @Override
    public PortletUrl parsePortletUrl(HttpServletRequest request) {
        Validate.notNull((Object)request, (String)"request can not be null");
        UrlTarget urlTarget = this.resolveTargetWindowId(request);
        if (urlTarget == null) {
            return null;
        }
        PortletUrl portletUrl = new PortletUrl(urlTarget.portletWindowId);
        this.parsePortletParameters(request, portletUrl, urlTarget);
        return portletUrl;
    }

    protected void parsePortletParameters(HttpServletRequest request, PortletUrl portletUrl, UrlTarget urlTarget) {
        String portletModeStr;
        String parameterNamespace;
        String controlNamespace;
        IPortletWindowId portletWindowId = portletUrl.getTargetWindowId();
        if (urlTarget != null && urlTarget.fnameTarget) {
            controlNamespace = "";
            parameterNamespace = "";
        } else {
            controlNamespace = SEPERATOR + portletWindowId.toString();
            parameterNamespace = portletWindowId.toString() + SEPERATOR;
        }
        String requestTypeStr = request.getParameter(PARAM_REQUEST_TYPE_PREFIX + controlNamespace);
        if (requestTypeStr != null) {
            RequestType requestType = RequestType.valueOf(requestTypeStr);
            portletUrl.setRequestType(requestType);
        } else {
            portletUrl.setRequestType(RequestType.RENDER);
        }
        String windowStateStr = request.getParameter(PARAM_WINDOW_STATE_PREFIX + controlNamespace);
        if (windowStateStr != null) {
            WindowState windowState = new WindowState(windowStateStr);
            portletUrl.setWindowState(windowState);
        }
        if ((portletModeStr = request.getParameter(PARAM_PORTLET_MODE_PREFIX + controlNamespace)) != null) {
            PortletMode portletMode = new PortletMode(portletModeStr);
            portletUrl.setPortletMode(portletMode);
        }
        Map requestParameters = request.getParameterMap();
        Set<String> urlParameterNames = this.getUrlParameterNames(request);
        LinkedHashMap<String, List<String>> portletParameters = new LinkedHashMap<String, List<String>>(requestParameters.size());
        String fqParameterName = PORTLET_PARAM_PREFIX + parameterNamespace;
        for (Map.Entry parameterEntry : requestParameters.entrySet()) {
            String parameterName = (String)parameterEntry.getKey();
            if (parameterName.startsWith(fqParameterName)) {
                String portletParameterName = parameterName.substring(fqParameterName.length());
                String[] portletParameterValues = (String[])parameterEntry.getValue();
                if (portletParameterValues == null) {
                    portletParameters.put(portletParameterName, null);
                    continue;
                }
                portletParameters.put(portletParameterName, Arrays.asList(portletParameterValues));
                continue;
            }
            if (urlParameterNames == null || urlParameterNames.contains(parameterName)) continue;
            String[] portletParameterValues = (String[])parameterEntry.getValue();
            if (portletParameterValues == null) {
                portletParameters.put(parameterName, null);
                continue;
            }
            portletParameters.put(parameterName, Arrays.asList(portletParameterValues));
        }
        portletUrl.setParameters(portletParameters);
        portletUrl.setSecure(request.isSecure());
        String delegateWindowIdStr = request.getParameter(PARAM_DELEGATE_PREFIX + controlNamespace);
        if (delegateWindowIdStr != null) {
            IPortletWindowId delegateWindowId = this.portletWindowRegistry.getPortletWindowId(delegateWindowIdStr);
            IPortletWindow delegateWindow = this.portletWindowRegistry.getPortletWindow(request, delegateWindowId);
            IPortletWindowId delegationParentId = delegateWindow.getDelegationParent();
            if (delegationParentId == null) {
                throw new IllegalArgumentException("Delegate window '" + delegateWindowId + "' has no parent. Parent specified in the URL is '" + portletWindowId + "'");
            }
            if (!portletWindowId.equals(delegationParentId)) {
                throw new IllegalArgumentException("Parent '" + delegationParentId + "' of delegate window '" + delegateWindowId + "' is not the parent specified in the URL: '" + portletWindowId + "'");
            }
            PortletUrl delegatePortletUrl = new PortletUrl(delegateWindowId);
            portletUrl.setDelegatePortletUrl(delegatePortletUrl);
            this.parsePortletParameters(request, delegatePortletUrl, null);
        }
    }

    protected UrlTarget resolveTargetWindowId(HttpServletRequest request) {
        String targetedPortletWindowIdStr = request.getParameter(PARAM_REQUEST_TARGET);
        if (targetedPortletWindowIdStr != null) {
            return new UrlTarget(this.portletWindowRegistry.getPortletWindowId(targetedPortletWindowIdStr), false);
        }
        String targetedFname = request.getParameter("uP_fname");
        if (targetedFname == null) {
            return null;
        }
        IUserInstance userInstance = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager preferencesManager = userInstance.getPreferencesManager();
        IUserLayoutManager userLayoutManager = preferencesManager.getUserLayoutManager();
        String channelSubscribeId = userLayoutManager.getSubscribeId(targetedFname);
        if (channelSubscribeId == null) {
            this.logger.info((Object)("No channel subscribe ID found for fname '" + targetedFname + "'. skipping portlet parameter processing"));
            return null;
        }
        IUserLayoutChannelDescription channelNode = (IUserLayoutChannelDescription)userLayoutManager.getNode(channelSubscribeId);
        String channelPublishId = channelNode.getChannelPublishId();
        IPortletDefinition portletDefinition = this.portletDefinitionRegistry.getPortletDefinition(Integer.parseInt(channelPublishId));
        if (!portletDefinition.getChannelDefinition().isPortlet()) {
            this.logger.info((Object)("No portlet defintion found for channel definition '" + channelPublishId + "' with fname '" + targetedFname + "'. skipping portlet parameter processing"));
            return null;
        }
        IPerson person = userInstance.getPerson();
        IPortletEntity portletEntity = this.portletEntityRegistry.getOrCreatePortletEntity(portletDefinition.getPortletDefinitionId(), channelSubscribeId, person.getID());
        IPortletWindow defaultPortletWindow = this.portletWindowRegistry.createDefaultPortletWindow(request, portletEntity.getPortletEntityId());
        return new UrlTarget(this.portletWindowRegistry.createTransientPortletWindowId(request, defaultPortletWindow.getPortletWindowId()), true);
    }

    protected Set<String> getUrlParameterNames(HttpServletRequest request) {
        String method = request.getMethod();
        if (!"POST".equals(method)) {
            return null;
        }
        HashSet<String> urlParameterNames = new HashSet<String>();
        String queryString = request.getQueryString();
        Matcher paramNameMatcher = URL_PARAM_NAME.matcher("&" + queryString);
        String encoding = this.getEncoding(request);
        while (paramNameMatcher.find()) {
            String decParamName;
            String paramName = paramNameMatcher.group(1);
            try {
                decParamName = URLDecoder.decode(paramName, encoding);
            }
            catch (UnsupportedEncodingException uee) {
                decParamName = paramName;
            }
            urlParameterNames.add(decParamName);
        }
        return urlParameterNames;
    }

    @Override
    public String generatePortletUrl(HttpServletRequest request, IPortletWindow portletWindow, PortletUrl portletUrl) {
        Validate.notNull((Object)request, (String)"request can not be null");
        Validate.notNull((Object)portletWindow, (String)"portletWindow can not be null");
        Validate.notNull((Object)portletUrl, (String)"portletUrl can not be null");
        request = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        if (Constants.METHOD_ACTION.equals(request.getAttribute("org.apache.pluto.core.method"))) {
            if (portletWindow.getDelegationParent() != null) {
                this.portletDelegationManager.setDelegatePortletActionRedirectUrl(request, portletUrl);
                return "DELEGATE_ACTION_REDIRECT";
            }
            PortletUrl delegatePortletUrl = this.portletDelegationManager.getDelegatePortletActionRedirectUrl(request);
            portletUrl.setDelegatePortletUrl(delegatePortletUrl);
        }
        StringBuilder url = new StringBuilder(this.bufferLength);
        String contextPath = request.getContextPath();
        url.append(contextPath).append("/");
        this.generatePortletUrl(request, portletWindow, null, portletUrl, url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated portlet URL '" + url + "' for IPortletWindow='" + portletWindow + "' and PortletUrl='" + portletUrl + "'. StringBuilder started with length " + this.bufferLength + " and ended with length " + url.capacity() + "."));
        }
        return url.toString();
    }

    protected void generatePortletUrl(HttpServletRequest request, IPortletWindow portletWindow, IPortletWindowId delegationChildId, PortletUrl portletUrl, StringBuilder url) {
        RequestType requestType;
        String portletWindowIdString;
        String encoding = this.getEncoding(request);
        IPortletWindowId delegationParentId = portletWindow.getDelegationParent();
        if (delegationParentId != null) {
            IPortletWindow delegateParent = this.portletWindowRegistry.getPortletWindow(request, delegationParentId);
            PortletUrl parentUrl = this.portletDelegationManager.getParentPortletUrl(request, delegationParentId);
            if (parentUrl == null) {
                parentUrl = new PortletUrl(delegationParentId);
                parentUrl.setWindowState(delegateParent.getWindowState());
                parentUrl.setPortletMode(delegateParent.getPortletMode());
                parentUrl.setParameters(delegateParent.getRequestParameters());
            }
            parentUrl.setRequestType(portletUrl.getRequestType());
            this.generatePortletUrl(request, delegateParent, portletWindow.getPortletWindowId(), parentUrl, url);
        }
        IPortletWindowId portletWindowId = portletWindow.getPortletWindowId();
        IPortletEntity parentPortletEntity = this.portletWindowRegistry.getParentPortletEntity(request, portletWindowId);
        String channelSubscribeId = parentPortletEntity.getChannelSubscribeId();
        WindowState windowState = portletUrl.getWindowState();
        PortletMode portletMode = portletUrl.getPortletMode();
        WindowState previousWindowState = portletWindow.getWindowState();
        PortletMode previousPortletMode = portletWindow.getPortletMode();
        if (delegationParentId == null) {
            String urlBase;
            UPFileSpec upFileSpec;
            String urlBase2;
            ChannelRuntimeData channelRuntimeData = (ChannelRuntimeData)request.getAttribute(IPortletAdaptor.ATTRIBUTE__RUNTIME_DATA);
            if (channelRuntimeData == null) {
                throw new IllegalStateException("No ChannelRuntimeData was found as a request attribute for key '" + IPortletAdaptor.ATTRIBUTE__RUNTIME_DATA + "' on request '" + request + "'");
            }
            if (IPortletAdaptor.EXCLUSIVE.equals((Object)windowState) || windowState == null && IPortletAdaptor.EXCLUSIVE.equals((Object)previousWindowState)) {
                urlBase2 = channelRuntimeData.getBaseWorkerURL("download");
                url.append(urlBase2);
            } else if (IPortletAdaptor.DETACHED.equals((Object)windowState) || windowState == null && IPortletAdaptor.DETACHED.equals((Object)previousWindowState)) {
                upFileSpec = new UPFileSpec(channelRuntimeData.getUPFile());
                upFileSpec.setMethodNodeId(channelSubscribeId);
                upFileSpec.setTargetNodeId(channelSubscribeId);
                urlBase = upFileSpec.getUPFile();
                url.append(urlBase);
            } else if (IPortletAdaptor.DETACHED.equals((Object)previousWindowState) && windowState != null && !previousWindowState.equals((Object)windowState)) {
                upFileSpec = new UPFileSpec(channelRuntimeData.getUPFile());
                upFileSpec.setMethodNodeId("userLayoutRootNode");
                urlBase = upFileSpec.getUPFile();
                url.append(urlBase);
            } else {
                urlBase2 = channelRuntimeData.getBaseActionURL();
                url.append(urlBase2);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Using root url base '" + url + "' for " + portletUrl));
            }
        }
        boolean forceWindowState = false;
        if (delegationParentId != null) {
            portletWindowIdString = portletWindowId.toString();
        } else if (this.transientWindowStates.contains(windowState) && !this.transientWindowStates.contains(previousWindowState)) {
            IPortletWindowId transientPortletWindowId = this.portletWindowRegistry.createTransientPortletWindowId(request, portletWindowId);
            portletWindowIdString = transientPortletWindowId.toString();
        } else if (!(!this.portletWindowRegistry.isTransient(request, portletWindowId) || this.transientWindowStates.contains(windowState) || windowState == null && this.transientWindowStates.contains(previousWindowState))) {
            IPortletEntityId portletEntityId = portletWindow.getPortletEntityId();
            IPortletWindowId defaultPortletWindowId = this.portletWindowRegistry.getDefaultPortletWindowId(portletEntityId);
            portletWindowIdString = defaultPortletWindowId.getStringId();
            if (windowState == null) {
                IPortletWindow defaultPortletWindow = this.portletWindowRegistry.getPortletWindow(request, defaultPortletWindowId);
                if (!previousWindowState.equals((Object)defaultPortletWindow.getWindowState())) {
                    forceWindowState = true;
                    windowState = previousWindowState;
                }
                if (!previousPortletMode.equals((Object)defaultPortletWindow.getPortletMode())) {
                    portletMode = previousPortletMode;
                }
            }
        } else {
            portletWindowIdString = portletWindowId.getStringId();
        }
        if (delegationParentId == null) {
            this.encodeAndAppend(url.append("?"), encoding, PARAM_REQUEST_TARGET, portletWindowIdString);
        }
        if (delegationChildId != null) {
            this.encodeAndAppend(url.append("&"), encoding, "pltc_delegate_" + portletWindowIdString, delegationChildId.toString());
        }
        String requestTypeString = (requestType = portletUrl.getRequestType()) != null ? requestType.toString() : RequestType.RENDER.toString();
        this.encodeAndAppend(url.append("&"), encoding, "pltc_type_" + portletWindowIdString, requestTypeString);
        if (windowState != null && (forceWindowState || !previousWindowState.equals((Object)windowState))) {
            this.encodeAndAppend(url.append("&"), encoding, "pltc_state_" + portletWindowIdString, windowState.toString());
            if (delegationParentId == null) {
                if (WindowState.MAXIMIZED.equals((Object)windowState)) {
                    this.encodeAndAppend(url.append("&"), encoding, "uP_root", channelSubscribeId);
                } else if (WindowState.NORMAL.equals((Object)windowState)) {
                    this.encodeAndAppend(url.append("&"), encoding, "uP_root", "root");
                    this.encodeAndAppend(url.append("&"), encoding, "uP_tcattr", "minimized");
                    this.encodeAndAppend(url.append("&"), encoding, "minimized_channelId", channelSubscribeId);
                    this.encodeAndAppend(url.append("&"), encoding, "minimized_" + channelSubscribeId + "_value", "false");
                    this.encodeAndAppend(url.append("&"), encoding, "uP_save", "all");
                } else if (WindowState.MINIMIZED.equals((Object)windowState)) {
                    this.encodeAndAppend(url.append("&"), encoding, "uP_root", "root");
                    this.encodeAndAppend(url.append("&"), encoding, "uP_tcattr", "minimized");
                    this.encodeAndAppend(url.append("&"), encoding, "minimized_channelId", channelSubscribeId);
                    this.encodeAndAppend(url.append("&"), encoding, "minimized_" + channelSubscribeId + "_value", "true");
                    this.encodeAndAppend(url.append("&"), encoding, "uP_save", "all");
                } else if (IPortletAdaptor.DETACHED.equals((Object)windowState)) {
                    this.encodeAndAppend(url.append("&"), encoding, "uP_detach_target", channelSubscribeId);
                }
            }
        } else if (this.transientWindowStates.contains(windowState) || this.transientWindowStates.contains(previousWindowState)) {
            this.encodeAndAppend(url.append("&"), encoding, "pltc_state_" + portletWindowIdString, previousWindowState.toString());
        }
        if (portletMode != null) {
            this.encodeAndAppend(url.append("&"), encoding, "pltc_mode_" + portletWindowIdString, portletMode.toString());
        } else if (this.transientWindowStates.contains(windowState) || this.transientWindowStates.contains(previousWindowState)) {
            this.encodeAndAppend(url.append("&"), encoding, "pltc_mode_" + portletWindowIdString, portletWindow.getPortletMode().toString());
        }
        Map<String, List<String>> parameters = portletUrl.getParameters();
        if (parameters != null) {
            for (Map.Entry<String, List<String>> parameterEntry : parameters.entrySet()) {
                String name = parameterEntry.getKey();
                List<String> values = parameterEntry.getValue();
                this.encodeAndAppend(url.append("&"), encoding, PORTLET_PARAM_PREFIX + portletWindowIdString + SEPERATOR + name, values);
            }
        }
        if (this.useAnchors && delegationParentId == null && !RequestType.ACTION.equals((Object)requestType) && (windowState != null && this.anchoringWindowStates.contains(windowState) || windowState == null && this.anchoringWindowStates.contains(previousWindowState))) {
            url.append("#").append(channelSubscribeId);
        }
    }

    protected String getEncoding(HttpServletRequest request) {
        String encoding = request.getCharacterEncoding();
        if (encoding != null) {
            return encoding;
        }
        return this.defaultEncoding;
    }

    protected void encodeAndAppend(StringBuilder url, String encoding, String name, String ... values) {
        this.encodeAndAppend(url, encoding, name, Arrays.asList(values));
    }

    protected void encodeAndAppend(StringBuilder url, String encoding, String name, List<String> values) {
        try {
            name = URLEncoder.encode(name, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to encode portlet URL parameter name '" + name + "' for encoding '" + encoding + "'");
        }
        if (values.size() == 0) {
            url.append(name).append("=");
        } else {
            boolean first = true;
            for (String value : values) {
                if (value == null) {
                    value = "";
                }
                try {
                    value = URLEncoder.encode(value, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Failed to encode portlet URL parameter value '" + value + "' for encoding '" + encoding + "'");
                }
                if (!first) {
                    url.append("&");
                }
                url.append(name).append("=").append(value);
                first = false;
            }
        }
    }

    private static class UrlTarget {
        public final IPortletWindowId portletWindowId;
        public final boolean fnameTarget;

        private UrlTarget(IPortletWindowId portletWindowId, boolean fnameTarget) {
            this.portletWindowId = portletWindowId;
            this.fnameTarget = fnameTarget;
        }
    }
}

