/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.delegation;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.core.ContainerInvocation;
import org.jasig.portal.api.portlet.DelegateState;
import org.jasig.portal.api.portlet.DelegationActionResponse;
import org.jasig.portal.api.portlet.DelegationRequest;
import org.jasig.portal.api.portlet.DelegationResponse;
import org.jasig.portal.api.portlet.PortletDelegationDispatcher;
import org.jasig.portal.portlet.delegation.IPortletDelegationManager;
import org.jasig.portal.portlet.delegation.RedirectCapturingResponse;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;

public class PortletDelegationDispatcherImpl
implements PortletDelegationDispatcher {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IPortletWindow portletWindow;
    private final IPortletWindow parentPortletWindow;
    private final int userId;
    private final IPortalRequestUtils portalRequestUtils;
    private final IPersonManager personManager;
    private final IPortletRenderer portletRenderer;
    private final IPortletRequestParameterManager portletRequestParameterManager;
    private final IPortletDelegationManager portletDelegationManager;

    public PortletDelegationDispatcherImpl(IPortletWindow portletWindow, IPortletWindow parentPortletWindow, int userId, IPortalRequestUtils portalRequestUtils, IPersonManager personManager, IPortletRenderer portletRenderer, IPortletRequestParameterManager portletRequestParameterManager, IPortletDelegationManager portletDelegationManager) {
        Validate.notNull((Object)portletWindow, (String)"portletWindow can not be null");
        Validate.notNull((Object)parentPortletWindow, (String)"parentPortletWindow can not be null");
        Validate.notNull((Object)portalRequestUtils, (String)"portalRequestUtils can not be null");
        Validate.notNull((Object)personManager, (String)"personManager can not be null");
        Validate.notNull((Object)portletRenderer, (String)"portletRenderer can not be null");
        Validate.notNull((Object)portletRequestParameterManager, (String)"portletRequestParameterManager can not be null");
        Validate.notNull((Object)portletDelegationManager, (String)"portletDelegationManager can not be null");
        this.portletWindow = portletWindow;
        this.parentPortletWindow = parentPortletWindow;
        this.userId = userId;
        this.portalRequestUtils = portalRequestUtils;
        this.personManager = personManager;
        this.portletRenderer = portletRenderer;
        this.portletRequestParameterManager = portletRequestParameterManager;
        this.portletDelegationManager = portletDelegationManager;
    }

    @Override
    public DelegationActionResponse doAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        return this.doAction(actionRequest, actionResponse, null);
    }

    @Override
    public DelegationActionResponse doAction(ActionRequest actionRequest, ActionResponse actionResponse, DelegationRequest delegationRequest) throws IOException {
        HttpServletRequest request = this.portalRequestUtils.getOriginalPortalRequest((PortletRequest)actionRequest);
        HttpServletResponse response = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)actionRequest);
        IPerson person = this.personManager.getPerson(request);
        if (this.userId != person.getID()) {
            throw new IllegalStateException("This dispatcher was created for userId " + this.userId + " but is being executed for userId " + person.getID());
        }
        this.setupDelegateRequestInfo(request, delegationRequest);
        RedirectCapturingResponse capturingResponse = new RedirectCapturingResponse(response);
        ContainerInvocation invocation = ContainerInvocation.getInvocation();
        try {
            this.portletRenderer.doAction(this.portletWindow.getPortletWindowId(), request, (HttpServletResponse)capturingResponse);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to execute action on delegate", (Throwable)e);
            throw e;
        }
        finally {
            if (invocation != null) {
                ContainerInvocation.setInvocation((PortletContainer)invocation.getPortletContainer(), (PortletWindow)invocation.getPortletWindow());
            }
        }
        String redirectLocation = capturingResponse.getRedirectLocation();
        if (!"DELEGATE_ACTION_REDIRECT".equals(redirectLocation)) {
            actionResponse.sendRedirect(redirectLocation);
            return new DelegationActionResponse(this.getDelegateState(), redirectLocation);
        }
        PortletUrl portletUrl = this.portletDelegationManager.getDelegatePortletActionRedirectUrl((PortletRequest)actionRequest);
        return new DelegationActionResponse(this.getDelegateState(), portletUrl);
    }

    @Override
    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException {
        return this.doRender(renderRequest, renderResponse, null, renderResponse.getWriter());
    }

    @Override
    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, Writer writer) throws IOException {
        return this.doRender(renderRequest, renderResponse, null, writer);
    }

    @Override
    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, DelegationRequest delegationRequest) throws IOException {
        return this.doRender(renderRequest, renderResponse, delegationRequest, renderResponse.getWriter());
    }

    @Override
    public DelegationResponse doRender(RenderRequest renderRequest, RenderResponse renderResponse, DelegationRequest delegationRequest, Writer writer) throws IOException {
        HttpServletRequest request = this.portalRequestUtils.getOriginalPortletAdaptorRequest((PortletRequest)renderRequest);
        HttpServletResponse response = this.portalRequestUtils.getOriginalPortalResponse((PortletRequest)renderRequest);
        IPerson person = this.personManager.getPerson(request);
        if (this.userId != person.getID()) {
            throw new IllegalStateException("This dispatcher was created for userId " + this.userId + " but is being executed for userId " + person.getID());
        }
        this.setupDelegateRequestInfo(request, delegationRequest);
        ContainerInvocation invocation = ContainerInvocation.getInvocation();
        try {
            this.portletRenderer.doRender(this.portletWindow.getPortletWindowId(), request, response, writer);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)"Failed to render delegate", (Throwable)e);
            throw e;
        }
        finally {
            if (invocation != null) {
                ContainerInvocation.setInvocation((PortletContainer)invocation.getPortletContainer(), (PortletWindow)invocation.getPortletWindow());
            }
            writer.flush();
        }
        return new DelegationResponse(this.getDelegateState());
    }

    @Override
    public DelegateState getDelegateState() {
        return new DelegateState(this.portletWindow.getPortletMode(), this.portletWindow.getWindowState());
    }

    @Override
    public IPortletWindowId getPortletWindowId() {
        return this.portletWindow.getPortletWindowId();
    }

    protected void setupDelegateRequestInfo(HttpServletRequest request, DelegationRequest delegationRequest) {
        Map<String, List<String>> parentParameters;
        PortletMode parentPortletMode;
        WindowState parentWindowState;
        if (delegationRequest == null) {
            return;
        }
        IPortletWindowId parentPortletWindowId = this.parentPortletWindow.getPortletWindowId();
        PortletUrl parentPortletUrl = new PortletUrl(parentPortletWindowId);
        this.portletDelegationManager.setParentPortletUrl(request, parentPortletUrl);
        DelegateState delegateState = delegationRequest.getDelegateState();
        if (delegateState != null) {
            IPortletWindowId portletWindowId = this.portletWindow.getPortletWindowId();
            PortletUrl delegatePortletUrl = this.portletRequestParameterManager.getPortletRequestInfo(request, portletWindowId);
            if (delegatePortletUrl == null) {
                delegatePortletUrl = new PortletUrl(portletWindowId);
                this.portletRequestParameterManager.setAdditionalPortletUrl(request, delegatePortletUrl);
            }
            parentPortletUrl.setDelegatePortletUrl(delegatePortletUrl);
            PortletMode mode = delegateState.getPortletMode();
            delegatePortletUrl.setPortletMode(mode);
            WindowState state = delegateState.getWindowState();
            delegatePortletUrl.setWindowState(state);
        }
        if ((parentWindowState = delegationRequest.getParentWindowState()) != null) {
            parentPortletUrl.setWindowState(parentWindowState);
        }
        if ((parentPortletMode = delegationRequest.getParentPortletMode()) != null) {
            parentPortletUrl.setPortletMode(parentPortletMode);
        }
        if ((parentParameters = delegationRequest.getParentParameters()) != null) {
            parentPortletUrl.setParameters(parentParameters);
        }
    }
}

