/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.Parameter;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;

@Entity
@Table(name="UP_PORTLET_PREFS")
@GenericGenerator(name="UP_PORTLET_PREFS_GEN", strategy="native", parameters={@Parameter(name="sequence", value="UP_PORTLET_PREFS_SEQ"), @Parameter(name="table", value="UP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_UP_PORTLET_PREFS_HI")})
public class PortletPreferencesImpl
implements IPortletPreferences {
    @Id
    @GeneratedValue(generator="UP_PORTLET_PREFS_GEN")
    @Column(name="PORTLET_PREFS_ID")
    private final long portletPreferencesId;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=PortletPreferenceImpl.class, fetch=FetchType.EAGER)
    @JoinColumn(name="PORTLET_PREFS_ID")
    @IndexColumn(name="PREF_ORDER")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<IPortletPreference> portletPreferences = new ArrayList<IPortletPreference>(0);

    public PortletPreferencesImpl() {
        this.portletPreferencesId = -1L;
    }

    @Override
    public List<IPortletPreference> getPortletPreferences() {
        return this.portletPreferences;
    }

    @Override
    public void setPortletPreferences(List<IPortletPreference> newPreferences) {
        Validate.notNull(this.portletPreferences);
        if (this.portletPreferences == null) {
            this.portletPreferences = newPreferences;
        } else if (this.portletPreferences != newPreferences) {
            LinkedHashMap<String, IPortletPreference> oldPreferences = new LinkedHashMap<String, IPortletPreference>();
            for (IPortletPreference preference : this.portletPreferences) {
                oldPreferences.put(preference.getName(), preference);
            }
            this.portletPreferences.clear();
            for (IPortletPreference preference : newPreferences) {
                String name = preference.getName();
                IPortletPreference existingPreference = (IPortletPreference)oldPreferences.remove(name);
                if (existingPreference == null) {
                    this.portletPreferences.add(preference);
                    continue;
                }
                existingPreference.setValues(preference.getValues());
                existingPreference.setReadOnly(preference.isReadOnly());
                this.portletPreferences.add(existingPreference);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletPreferences)) {
            return false;
        }
        IPortletPreferences rhs = (IPortletPreferences)object;
        return new EqualsBuilder().append(this.portletPreferences, rhs.getPortletPreferences()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1904185833, -1222355625).append(this.portletPreferences).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("portletPreferencesId", this.portletPreferencesId).append("portletPreferences", this.portletPreferences).toString();
    }
}

