/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.dao.IChannelDefinitionDao;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaPortletDefinitionDao
implements IPortletDefinitionDao {
    private static final String FIND_PORTLET_DEF_BY_CHANNEL_DEF = "from PortletDefinitionImpl portDef where portDef.channelDefinition = :channelDefinition";
    private static final String FIND_PORTLET_DEF_BY_CHANNEL_DEF_CACHE_REGION = PortletDefinitionImpl.class.getName() + ".query.FIND_PORTLET_DEF_BY_CHANNEL_DEF";
    private EntityManager entityManager;
    private IChannelDefinitionDao channelDefinitionDao;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Required
    public void setChannelDefinitionDao(IChannelDefinitionDao channelDefinitionDao) {
        this.channelDefinitionDao = channelDefinitionDao;
    }

    @Override
    public IPortletDefinition getPortletDefinition(int channelPublishId) {
        IChannelDefinition channelDefinition = this.channelDefinitionDao.getChannelDefinition(channelPublishId);
        Query query = this.entityManager.createQuery(FIND_PORTLET_DEF_BY_CHANNEL_DEF);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_PORTLET_DEF_BY_CHANNEL_DEF_CACHE_REGION);
        query.setParameter("channelDefinition", (Object)channelDefinition);
        List portletEntities = query.getResultList();
        return (IPortletDefinition)DataAccessUtils.singleResult((Collection)portletEntities);
    }

    @Override
    public IPortletDefinition getPortletDefinition(IPortletDefinitionId portletDefinitionId) {
        Validate.notNull((Object)portletDefinitionId, (String)"portletDefinitionId can not be null");
        long internalPortletDefinitionId = Long.parseLong(portletDefinitionId.getStringId());
        PortletDefinitionImpl portletDefinition = (PortletDefinitionImpl)this.entityManager.find(PortletDefinitionImpl.class, (Object)internalPortletDefinitionId);
        return portletDefinition;
    }

    @Override
    @Transactional
    public void updatePortletDefinition(IPortletDefinition portletDefinition) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        this.entityManager.persist((Object)portletDefinition);
    }
}

