/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.spi.PortalCallbackService;
import org.apache.pluto.spi.PortletURLProvider;
import org.apache.pluto.spi.ResourceURLProvider;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.url.IPortletUrlSyntaxProvider;
import org.jasig.portal.portlet.url.PortletURLProviderImpl;
import org.jasig.portal.portlet.url.ResourceUrlProviderImpl;
import org.springframework.beans.factory.annotation.Required;

public class PortalCallbackServiceImpl
implements PortalCallbackService {
    private IRequestPropertiesManager requestPropertiesManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletUrlSyntaxProvider portletUrlSyntaxProvider;

    public IRequestPropertiesManager getRequestPropertiesManager() {
        return this.requestPropertiesManager;
    }

    @Required
    public void setRequestPropertiesManager(IRequestPropertiesManager requestPropertiesManager) {
        Validate.notNull((Object)requestPropertiesManager, (String)"requestPropertiesManager can not be null");
        this.requestPropertiesManager = requestPropertiesManager;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry, (String)"portletWindowRegistry can not be null");
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletUrlSyntaxProvider getPortletUrlSyntaxProvider() {
        return this.portletUrlSyntaxProvider;
    }

    @Required
    public void setPortletUrlSyntaxProvider(IPortletUrlSyntaxProvider portletUrlSyntaxProvider) {
        Validate.notNull((Object)portletUrlSyntaxProvider, (String)"portletUrlSyntaxProvider can not be null");
        this.portletUrlSyntaxProvider = portletUrlSyntaxProvider;
    }

    public void setResponseProperty(HttpServletRequest request, PortletWindow plutoPortletWindow, String property, String value) {
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(request, plutoPortletWindow);
        this.requestPropertiesManager.setResponseProperty(request, portletWindow, property, value);
    }

    public void addResponseProperty(HttpServletRequest request, PortletWindow plutoPortletWindow, String property, String value) {
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(request, plutoPortletWindow);
        this.requestPropertiesManager.addResponseProperty(request, portletWindow, property, value);
    }

    public Map<String, String[]> getRequestProperties(HttpServletRequest request, PortletWindow plutoPortletWindow) {
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(request, plutoPortletWindow);
        return this.requestPropertiesManager.getRequestProperties(request, portletWindow);
    }

    public PortletURLProvider getPortletURLProvider(HttpServletRequest request, PortletWindow plutoPortletWindow) {
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(request, plutoPortletWindow);
        return new PortletURLProviderImpl(portletWindow, request, this.portletUrlSyntaxProvider);
    }

    public ResourceURLProvider getResourceURLProvider(HttpServletRequest request, PortletWindow plutoPortletWindow) {
        return new ResourceUrlProviderImpl();
    }

    public void setTitle(HttpServletRequest request, PortletWindow plutoPortletWindow, String title) {
        request.setAttribute(IPortletAdaptor.ATTRIBUTE__PORTLET_TITLE, (Object)title);
    }
}

