/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.UserAttributeDD;
import org.apache.pluto.internal.InternalPortletRequest;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.spi.optional.UserInfoService;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Required;

public class PersonDirectoryUserInfoService
implements UserInfoService {
    private IPersonAttributeDao personAttributeDao;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPersonAttributeDao getPersonAttributeDao() {
        return this.personAttributeDao;
    }

    @Required
    public void setPersonAttributeDao(IPersonAttributeDao personAttributeDao) {
        this.personAttributeDao = personAttributeDao;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Deprecated
    public Map<String, String> getUserInfo(PortletRequest request) throws PortletContainerException {
        if (!(request instanceof InternalPortletRequest)) {
            throw new IllegalArgumentException("The PersonDirectoryUserInfoServices requires the PortletRequest parameter to implement the '" + InternalPortletRequest.class.getName() + "' interface.");
        }
        InternalPortletRequest internalRequest = (InternalPortletRequest)request;
        InternalPortletWindow internalPortletWindow = internalRequest.getInternalPortletWindow();
        return this.getUserInfo(request, (PortletWindow)internalPortletWindow);
    }

    public Map<String, String> getUserInfo(PortletRequest request, PortletWindow plutoPortletWindow) throws PortletContainerException {
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(request);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        return this.getUserInfo(remoteUser, httpServletRequest, portletWindow);
    }

    protected Map<String, String> getUserInfo(String remoteUser, HttpServletRequest httpServletRequest, IPortletWindow portletWindow) throws PortletContainerException {
        IPersonAttributes personAttributes = this.personAttributeDao.getPerson(remoteUser);
        if (personAttributes == null) {
            return Collections.emptyMap();
        }
        List<UserAttributeDD> expectedUserAttributes = this.getExpectedUserAttributes(httpServletRequest, portletWindow);
        Map<String, String> portletUserAttributes = this.generateUserInfo(personAttributes, expectedUserAttributes, httpServletRequest);
        return portletUserAttributes;
    }

    protected Map<String, String> generateUserInfo(IPersonAttributes personAttributes, List<UserAttributeDD> expectedUserAttributes, HttpServletRequest httpServletRequest) {
        HashMap<String, String> portletUserAttributes = new HashMap<String, String>(expectedUserAttributes.size());
        Map attributes = personAttributes.getAttributes();
        for (UserAttributeDD userAttributeDD : expectedUserAttributes) {
            String attributeName = userAttributeDD.getName();
            if (!attributes.containsKey(attributeName)) continue;
            Object valueObj = personAttributes.getAttributeValue(attributeName);
            String value = valueObj == null ? null : String.valueOf(valueObj);
            portletUserAttributes.put(attributeName, value);
        }
        return portletUserAttributes;
    }

    protected Map<String, String> generateUserInfo(Map<String, Object> portalUserAttributes) {
        HashMap<String, String> portletUserAttributes = new HashMap<String, String>(portalUserAttributes.size());
        for (Map.Entry<String, Object> portalUserAttributeEntry : portalUserAttributes.entrySet()) {
            String attributeName = portalUserAttributeEntry.getKey();
            Object valueObj = portalUserAttributeEntry.getValue();
            String value = String.valueOf(valueObj);
            portletUserAttributes.put(attributeName, value);
        }
        return portletUserAttributes;
    }

    protected List<UserAttributeDD> getExpectedUserAttributes(HttpServletRequest request, IPortletWindow portletWindow) throws PortletContainerException {
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(request, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletAppDD portletApplicationDescriptor = this.portletDefinitionRegistry.getParentPortletApplicationDescriptor(portletDefinition.getPortletDefinitionId());
        return portletApplicationDescriptor.getUserAttributes();
    }
}

