/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.properties;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.jasig.portal.PortalException;
import org.jasig.portal.portlet.container.properties.BaseRequestPropertiesManager;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Required;

public class CacheRequestPropertiesManager
extends BaseRequestPropertiesManager {
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        Validate.notNull((Object)portletEntityRegistry);
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        Validate.notNull((Object)portletDefinitionRegistry);
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Override
    public Map<String, String[]> getRequestProperties(HttpServletRequest portletRequest, IPortletWindow portletWindow) {
        PortletDD portletDeployment;
        int descriptorExpirationCache;
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        Integer expirationCache = portletWindow.getExpirationCache();
        if (expirationCache == null && Integer.MIN_VALUE != (descriptorExpirationCache = (portletDeployment = this.getPortletDeployment(httpServletRequest, portletWindow)).getExpirationCache())) {
            expirationCache = descriptorExpirationCache;
        }
        if (expirationCache != null) {
            return Collections.singletonMap("portlet.expiration-cache", new String[]{expirationCache.toString()});
        }
        return Collections.emptyMap();
    }

    @Override
    public void setResponseProperty(HttpServletRequest portletRequest, IPortletWindow portletWindow, String property, String value) {
        PortletDD portletDeployment;
        int descriptorExpirationCache;
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        if ("portlet.expiration-cache".equals(property) && Integer.MIN_VALUE != (descriptorExpirationCache = (portletDeployment = this.getPortletDeployment(httpServletRequest, portletWindow)).getExpirationCache())) {
            Integer cacheExpiration = portletWindow.getExpirationCache();
            try {
                cacheExpiration = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.info((Object)("Portlet '" + portletWindow + "' tried to set a cache expiration time of '" + value + "' which could not be parsed into an Integer. The previous value of '" + cacheExpiration + "' will be used."));
            }
            portletWindow.setExpirationCache(cacheExpiration);
        }
    }

    protected PortletDD getPortletDeployment(HttpServletRequest httpServletRequest, IPortletWindow portletWindow) {
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletWindow.getPortletEntityId());
        try {
            return this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinition.getPortletDefinitionId());
        }
        catch (PortletContainerException pce) {
            throw new PortalException("Failed to retrieve the PortletDD for portlet window: " + portletWindow, (Throwable)pce);
        }
    }
}

