/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.ldap;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ldap.ILdapServer;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public final class LdapServices {
    private static final String DEFAULT_LDAP_SERVER_NAME = "defaultLdapServer";
    private static final Log LOG = LogFactory.getLog(LdapServices.class);

    public static ILdapServer getDefaultLdapServer() {
        return LdapServices.getLdapServer(DEFAULT_LDAP_SERVER_NAME);
    }

    public static ILdapServer getLdapServer(String name) {
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        ILdapServer ldapServer = null;
        try {
            ldapServer = (ILdapServer)applicationContext.getBean(name, ILdapServer.class);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found ILdapServer='" + ldapServer + "' for name='" + name + "'"));
        }
        return ldapServer;
    }

    public static Map<String, ILdapServer> getLdapServerMap() {
        ApplicationContext applicationContext = PortalApplicationContextLocator.getApplicationContext();
        Map ldapServers = applicationContext.getBeansOfType(ILdapServer.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found Map of ILdapServers=" + ldapServers + "'"));
        }
        return Collections.unmodifiableMap(ldapServers);
    }

    private LdapServices() {
    }
}

