/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.simple;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.jasig.portal.layout.node.UserLayoutNodeDescription;
import org.jasig.portal.layout.simple.SimpleLayout;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SimpleUserLayoutManager
implements IUserLayoutManager {
    private static final Log log = LogFactory.getLog(SimpleUserLayoutManager.class);
    protected final IPerson owner;
    protected final UserProfile profile;
    protected IUserLayoutStore store = null;
    protected Set listeners = new HashSet();
    protected IUserLayout userLayout = null;
    protected Document userLayoutDocument = null;
    protected Document markedUserLayout = null;
    protected static Random rnd = new Random();
    protected String cacheKey = "initialKey";
    protected String rootNodeId;
    private boolean dirtyState = false;
    private String markingMode = null;
    private String markingNode;
    private static final String ADD_COMMAND = "add";
    private static final String MOVE_COMMAND = "move";
    private static final String MARKING_XSLT_URI = "/org/jasig/portal/layout/MarkUserLayout.xsl";
    private IUserLayoutNodeDescription newNodeDescription = null;

    public SimpleUserLayoutManager(IPerson owner, UserProfile profile, IUserLayoutStore store) throws PortalException {
        if (owner == null) {
            throw new PortalException("A non-null owner needs to be specified.");
        }
        if (profile == null) {
            throw new PortalException("A non-null profile needs to be specified.");
        }
        this.owner = owner;
        this.profile = profile;
        this.rootNodeId = null;
        this.setLayoutStore(store);
        this.loadUserLayout();
        this.markingMode = null;
        this.markingNode = null;
    }

    @Override
    public IUserLayout getUserLayout() throws PortalException {
        return new SimpleLayout(String.valueOf(this.profile.getLayoutId()), this.userLayoutDocument);
    }

    @Override
    public void setUserLayout(IUserLayout userLayout) throws PortalException {
        Document doc = DocumentFactory.getNewDocument();
        try {
            userLayout.writeTo(doc);
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        this.userLayoutDocument = doc;
        this.markedUserLayout = null;
        this.updateCacheKey();
    }

    private void setUserLayoutDOM(Document doc) {
        this.userLayoutDocument = doc;
        this.markedUserLayout = null;
        this.updateCacheKey();
    }

    @Override
    public Document getUserLayoutDOM() {
        return this.userLayoutDocument;
    }

    @Override
    public void getUserLayout(ContentHandler ch) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        if (ulm == null) {
            throw new PortalException("User layout has not been initialized");
        }
        this.getUserLayout(ulm, ch);
    }

    @Override
    public void getUserLayout(String nodeId, ContentHandler ch) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        if (ulm == null) {
            throw new PortalException("User layout has not been initialized");
        }
        Element rootNode = ulm.getElementById(nodeId);
        if (rootNode == null) {
            throw new PortalException("A requested root node (with id=\"" + nodeId + "\") is not in the user layout.");
        }
        this.getUserLayout(rootNode, ch);
    }

    protected void getUserLayout(Node n, ContentHandler ch) throws PortalException {
        try {
            if (this.markingMode != null) {
                Hashtable<String, String> stylesheetParams = new Hashtable<String, String>(1);
                stylesheetParams.put("operation", this.markingMode);
                if (this.markingNode != null) {
                    stylesheetParams.put("targetId", this.markingNode);
                }
                XSLT xslt = XSLT.getTransformer(this);
                xslt.setXML(n);
                xslt.setTarget(ch);
                xslt.setStylesheetParameters(stylesheetParams);
                xslt.setXSL(MARKING_XSLT_URI);
                xslt.transform();
            } else {
                Transformer emptyt = TransformerFactory.newInstance().newTransformer();
                emptyt.transform(new DOMSource(n), new SAXResult(ch));
            }
        }
        catch (Exception e) {
            throw new PortalException("Encountered an exception trying to output user layout", (Throwable)e);
        }
    }

    @Override
    public void setLayoutStore(IUserLayoutStore store) {
        this.store = store;
    }

    protected IUserLayoutStore getLayoutStore() {
        return this.store;
    }

    @Override
    public void loadUserLayout() throws PortalException {
        this.loadUserLayout(false);
    }

    @Override
    public void loadUserLayout(boolean reload) throws PortalException {
        if (this.getLayoutStore() == null) {
            throw new PortalException("Store implementation has not been set.");
        }
        try {
            Document uli = this.getLayoutStore().getUserLayout(this.owner, this.profile);
            if (uli != null) {
                this.setUserLayoutDOM(uli);
                this.clearDirtyFlag();
                for (LayoutEventListener lel : this.listeners) {
                    lel.layoutLoaded();
                }
            } else {
                throw new PortalException("Null user layout returned for ownerId=\"" + this.owner.getID() + "\", profileId=\"" + this.profile.getProfileId() + "\", layoutId=\"" + this.profile.getLayoutId() + "\"");
            }
            this.updateCacheKey();
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while reading a layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
        }
    }

    @Override
    public void saveUserLayout() throws PortalException {
        if (this.isLayoutDirty()) {
            Document ulm = this.getUserLayoutDOM();
            if (ulm == null) {
                throw new PortalException("UserLayout has not been initialized.");
            }
            if (this.getLayoutStore() == null) {
                throw new PortalException("Store implementation has not been set.");
            }
            try {
                this.getLayoutStore().setUserLayout(this.owner, this.profile, ulm, true);
                for (LayoutEventListener lel : this.listeners) {
                    lel.layoutSaved();
                }
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while trying to save a layout for userId=" + this.owner.getID() + ", profileId=" + this.profile.getProfileId(), (Throwable)e);
            }
        }
    }

    @Override
    public IUserLayoutNodeDescription getNode(String nodeId) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        if (ulm == null) {
            throw new PortalException("UserLayout has not been initialized.");
        }
        Element element = ulm.getElementById(nodeId);
        if (element == null) {
            throw new PortalException("Element with ID=\"" + nodeId + "\" doesn't exist.");
        }
        return UserLayoutNodeDescription.createUserLayoutNodeDescription(element);
    }

    @Override
    public int getDepth(String nodeId) throws PortalException {
        int depth = 0;
        String parentId = this.getParentId(nodeId);
        while (parentId != null) {
            parentId = this.getParentId(parentId);
            ++depth;
        }
        return depth;
    }

    @Override
    public IUserLayoutNodeDescription addNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        boolean isChannel = false;
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        if (this.canAddNode(node, parent, nextSiblingId)) {
            if (this.getLayoutStore() == null) {
                throw new PortalException("Store implementation has not been set.");
            }
            try {
                if (node instanceof IUserLayoutChannelDescription) {
                    isChannel = true;
                    node.setId(this.getLayoutStore().generateNewChannelSubscribeId(this.owner));
                } else {
                    node.setId(this.getLayoutStore().generateNewFolderId(this.owner));
                }
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while generating new usre layout node Id for userId=" + this.owner.getID());
            }
            Document ulm = this.getUserLayoutDOM();
            Element childElement = node.getXML(ulm);
            Element parentElement = ulm.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = ulm.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            this.markLayoutDirty();
            childElement.setIdAttribute("ID", true);
            childElement.setAttribute("ID", node.getId());
            this.updateCacheKey();
            this.clearMarkings();
            LayoutEvent ev = new LayoutEvent(this, node, parent);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelAdded(ev);
                    continue;
                }
                lel.folderAdded(ev);
            }
            return node;
        }
        return null;
    }

    public void clearMarkings() {
        this.markingMode = null;
        this.markingNode = null;
    }

    @Override
    public boolean moveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        IUserLayoutNodeDescription parent = this.getNode(parentId);
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        String oldParentNodeId = this.getParentId(nodeId);
        if (this.canMoveNode(node, parent, nextSiblingId)) {
            Document ulm = this.getUserLayoutDOM();
            Element childElement = ulm.getElementById(nodeId);
            Element parentElement = ulm.getElementById(parentId);
            if (nextSiblingId == null) {
                parentElement.appendChild(childElement);
            } else {
                Element nextSibling = ulm.getElementById(nextSiblingId);
                parentElement.insertBefore(childElement, nextSibling);
            }
            this.markLayoutDirty();
            this.clearMarkings();
            this.updateCacheKey();
            boolean isChannel = false;
            if (node instanceof IUserLayoutChannelDescription) {
                isChannel = true;
            }
            IUserLayoutNodeDescription oldParentNode = this.getNode(oldParentNodeId);
            LayoutMoveEvent ev = new LayoutMoveEvent(this, parent, node, oldParentNode);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelMoved(ev);
                    continue;
                }
                lel.folderMoved(ev);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteNode(String nodeId) throws PortalException {
        if (this.canDeleteNode(nodeId)) {
            IUserLayoutNodeDescription nodeDescription = this.getNode(nodeId);
            String parentNodeId = this.getParentId(nodeId);
            Document ulm = this.getUserLayoutDOM();
            Element childElement = ulm.getElementById(nodeId);
            Node parent = childElement.getParentNode();
            if (parent == null) {
                throw new PortalException("Node \"" + nodeId + "\" has a NULL parent !");
            }
            parent.removeChild(childElement);
            this.markLayoutDirty();
            this.updateCacheKey();
            boolean isChannel = false;
            if (nodeDescription instanceof IUserLayoutChannelDescription) {
                isChannel = true;
            }
            IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
            LayoutMoveEvent ev = new LayoutMoveEvent(this, null, nodeDescription, parentNode);
            for (LayoutEventListener lel : this.listeners) {
                if (isChannel) {
                    lel.channelDeleted(ev);
                    continue;
                }
                lel.folderDeleted(ev);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getRootFolderId() {
        try {
            if (this.rootNodeId == null) {
                String expression = "//layout/folder";
                XPathFactory fac = XPathFactory.newInstance();
                XPath xpath = fac.newXPath();
                Element rootNode = (Element)xpath.evaluate(expression, this.getUserLayoutDOM(), XPathConstants.NODE);
                this.rootNodeId = rootNode.getAttribute("ID");
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception getting root folder id.", (Throwable)e);
        }
        return this.rootNodeId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean updateNode(IUserLayoutNodeDescription node) throws PortalException {
        IUserLayoutNodeDescription oldNode;
        if (!this.canUpdateNode(node)) return false;
        String nodeId = node.getId();
        String nextSiblingId = this.getNextSiblingId(nodeId);
        Element nextSibling = null;
        if (nextSiblingId != null) {
            Document ulm = this.getUserLayoutDOM();
            nextSibling = ulm.getElementById(nextSiblingId);
        }
        if ((oldNode = this.getNode(nodeId)) instanceof IUserLayoutChannelDescription) {
            if (!(node instanceof IUserLayoutChannelDescription)) throw new PortalException("Change channel to folder is not allowed by updateNode() method!");
            Document ulm = this.getUserLayoutDOM();
            Element newChannelElement = node.getXML(ulm);
            Element oldChannelElement = ulm.getElementById(nodeId);
            Node parent = oldChannelElement.getParentNode();
            parent.removeChild(oldChannelElement);
            parent.insertBefore(newChannelElement, nextSibling);
            newChannelElement.setIdAttribute("ID", true);
            newChannelElement.setAttribute("ID", node.getId());
            String parentNodeId = this.getParentId(nodeId);
            IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
            LayoutEvent ev = new LayoutEvent(this, parentNode, node);
            for (LayoutEventListener lel : this.listeners) {
                lel.channelUpdated(ev);
            }
        } else if (node instanceof IUserLayoutFolderDescription) {
            Document ulm = this.getUserLayoutDOM();
            Element newFolderElement = node.getXML(ulm);
            Element oldFolderElement = ulm.getElementById(nodeId);
            Node parent = oldFolderElement.getParentNode();
            Vector<Node> children = new Vector<Node>();
            for (Node n = oldFolderElement.getFirstChild(); n != null; n = n.getNextSibling()) {
                children.add(n);
            }
            for (int i = 0; i < children.size(); ++i) {
                newFolderElement.appendChild((Node)children.get(i));
            }
            parent.removeChild(oldFolderElement);
            parent.insertBefore(newFolderElement, nextSibling);
            newFolderElement.setIdAttribute("ID", true);
            newFolderElement.setAttribute("ID", node.getId());
            String parentNodeId = this.getParentId(nodeId);
            IUserLayoutNodeDescription parentNode = this.getNode(parentNodeId);
            LayoutEvent ev = new LayoutEvent(this, parentNode, node);
            for (LayoutEventListener lel : this.listeners) {
                lel.folderUpdated(ev);
            }
        }
        this.markLayoutDirty();
        this.updateCacheKey();
        return true;
    }

    @Override
    public boolean canAddNode(IUserLayoutNodeDescription node, String parentId, String nextSiblingId) throws PortalException {
        return this.canAddNode(node, this.getNode(parentId), nextSiblingId);
    }

    protected boolean canAddNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        if (nextSiblingId != null) {
            IUserLayoutNodeDescription sibling = this.getNode(nextSiblingId);
            if (sibling == null) {
                throw new PortalException("Unable to find a sibling node with id=\"" + nextSiblingId + "\"");
            }
            if (!parent.getId().equals(this.getParentId(nextSiblingId))) {
                throw new PortalException("Given sibling (\"" + nextSiblingId + "\") is not a child of a given parentId (\"" + parent.getId() + "\")");
            }
        }
        return parent != null && parent instanceof IUserLayoutFolderDescription && !parent.isImmutable();
    }

    @Override
    public boolean canMoveNode(String nodeId, String parentId, String nextSiblingId) throws PortalException {
        return this.canMoveNode(this.getNode(nodeId), this.getNode(parentId), nextSiblingId);
    }

    protected boolean canMoveNode(IUserLayoutNodeDescription node, IUserLayoutNodeDescription parent, String nextSiblingId) throws PortalException {
        IUserLayoutNodeDescription currentParent = this.getNode(this.getParentId(node.getId()));
        if (currentParent == null) {
            throw new PortalException("Unable to determine a parent node for node with id=\"" + node.getId() + "\"");
        }
        return !currentParent.isImmutable() && this.canAddNode(node, parent, nextSiblingId);
    }

    @Override
    public boolean canDeleteNode(String nodeId) throws PortalException {
        return this.canDeleteNode(this.getNode(nodeId));
    }

    protected boolean canDeleteNode(IUserLayoutNodeDescription node) throws PortalException {
        return node != null && !node.isUnremovable();
    }

    public boolean canUpdateNode(String nodeId) throws PortalException {
        return this.canUpdateNode(this.getNode(nodeId));
    }

    @Override
    public boolean canUpdateNode(IUserLayoutNodeDescription node) {
        return node != null && !node.isImmutable();
    }

    @Override
    public void markAddTargets(IUserLayoutNodeDescription node) throws PortalException {
        if (node != null) {
            this.markingMode = ADD_COMMAND;
        } else {
            this.clearMarkings();
        }
    }

    @Override
    public void markMoveTargets(String nodeId) throws PortalException {
        if (nodeId != null) {
            this.markingMode = MOVE_COMMAND;
            this.markingNode = nodeId;
        } else {
            this.clearMarkings();
        }
    }

    @Override
    public String getParentId(String nodeId) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        Element nelement = ulm.getElementById(nodeId);
        if (nelement != null) {
            Node parent = nelement.getParentNode();
            if (parent != null) {
                if (parent.getNodeType() != 1) {
                    throw new PortalException("Node with id=\"" + nodeId + "\" is attached to something other then an element node.");
                }
                Element e = (Element)parent;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist.");
    }

    @Override
    public String getNextSiblingId(String nodeId) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        Element nelement = ulm.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getNextSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist.");
    }

    @Override
    public String getPreviousSiblingId(String nodeId) throws PortalException {
        Document ulm = this.getUserLayoutDOM();
        Element nelement = ulm.getElementById(nodeId);
        if (nelement != null) {
            Node nsibling;
            for (nsibling = nelement.getPreviousSibling(); nsibling != null && nsibling.getNodeType() != 1; nsibling = nsibling.getNextSibling()) {
            }
            if (nsibling != null) {
                Element e = (Element)nsibling;
                return e.getAttribute("ID");
            }
            return null;
        }
        throw new PortalException("Node with id=\"" + nodeId + "\" doesn't exist.");
    }

    public Enumeration getChildIds(String nodeId) throws PortalException {
        Vector<String> v = new Vector<String>();
        IUserLayoutNodeDescription node = this.getNode(nodeId);
        if (node instanceof IUserLayoutFolderDescription) {
            Document ulm = this.getUserLayoutDOM();
            Element felement = ulm.getElementById(nodeId);
            for (Node n = felement.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e;
                if (n.getNodeType() != 1 || (e = (Element)n).getAttribute("ID") == null) continue;
                v.add(e.getAttribute("ID"));
            }
        }
        return v.elements();
    }

    @Override
    public String getCacheKey() {
        if (this.markingMode == null) {
            return this.cacheKey;
        }
        if (this.markingNode != null) {
            return this.cacheKey + this.markingMode + this.markingNode;
        }
        return this.cacheKey + this.markingMode;
    }

    private void updateCacheKey() {
        this.cacheKey = Long.toString(rnd.nextLong());
    }

    @Override
    public int getLayoutId() {
        return this.profile.getLayoutId();
    }

    @Override
    public String getSubscribeId(String fname) throws PortalException {
        try {
            String expression = "//channel[@fname='" + fname + "']";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            Element fnameNode = (Element)xpath.evaluate(expression, this.getUserLayoutDOM(), XPathConstants.NODE);
            if (fnameNode != null) {
                return fnameNode.getAttribute("ID");
            }
            return null;
        }
        catch (XPathExpressionException e) {
            log.error((Object)("SimpleUserLayoutManager::getSubcribeId() : encountered exception while trying to identify subscribe channel id for the fname=\"" + fname + "\" : "), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean addLayoutEventListener(LayoutEventListener l) {
        return this.listeners.add(l);
    }

    @Override
    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return this.listeners.remove(l);
    }

    @Override
    public IUserLayoutNodeDescription createNodeDescription(int nodeType) throws PortalException {
        switch (nodeType) {
            case 2: {
                return new UserLayoutFolderDescription();
            }
            case 1: {
                return new UserLayoutChannelDescription();
            }
        }
        return null;
    }

    protected boolean isLayoutDirty() {
        return this.dirtyState;
    }

    private void markLayoutDirty() {
        this.dirtyState = true;
    }

    private void clearDirtyFlag() {
        this.dirtyState = false;
    }

    @Override
    public void processLayoutParameters(IPerson person, UserPreferences userPrefs, HttpServletRequest req) throws PortalException {
        try {
            String param;
            IUserLayoutNodeDescription nodeDesc;
            String[] values1;
            String value;
            String[] values;
            String newNodeId = null;
            ThemeStylesheetUserPreferences themePrefs = userPrefs.getThemeStylesheetUserPreferences();
            StructureStylesheetUserPreferences structPrefs = userPrefs.getStructureStylesheetUserPreferences();
            String authenticated = String.valueOf(person.getSecurityContext().isAuthenticated());
            structPrefs.putParameterValue("authenticated", authenticated);
            String userName = person.getFullName();
            if (userName != null && userName.trim().length() > 0) {
                themePrefs.putParameterValue("userName", userName);
            }
            if ((values = req.getParameterValues("uP_request_move_targets")) != null) {
                if (values[0].trim().length() == 0) {
                    values[0] = null;
                }
                this.markMoveTargets(values[0]);
            } else {
                this.markMoveTargets(null);
            }
            values = req.getParameterValues("uP_request_add_targets");
            if (values != null) {
                String contentPublishId;
                String value2;
                int nodeType = values[0].equals("folder") ? 2 : 1;
                IUserLayoutNodeDescription nodeDesc2 = this.createNodeDescription(nodeType);
                nodeDesc2.setName("Unnamed");
                if (nodeType == 1 && (value2 = req.getParameter("channelPublishID")) != null && (contentPublishId = value2.trim()).length() > 0) {
                    ((IUserLayoutChannelDescription)nodeDesc2).setChannelPublishId(contentPublishId);
                    themePrefs.putParameterValue("channelPublishID", contentPublishId);
                }
                this.newNodeDescription = nodeDesc2;
                this.markAddTargets(this.newNodeDescription);
            } else {
                this.markAddTargets(null);
            }
            values = req.getParameterValues("uP_add_target");
            if (values != null) {
                String[] values2;
                value = null;
                values1 = req.getParameterValues("targetNextID");
                if (values1 != null && values1.length > 0) {
                    value = values1[0];
                }
                if ((values2 = req.getParameterValues("targetParentID")) != null && this.newNodeDescription != null) {
                    if (CommonUtils.nvl(value).trim().length() == 0) {
                        value = null;
                    }
                    newNodeId = this.addNode(this.newNodeDescription, values2[0], value).getId();
                }
                this.newNodeDescription = null;
            }
            if ((values = req.getParameterValues("uP_move_target")) != null) {
                String[] values2;
                value = null;
                values1 = req.getParameterValues("targetNextID");
                if (values1 != null && values1.length > 0) {
                    value = values1[0];
                }
                if ((values2 = req.getParameterValues("targetParentID")) != null) {
                    if (CommonUtils.nvl(value).trim().length() == 0) {
                        value = null;
                    }
                    this.moveNode(values[0], values2[0], value);
                }
            }
            if ((values = req.getParameterValues("uP_rename_target")) != null && (values1 = req.getParameterValues("uP_target_name")) != null && (nodeDesc = this.getNode(values[0])) != null) {
                String oldName = nodeDesc.getName();
                nodeDesc.setName(values1[0]);
                if (!this.updateNode(nodeDesc)) {
                    nodeDesc.setName(oldName);
                }
            }
            if ((values = req.getParameterValues("uP_remove_target")) != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.deleteNode(values[i]);
                }
            }
            if ((param = req.getParameter("uP_cancel_targets")) != null && param.equals("true")) {
                this.markAddTargets(null);
                this.markMoveTargets(null);
                this.newNodeDescription = null;
            }
            if ((param = req.getParameter("uP_reload_layout")) != null && param.equals("true")) {
                this.loadUserLayout();
            }
            structPrefs.putParameterValue("newNodeID", CommonUtils.nvl(newNodeId));
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }
}

