/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.simple;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.CoreStylesheetDescription;
import org.jasig.portal.CoreXSLTStylesheetDescription;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.LayoutStructure;
import org.jasig.portal.rdbm.DatabaseMetaDataImpl;
import org.jasig.portal.rdbm.IDatabaseMetadata;
import org.jasig.portal.rdbm.IJoinQueryString;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.services.SequenceGenerator;
import org.jasig.portal.spring.locator.PersonManagerLocator;
import org.jasig.portal.utils.CounterStoreFactory;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ICounterStore;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class RDBMUserLayoutStore
implements IUserLayoutStore {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static String PROFILE_TABLE = "UP_USER_PROFILE";
    protected static int DEBUG = 0;
    protected static final String channelPrefix = "n";
    protected static final String folderPrefix = "s";
    private final DataSource dataSource;
    private final IDatabaseMetadata databaseMetadata;
    protected final IChannelRegistryStore channelRegistryStore;
    protected final ICounterStore counterStore;
    protected final IPersonManager personManager;
    protected static final boolean localeAware = LocaleManager.isLocaleAware();
    private final SingletonDoubleCheckedCreator<IPerson> systemPersonCreator = new SingletonDoubleCheckedCreator<IPerson>(){

        @Override
        protected IPerson createSingleton(Object ... args) {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(RDBMUserLayoutStore.this.dataSource);
            int systemUserId = jdbcTemplate.queryForInt("SELECT USER_ID FROM UP_USER WHERE USER_NAME = 'system'", new Object[0]);
            RDBMUserLayoutStore.this.log.info((Object)("Found user id " + systemUserId + " for the 'system' user."));
            return new SystemUser(systemUserId);
        }
    };

    public RDBMUserLayoutStore() throws Exception {
        this.dataSource = RDBMServices.getDataSource();
        this.databaseMetadata = RDBMServices.getDbMetaData();
        this.channelRegistryStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
        this.counterStore = CounterStoreFactory.getCounterStoreImpl();
        this.personManager = PersonManagerLocator.getPersonManager();
        if (this.databaseMetadata.supportsOuterJoins()) {
            IJoinQueryString joinQuery = this.databaseMetadata.getJoinQuery();
            if (joinQuery instanceof DatabaseMetaDataImpl.JdbcDb) {
                joinQuery.addQuery("layout", "{oj UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID} WHERE");
                joinQuery.addQuery("ss_struct", "{oj UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID} WHERE");
                joinQuery.addQuery("ss_theme", "{oj UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID} WHERE");
            } else if (joinQuery instanceof DatabaseMetaDataImpl.PostgreSQLDb) {
                joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID WHERE");
                joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID WHERE");
                joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID WHERE");
            } else if (joinQuery instanceof DatabaseMetaDataImpl.OracleDb) {
                joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS, UP_LAYOUT_PARAM USP WHERE ULS.STRUCT_ID = USP.STRUCT_ID(+) AND ULS.USER_ID = USP.USER_ID(+) AND");
                joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS, UP_SS_STRUCT_PAR USP WHERE USS.SS_ID=USP.SS_ID(+) AND");
                joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS, UP_SS_THEME_PARM UTP WHERE UTS.SS_ID=UTP.SS_ID(+) AND");
            } else {
                throw new Exception("Unknown database driver");
            }
        }
    }

    private final IPerson getSystemUser() {
        return (IPerson)this.systemPersonCreator.get(new Object[0]);
    }

    /*
     * Loose catch block
     */
    public Integer addStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int id = this.counterStore.getIncrementIntegerId("UP_SS_STRUCT");
                ssd.setId(id);
                String sQuery = "INSERT INTO UP_SS_STRUCT (SS_ID,SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT) VALUES (" + id + ",'" + ssd.getStylesheetName() + "','" + ssd.getStylesheetURI() + "','" + ssd.getStylesheetDescriptionURI() + "','" + ssd.getStylesheetWordDescription() + "')";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getStylesheetParameterDefaultValue(pName) + "','" + ssd.getStylesheetParameterWordDescription(pName) + "',1)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getFolderAttributeDefaultValue(pName) + "','" + ssd.getFolderAttributeWordDescription(pName) + "',2)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getChannelAttributeDefaultValue(pName) + "','" + ssd.getChannelAttributeWordDescription(pName) + "',3)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
                Integer n = new Integer(id);
                return n;
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * Loose catch block
     */
    public Integer addThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int id = this.counterStore.getIncrementIntegerId("UP_SS_THEME");
                tsd.setId(id);
                String sQuery = "INSERT INTO UP_SS_THEME (SS_ID,SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT,STRUCT_SS_ID,SAMPLE_URI,SAMPLE_ICON_URI,MIME_TYPE,DEVICE_TYPE,SERIALIZER_NAME,UP_MODULE_CLASS) VALUES (" + id + ",'" + tsd.getStylesheetName() + "','" + tsd.getStylesheetURI() + "','" + tsd.getStylesheetDescriptionURI() + "','" + tsd.getStylesheetWordDescription() + "'," + tsd.getStructureStylesheetId() + ",'" + tsd.getSamplePictureURI() + "','" + tsd.getSampleIconURI() + "','" + tsd.getMimeType() + "','" + tsd.getDeviceType() + "','" + tsd.getSerializerName() + "','" + tsd.getCustomUserPreferencesManagerClass() + "')";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + tsd.getStylesheetParameterDefaultValue(pName) + "','" + tsd.getStylesheetParameterWordDescription(pName) + "',1)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + tsd.getChannelAttributeDefaultValue(pName) + "','" + tsd.getChannelAttributeWordDescription(pName) + "',3)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
                Integer n = new Integer(id);
                return n;
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    @Override
    public boolean updateThemeStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI, int stylesheetId) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            String ssName = this.getRootElementTextValue(stylesheetDescriptionXML, "parentStructureStylesheet");
            if (ssName == null) {
                return false;
            }
            Integer ssId = this.getStructureStylesheetId(ssName);
            if (ssId == null) {
                return false;
            }
            ThemeStylesheetDescription sssd = new ThemeStylesheetDescription();
            sssd.setId(stylesheetId);
            sssd.setStructureStylesheetId(ssId);
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            sssd.setStylesheetName(xmlStylesheetName);
            sssd.setStylesheetURI(stylesheetURI);
            sssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            sssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            sssd.setMimeType(this.getRootElementTextValue(stylesheetDescriptionXML, "mimeType"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : setting mimetype=\"" + sssd.getMimeType() + "\""));
            }
            sssd.setSerializerName(this.getRootElementTextValue(stylesheetDescriptionXML, "serializer"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : setting serializerName=\"" + sssd.getSerializerName() + "\""));
            }
            sssd.setCustomUserPreferencesManagerClass(this.getRootElementTextValue(stylesheetDescriptionXML, "userPreferencesModuleClass"));
            sssd.setSamplePictureURI(this.getRootElementTextValue(stylesheetDescriptionXML, "samplePictureURI"));
            sssd.setSampleIconURI(this.getRootElementTextValue(stylesheetDescriptionXML, "sampleIconURI"));
            sssd.setDeviceType(this.getRootElementTextValue(stylesheetDescriptionXML, "deviceType"));
            this.populateParameterTable(stylesheetDescriptionXML, sssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, sssd);
            this.updateThemeStylesheetDescription(sssd);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Exception updating theme stylesheet description=[" + stylesheetDescriptionURI + "] stylesheetUri=[" + stylesheetURI + "] stylesheetId=[" + stylesheetId + "]"), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean updateStructureStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI, int stylesheetId) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            StructureStylesheetDescription fssd = new StructureStylesheetDescription();
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            fssd.setId(stylesheetId);
            fssd.setStylesheetName(xmlStylesheetName);
            fssd.setStylesheetURI(stylesheetURI);
            fssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            fssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            this.populateParameterTable(stylesheetDescriptionXML, fssd);
            this.populateFolderAttributeTable(stylesheetDescriptionXML, fssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, fssd);
            this.updateStructureStylesheetDescription(fssd);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Exception updating structure stylesheet description stylesheetDescriptionUri=[" + stylesheetDescriptionURI + "]" + " stylesheetUri=[" + stylesheetURI + "] stylesheetId=" + stylesheetId), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public Integer addStructureStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            StructureStylesheetDescription fssd = new StructureStylesheetDescription();
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            fssd.setStylesheetName(xmlStylesheetName);
            fssd.setStylesheetURI(stylesheetURI);
            fssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            fssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            this.populateParameterTable(stylesheetDescriptionXML, fssd);
            this.populateFolderAttributeTable(stylesheetDescriptionXML, fssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, fssd);
            return this.addStructureStylesheetDescription(fssd);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error adding stylesheet: description Uri=[" + stylesheetDescriptionURI + "] " + "stylesheetUri=[" + stylesheetURI + "]"), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Integer addThemeStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI) {
        try {
            String ssName;
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription() : stylesheet name = " + this.getName(stylesheetDescriptionXML)));
                this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription() : stylesheet description = " + this.getDescription(stylesheetDescriptionXML)));
            }
            if ((ssName = this.getRootElementTextValue(stylesheetDescriptionXML, "parentStructureStylesheet")) == null) {
                return null;
            }
            Integer ssId = this.getStructureStylesheetId(ssName);
            if (ssId == null) {
                return null;
            }
            ThemeStylesheetDescription sssd = new ThemeStylesheetDescription();
            sssd.setStructureStylesheetId(ssId);
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            sssd.setStylesheetName(xmlStylesheetName);
            sssd.setStylesheetURI(stylesheetURI);
            sssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            sssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            sssd.setMimeType(this.getRootElementTextValue(stylesheetDescriptionXML, "mimeType"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription() : setting mimetype=\"" + sssd.getMimeType() + "\""));
            }
            sssd.setSerializerName(this.getRootElementTextValue(stylesheetDescriptionXML, "serializer"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::addThemeStylesheetDescription() : setting serializerName=\"" + sssd.getSerializerName() + "\""));
            }
            sssd.setCustomUserPreferencesManagerClass(this.getRootElementTextValue(stylesheetDescriptionXML, "userPreferencesModuleClass"));
            sssd.setSamplePictureURI(this.getRootElementTextValue(stylesheetDescriptionXML, "samplePictureURI"));
            sssd.setSampleIconURI(this.getRootElementTextValue(stylesheetDescriptionXML, "sampleIconURI"));
            sssd.setDeviceType(this.getRootElementTextValue(stylesheetDescriptionXML, "deviceType"));
            this.populateParameterTable(stylesheetDescriptionXML, sssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, sssd);
            return this.addThemeStylesheetDescription(sssd);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Exception adding theme stylesheet description description uri=[" + stylesheetDescriptionURI + "] " + "stylesheet uri=[" + stylesheetURI + "]"), (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserProfile addUserProfile(IPerson person, UserProfile profile) throws Exception {
        int userId = person.getID();
        UserProfile newProfile = null;
        Connection con = RDBMServices.getConnection();
        try {
            PreparedStatement pstmt = con.prepareStatement("INSERT INTO UP_USER_PROFILE (USER_ID,PROFILE_ID,PROFILE_FNAME,PROFILE_NAME,STRUCTURE_SS_ID,THEME_SS_ID,DESCRIPTION, LAYOUT_ID) VALUES (?,?,?,?,?,?,?,?)");
            int profileId = this.getNextKey();
            pstmt.setInt(1, userId);
            pstmt.setInt(2, profileId);
            pstmt.setString(3, profile.getProfileFname());
            pstmt.setString(4, profile.getProfileName());
            pstmt.setInt(5, profile.getStructureStylesheetId());
            pstmt.setInt(6, profile.getThemeStylesheetId());
            pstmt.setString(7, profile.getProfileDescription());
            pstmt.setInt(8, profile.getLayoutId());
            String sQuery = "INSERT INTO UP_USER_PROFILE (USER_ID,PROFILE_ID,PROFILE_FNAME,PROFILE_NAME,STRUCTURE_SS_ID,THEME_SS_ID,DESCRIPTION, LAYOUT_ID) VALUES (" + userId + ",'" + profileId + ",'" + profile.getProfileFname() + "','" + profile.getProfileName() + "'," + profile.getStructureStylesheetId() + "," + profile.getThemeStylesheetId() + ",'" + profile.getProfileDescription() + "', " + profile.getLayoutId() + ")";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::addUserProfile(): " + sQuery));
            }
            try {
                pstmt.executeUpdate();
                newProfile = new UserProfile();
                newProfile.setProfileId(profileId);
                newProfile.setLayoutId(profile.getLayoutId());
                newProfile.setLocaleManager(profile.getLocaleManager());
                newProfile.setProfileDescription(profile.getProfileDescription());
                newProfile.setProfileFname(profile.getProfileFname());
                newProfile.setProfileName(profile.getProfileName());
                newProfile.setStructureStylesheetId(profile.getStructureStylesheetId());
                newProfile.setSystemProfile(false);
                newProfile.setThemeStylesheetId(profile.getThemeStylesheetId());
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return newProfile;
    }

    private int getNextKey() throws Exception {
        return SequenceGenerator.instance().getNextInt(PROFILE_TABLE);
    }

    protected static boolean channelApproved(java.util.Date approvedDate) {
        java.util.Date rightNow = new java.util.Date();
        return approvedDate != null && rightNow.after(approvedDate);
    }

    protected final void createLayout(HashMap layoutStructure, Document doc, Element root, int structId) throws SQLException, Exception {
        while (structId != 0) {
            if (DEBUG > 1) {
                System.err.println("CreateLayout(" + structId + ")");
            }
            LayoutStructure ls = (LayoutStructure)layoutStructure.get(new Integer(structId));
            Element structure = this.getStructure(doc, ls);
            root.appendChild(structure);
            String id = structure.getAttribute("ID");
            if (id != null && !id.equals("")) {
                structure.setIdAttribute("ID", true);
            }
            this.createLayout(layoutStructure, doc, structure, ls.getChildId());
            structId = ls.getNextId();
        }
    }

    protected static final boolean xmlBool(String value) {
        return value != null && value.equals("true");
    }

    @Override
    public void deleteUserProfile(IPerson person, int profileId) throws Exception {
        int userId = person.getID();
        this.deleteUserProfile(userId, profileId);
    }

    private Document getDOM(String uri) throws Exception {
        DOMResult result = new DOMResult();
        SAXSource source = new SAXSource(new InputSource(ResourceLoader.getResourceAsStream(this.getClass(), uri)));
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer emptytr = tFactory.newTransformer();
        emptytr.transform(source, result);
        Node node = result.getNode();
        if (node instanceof Document) {
            return (Document)node;
        }
        Document dom = DocumentFactory.getNewDocument();
        dom.appendChild(dom.importNode(node, true));
        return dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUserProfile(int userId, int profileId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "DELETE FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::deleteUserProfile() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_USER_UA_MAP WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::deleteUserProfile() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::deleteUserProfile() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::deleteUserProfile() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public static final void dumpDoc(Node node, String indent) {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            System.err.print(indent + "element: tag=" + ((Element)node).getTagName() + " ");
        } else if (node instanceof Document) {
            System.err.print("document:");
        } else {
            System.err.print(indent + "node:");
        }
        System.err.println("name=" + node.getNodeName() + " value=" + node.getNodeValue());
        NamedNodeMap nm = node.getAttributes();
        if (nm != null) {
            for (int i = 0; i < nm.getLength(); ++i) {
                System.err.println(indent + " " + nm.item(i).getNodeName() + ": '" + nm.item(i).getNodeValue() + "'");
            }
            System.err.println(indent + "--");
        }
        if (node.hasChildNodes()) {
            RDBMUserLayoutStore.dumpDoc(node.getFirstChild(), indent + "   ");
        }
        RDBMUserLayoutStore.dumpDoc(node.getNextSibling(), indent);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Hashtable getMimeTypeList() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String generateNewChannelSubscribeId(IPerson person) throws Exception {
        return this.getNextStructId(person, channelPrefix);
    }

    @Override
    public String generateNewFolderId(IPerson person) throws Exception {
        return this.getNextStructId(person, folderPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized String getNextStructId(IPerson person, String prefix) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                for (int i = 0; i < 25; ++i) {
                    int currentStructId;
                    block17: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("RDBMUserLayoutStore::getNextStructId(): " + sQuery));
                        }
                        ResultSet rs = stmt.executeQuery(sQuery);
                        try {
                            if (rs.next()) {
                                currentStructId = rs.getInt(1);
                                break block17;
                            }
                            throw new SQLException("no rows returned for query [" + sQuery + "]");
                        }
                        finally {
                            rs.close();
                        }
                    }
                    int nextStructId = currentStructId + 1;
                    try {
                        String sUpdate = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nextStructId + " WHERE USER_ID=" + userId + " AND NEXT_STRUCT_ID=" + currentStructId;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("RDBMUserLayoutStore::getNextStructId(): " + sUpdate));
                        }
                        stmt.executeUpdate(sUpdate);
                        RDBMServices.commit(con);
                        String string = prefix + nextStructId;
                        return string;
                    }
                    catch (SQLException sqle) {
                        RDBMServices.rollback(con);
                        Thread.sleep(Math.round(Math.random() * 3.0 * 1000.0));
                        continue;
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    protected String getStructId(int structId, int chanId) {
        if (chanId == 0) {
            return folderPrefix + structId;
        }
        return channelPrefix + structId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructureStylesheetDescription getStructureStylesheetDescription(int stylesheetId) throws Exception {
        StructureStylesheetDescription ssd = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement stmt = con.createStatement();
            int dbOffset = 0;
            String sQuery = "SELECT SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT";
            if (this.databaseMetadata.supportsOuterJoins()) {
                sQuery = sQuery + ",TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM " + this.databaseMetadata.getJoinQuery().getQuery("ss_struct");
                dbOffset = 4;
            } else {
                sQuery = sQuery + " FROM UP_SS_STRUCT USS WHERE";
            }
            sQuery = sQuery + " USS.SS_ID=" + stylesheetId;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::getStructureStylesheetDescription(): " + sQuery));
            }
            ResultSet rs = stmt.executeQuery(sQuery);
            try {
                if (rs.next()) {
                    ssd = new StructureStylesheetDescription();
                    ssd.setId(stylesheetId);
                    ssd.setStylesheetName(rs.getString(1));
                    ssd.setStylesheetURI(rs.getString(2));
                    ssd.setStylesheetDescriptionURI(rs.getString(3));
                    ssd.setStylesheetWordDescription(rs.getString(4));
                }
                if (!this.databaseMetadata.supportsOuterJoins()) {
                    rs.close();
                    sQuery = "SELECT TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::getStructureStylesheetDescription(): " + sQuery));
                    }
                    rs = stmt.executeQuery(sQuery);
                }
                do {
                    if (!this.databaseMetadata.supportsOuterJoins() && !rs.next()) {
                        break;
                    }
                    int type = rs.getInt(dbOffset + 1);
                    if (rs.wasNull()) {
                        break;
                    }
                    if (type == 1) {
                        ssd.addStylesheetParameter(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 2) {
                        ssd.addFolderAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 3) {
                        ssd.addChannelAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("RDBMUserLayoutStore::getStructureStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ")."));
                } while (!this.databaseMetadata.supportsOuterJoins() || rs.next());
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {}
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            String msg = "Unable to fetch StructureStylesheetDescription for stylesheetId:  " + stylesheetId;
            throw new RuntimeException(msg, e);
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return ssd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getStructureStylesheetId(String ssName) throws Exception {
        ResultSet rs;
        Statement stmt;
        Connection con;
        block3: {
            Integer n;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = RDBMServices.getConnection();
                RDBMServices.setAutoCommit(con, false);
                stmt = con.createStatement();
                String sQuery = "SELECT SS_ID FROM UP_SS_STRUCT WHERE SS_NAME='" + ssName + "'";
                rs = stmt.executeQuery(sQuery);
                if (!rs.next()) break block3;
                int id = rs.getInt("SS_ID");
                if (rs.wasNull()) {
                    id = 0;
                }
                n = new Integer(id);
            }
            catch (Throwable throwable) {
                RDBMServices.closeResultSet(rs);
                RDBMServices.closeStatement(stmt);
                RDBMServices.releaseConnection(con);
                throw throwable;
            }
            RDBMServices.closeResultSet(rs);
            RDBMServices.closeStatement(stmt);
            RDBMServices.releaseConnection(con);
            return n;
        }
        RDBMServices.closeResultSet(rs);
        RDBMServices.closeStatement(stmt);
        RDBMServices.releaseConnection(con);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getStructureStylesheetList(String mimeType) throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, StructureStylesheetDescription> list = new Hashtable<Integer, StructureStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT A.SS_ID FROM UP_SS_STRUCT A, UP_SS_THEME B WHERE B.MIME_TYPE='" + mimeType + "' AND B.STRUCT_SS_ID=A.SS_ID";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getStructureStylesheetList() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(rs.getInt("SS_ID"));
                        if (ssd == null) continue;
                        list.put(new Integer(ssd.getId()), ssd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getStructureStylesheetList() throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, StructureStylesheetDescription> list = new Hashtable<Integer, StructureStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_STRUCT";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getStructureStylesheetList() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(rs.getInt("SS_ID"));
                        if (ssd == null) continue;
                        list.put(new Integer(ssd.getId()), ssd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    @Override
    public abstract StructureStylesheetUserPreferences getStructureStylesheetUserPreferences(IPerson var1, int var2, int var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThemeStylesheetDescription getThemeStylesheetDescription(int stylesheetId) throws Exception {
        ThemeStylesheetDescription tsd = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement stmt = con.createStatement();
            int dbOffset = 0;
            String sQuery = "SELECT SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT,STRUCT_SS_ID,SAMPLE_ICON_URI,SAMPLE_URI,MIME_TYPE,DEVICE_TYPE,SERIALIZER_NAME,UP_MODULE_CLASS";
            if (this.databaseMetadata.supportsOuterJoins()) {
                sQuery = sQuery + ",TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM " + this.databaseMetadata.getJoinQuery().getQuery("ss_theme");
                dbOffset = 11;
            } else {
                sQuery = sQuery + " FROM UP_SS_THEME UTS WHERE";
            }
            sQuery = sQuery + " UTS.SS_ID=" + stylesheetId;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::getThemeStylesheetDescription(): " + sQuery));
            }
            ResultSet rs = stmt.executeQuery(sQuery);
            try {
                if (rs.next()) {
                    tsd = new ThemeStylesheetDescription();
                    tsd.setId(stylesheetId);
                    tsd.setStylesheetName(rs.getString(1));
                    tsd.setStylesheetURI(rs.getString(2));
                    tsd.setStylesheetDescriptionURI(rs.getString(3));
                    tsd.setStylesheetWordDescription(rs.getString(4));
                    int ssId = rs.getInt(5);
                    if (rs.wasNull()) {
                        ssId = 0;
                    }
                    tsd.setStructureStylesheetId(ssId);
                    tsd.setSampleIconURI(rs.getString(6));
                    tsd.setSamplePictureURI(rs.getString(7));
                    tsd.setMimeType(rs.getString(8));
                    tsd.setDeviceType(rs.getString(9));
                    tsd.setSerializerName(rs.getString(10));
                    tsd.setCustomUserPreferencesManagerClass(rs.getString(11));
                }
                if (!this.databaseMetadata.supportsOuterJoins()) {
                    rs.close();
                    sQuery = "SELECT TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::getThemeStylesheetDescription(): " + sQuery));
                    }
                    rs = stmt.executeQuery(sQuery);
                }
                do {
                    if (!this.databaseMetadata.supportsOuterJoins() && !rs.next()) {
                        break;
                    }
                    int type = rs.getInt(dbOffset + 1);
                    if (rs.wasNull()) {
                        break;
                    }
                    if (type == 1) {
                        tsd.addStylesheetParameter(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 3) {
                        tsd.addChannelAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 2) {
                        this.log.error((Object)("RDBMUserLayoutStore::getThemeStylesheetDescription() : encountered a folder attribute specified for a theme stylesheet ! Corrupted DB entry. (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ")."));
                        continue;
                    }
                    this.log.error((Object)("RDBMUserLayoutStore::getThemeStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ")."));
                } while (!this.databaseMetadata.supportsOuterJoins() || rs.next());
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {}
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return tsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getThemeStylesheetId(String tsName) throws Exception {
        Integer id = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = RDBMServices.getConnection();
            stmt = con.createStatement();
            String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE SS_NAME='" + tsName + "'";
            rs = stmt.executeQuery(sQuery);
            if (rs.next()) {
                id = new Integer(rs.getInt("SS_ID"));
            }
        }
        catch (Throwable throwable) {
            RDBMServices.closeResultSet(rs);
            RDBMServices.closeStatement(stmt);
            RDBMServices.releaseConnection(con);
            throw throwable;
        }
        RDBMServices.closeResultSet(rs);
        RDBMServices.closeStatement(stmt);
        RDBMServices.releaseConnection(con);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getThemeStylesheetList(int structureStylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, ThemeStylesheetDescription> list = new Hashtable<Integer, ThemeStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE STRUCT_SS_ID=" + structureStylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getThemeStylesheetList() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(rs.getInt("SS_ID"));
                        if (tsd == null) continue;
                        list.put(new Integer(tsd.getId()), tsd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getThemeStylesheetList() throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, ThemeStylesheetDescription> list = new Hashtable<Integer, ThemeStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getThemeStylesheetList() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(rs.getInt("SS_ID"));
                        if (tsd == null) continue;
                        list.put(new Integer(tsd.getId()), tsd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    @Override
    public abstract ThemeStylesheetUserPreferences getThemeStylesheetUserPreferences(IPerson var1, int var2, int var3) throws Exception;

    private String getName(Document descr) {
        NodeList names = descr.getElementsByTagName("name");
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RDBMUserLayoutStore::getName() : no \"name\" element was found under the \"stylesheetdescription\" node!");
        }
        return null;
    }

    private String getRootElementTextValue(Document descr, String elementName) {
        NodeList names = descr.getElementsByTagName(elementName);
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RDBMUserLayoutStore::getRootElementTextValue() : no \"" + elementName + "\" element was found under the \"stylesheetdescription\" node!"));
        }
        return null;
    }

    private String getDescription(Document descr) {
        NodeList descriptions = descr.getElementsByTagName("description");
        Node description = null;
        for (int i = descriptions.getLength() - 1; i >= 0 && !(description = descriptions.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            description = null;
        }
        if (description != null) {
            return this.getTextChildNodeValue(description);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RDBMUserLayoutStore::getDescription() : no \"description\" element was found under the \"stylesheetdescription\" node!");
        }
        return null;
    }

    private void populateParameterTable(Document descr, CoreStylesheetDescription csd) {
        NodeList parametersNodes = descr.getElementsByTagName("parameters");
        Node parametersNode = null;
        for (int i = parametersNodes.getLength() - 1; i >= 0 && !(parametersNode = parametersNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            parametersNode = null;
        }
        if (parametersNode != null) {
            NodeList children = parametersNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("parameter")) continue;
                Element parameter = (Element)children.item(i);
                String name = parameter.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = parameter.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::populateParameterTable() : adding a stylesheet parameter : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")"));
                }
                csd.addStylesheetParameter(name, defaultvalue, description);
            }
        }
    }

    private void populateFolderAttributeTable(Document descr, StructureStylesheetDescription cxsd) {
        NodeList parametersNodes = descr.getElementsByTagName("parameters");
        NodeList folderattributesNodes = descr.getElementsByTagName("folderattributes");
        Node folderattributesNode = null;
        for (int i = folderattributesNodes.getLength() - 1; i >= 0 && !(folderattributesNode = folderattributesNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            folderattributesNode = null;
        }
        if (folderattributesNode != null) {
            NodeList children = folderattributesNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("attribute")) continue;
                Element attribute = (Element)children.item(i);
                String name = attribute.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = attribute.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::populateFolderAttributeTable() : adding a stylesheet folder attribute : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")"));
                }
                cxsd.addFolderAttribute(name, defaultvalue, description);
            }
        }
    }

    private void populateChannelAttributeTable(Document descr, CoreXSLTStylesheetDescription cxsd) {
        NodeList channelattributesNodes = descr.getElementsByTagName("channelattributes");
        Node channelattributesNode = null;
        for (int i = channelattributesNodes.getLength() - 1; i >= 0 && !(channelattributesNode = channelattributesNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            channelattributesNode = null;
        }
        if (channelattributesNode != null) {
            NodeList children = channelattributesNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("attribute")) continue;
                Element attribute = (Element)children.item(i);
                String name = attribute.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = attribute.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::populateChannelAttributeTable() : adding a stylesheet channel attribute : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")"));
                }
                cxsd.addChannelAttribute(name, defaultvalue, description);
            }
        }
    }

    private Vector getVectorOfSimpleTextElementValues(Document descr, String elementName) {
        Vector<String> v = new Vector<String>();
        Element stylesheetdescriptionElement = (Element)descr.getElementsByTagName("stylesheetdescription").item(0);
        if (stylesheetdescriptionElement == null) {
            this.log.error((Object)"Could not obtain <stylesheetdescription> element");
            return null;
        }
        NodeList elements = stylesheetdescriptionElement.getElementsByTagName(elementName);
        for (int i = elements.getLength() - 1; i >= 0; --i) {
            v.add(this.getTextChildNodeValue(elements.item(i)));
        }
        return v;
    }

    private String getTextChildNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserBrowserMapping(IPerson person, String userAgent) throws Exception {
        if (userAgent.length() > 255) {
            userAgent = userAgent.substring(0, 254);
            this.log.debug((Object)("userAgent trimmed to 255 characters. userAgent: " + userAgent));
        }
        int userId = person.getID();
        String profileFname = null;
        Connection con = RDBMServices.getConnection();
        try {
            String sQuery = "SELECT PROFILE_FNAME FROM UP_USER_UA_MAP LEFT JOIN UP_USER_PROFILE ON UP_USER_UA_MAP.PROFILE_ID=UP_USER_PROFILE.PROFILE_ID WHERE UP_USER_UA_MAP.USER_ID=? AND USER_AGENT=?";
            PreparedStatement pstmt = con.prepareStatement(sQuery);
            try {
                pstmt.setInt(1, userId);
                pstmt.setString(2, userAgent);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getUserBrowserMapping(): '" + sQuery + "' userId: " + userId + " userAgent: " + userAgent));
                }
                ResultSet rs = pstmt.executeQuery();
                try {
                    if (rs.next()) {
                        profileFname = rs.getString("PROFILE_FNAME");
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return profileFname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getUserLayout(IPerson person, UserProfile profile) throws Exception {
        int userId;
        int realUserId = userId = person.getID();
        Connection con = RDBMServices.getConnection();
        LocaleManager localeManager = profile.getLocaleManager();
        try {
            Document doc = DocumentFactory.getNewDocument();
            Element root = doc.createElement("layout");
            Statement stmt = con.createStatement();
            Statement insertStmt = con.createStatement();
            try {
                HashMap<Integer, LayoutStructure> layoutStructure;
                int firstStructId;
                long startTime;
                block78: {
                    int structId;
                    StringBuffer structChanIds;
                    ResultSet rs;
                    int layoutId;
                    block76: {
                        startTime = System.currentTimeMillis();
                        layoutId = this.getLayoutID(userId, profile.getProfileId());
                        if (layoutId == 0) {
                            RDBMServices.setAutoCommit(con, false);
                            try {
                                int nextStructId;
                                String sQuery = "SELECT USER_DFLT_USR_ID, USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=" + userId;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                                }
                                rs = stmt.executeQuery(sQuery);
                                try {
                                    boolean hasRow = rs.next();
                                    userId = rs.getInt(1);
                                    layoutId = rs.getInt(2);
                                }
                                finally {
                                    rs.close();
                                }
                                sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                                }
                                rs = stmt.executeQuery(sQuery);
                                try {
                                    boolean hasRow = rs.next();
                                    nextStructId = rs.getInt(1);
                                }
                                finally {
                                    rs.close();
                                }
                                int realNextStructId = 0;
                                if (realUserId != userId) {
                                    sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + realUserId;
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                                    }
                                    rs = stmt.executeQuery(sQuery);
                                    try {
                                        boolean hasRow = rs.next();
                                        realNextStructId = rs.getInt(1);
                                    }
                                    finally {
                                        rs.close();
                                    }
                                }
                                if (nextStructId > realNextStructId) {
                                    sQuery = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nextStructId + " WHERE USER_ID=" + realUserId;
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                                    }
                                    stmt.executeUpdate(sQuery);
                                }
                                RDBMServices.commit(con);
                            }
                            catch (Exception e) {
                                RDBMServices.rollback(con);
                                throw e;
                            }
                            finally {
                                RDBMServices.setAutoCommit(con, true);
                            }
                        }
                        firstStructId = -1;
                        boolean foundLayout = false;
                        boolean triedDefault = false;
                        do {
                            String sQuery;
                            block75: {
                                sQuery = "SELECT INIT_STRUCT_ID FROM UP_USER_LAYOUT WHERE USER_ID=" + userId + " AND LAYOUT_ID = " + layoutId;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                                }
                                rs = stmt.executeQuery(sQuery);
                                try {
                                    if (rs.next()) {
                                        firstStructId = rs.getInt(1);
                                        break block75;
                                    }
                                    throw new Exception("RDBMUserLayoutStore::getUserLayout(): No INIT_STRUCT_ID in UP_USER_LAYOUT for USER_ID: " + userId + " and LAYOUT_ID: " + layoutId);
                                }
                                finally {
                                    rs.close();
                                }
                            }
                            String sql = localeAware ? "SELECT ULS.STRUCT_ID,ULS.NEXT_STRUCT_ID,ULS.CHLD_STRUCT_ID,ULS.CHAN_ID,ULS.NAME,ULS.TYPE,ULS.HIDDEN,ULS.UNREMOVABLE,ULS.IMMUTABLE" : "SELECT ULS.STRUCT_ID,ULS.NEXT_STRUCT_ID,ULS.CHLD_STRUCT_ID,ULS.CHAN_ID,ULS.NAME,ULS.TYPE,ULS.HIDDEN,ULS.UNREMOVABLE,ULS.IMMUTABLE";
                            sql = this.databaseMetadata.supportsOuterJoins() ? sql + ",USP.STRUCT_PARM_NM,USP.STRUCT_PARM_VAL FROM " + this.databaseMetadata.getJoinQuery().getQuery("layout") : sql + " FROM UP_LAYOUT_STRUCT ULS WHERE ";
                            sql = sql + " ULS.USER_ID=" + userId + " AND ULS.LAYOUT_ID=" + layoutId + " ORDER BY ULS.STRUCT_ID";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sql));
                            }
                            if ((foundLayout = (rs = stmt.executeQuery(sql)).next()) || triedDefault || userId != realUserId) break;
                            triedDefault = true;
                            rs.close();
                            sQuery = "SELECT USER_DFLT_USR_ID, USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=" + userId;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sQuery));
                            }
                            rs = stmt.executeQuery(sQuery);
                            try {
                                rs.next();
                                userId = rs.getInt(1);
                                layoutId = rs.getInt(2);
                            }
                            finally {
                                rs.close();
                            }
                        } while (!foundLayout);
                        layoutStructure = new HashMap<Integer, LayoutStructure>();
                        structChanIds = new StringBuffer();
                        try {
                            int lastStructId = 0;
                            LayoutStructure ls = null;
                            String sepChar = "";
                            if (!foundLayout) break block76;
                            structId = rs.getInt(1);
                            if (rs.wasNull()) {
                                structId = 0;
                            }
                            while (true) {
                                int value_index;
                                int name_index;
                                if (DEBUG > 1) {
                                    System.err.println("Found layout structureID " + structId);
                                }
                                int nextId = rs.getInt(2);
                                if (rs.wasNull()) {
                                    nextId = 0;
                                }
                                int childId = rs.getInt(3);
                                if (rs.wasNull()) {
                                    childId = 0;
                                }
                                int chanId = rs.getInt(4);
                                if (rs.wasNull()) {
                                    chanId = 0;
                                }
                                String temp5 = rs.getString(5);
                                String temp6 = rs.getString(6);
                                if (localeAware) {
                                    ls = new LayoutStructure(structId, nextId, childId, chanId, rs.getString(7), rs.getString(8), rs.getString(9), localeManager.getLocales()[0].toString());
                                    name_index = 10;
                                    value_index = 11;
                                } else {
                                    ls = new LayoutStructure(structId, nextId, childId, chanId, rs.getString(7), rs.getString(8), rs.getString(9));
                                    name_index = 10;
                                    value_index = 11;
                                }
                                layoutStructure.put(new Integer(structId), ls);
                                lastStructId = structId;
                                if (!ls.isChannel()) {
                                    ls.addFolderData(temp5, temp6);
                                }
                                if (this.databaseMetadata.supportsOuterJoins()) {
                                    do {
                                        String name = rs.getString(name_index);
                                        String value = rs.getString(value_index);
                                        if (name != null) {
                                            ls.addParameter(name, value);
                                        }
                                        if (!rs.next()) {
                                            break block76;
                                        }
                                        structId = rs.getInt(1);
                                        if (!rs.wasNull()) continue;
                                        structId = 0;
                                    } while (structId == lastStructId);
                                    continue;
                                }
                                if (ls.isChannel()) {
                                    structChanIds.append(sepChar + ls.getChanId());
                                    sepChar = ",";
                                }
                                if (rs.next()) {
                                    structId = rs.getInt(1);
                                    if (!rs.wasNull()) continue;
                                    structId = 0;
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    if (!this.databaseMetadata.supportsOuterJoins()) {
                        String sql = "SELECT STRUCT_ID FROM UP_LAYOUT_STRUCT WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND CHAN_ID IN (" + structChanIds.toString() + ") ORDER BY STRUCT_ID";
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sql));
                        }
                        StringBuffer structIdsSB = new StringBuffer("");
                        String sep = "";
                        rs = stmt.executeQuery(sql);
                        try {
                            while (rs.next()) {
                                structIdsSB.append(sep + rs.getString(1));
                                sep = ",";
                            }
                        }
                        finally {
                            rs.close();
                        }
                        sql = "SELECT STRUCT_ID, STRUCT_PARM_NM,STRUCT_PARM_VAL FROM UP_LAYOUT_PARAM WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND STRUCT_ID IN (" + structIdsSB.toString() + ") ORDER BY STRUCT_ID";
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): " + sql));
                        }
                        rs = stmt.executeQuery(sql);
                        try {
                            if (!rs.next()) break block78;
                            structId = rs.getInt(1);
                            while (true) {
                                LayoutStructure ls = (LayoutStructure)layoutStructure.get(new Integer(structId));
                                int lastStructId = structId;
                                do {
                                    ls.addParameter(rs.getString(2), rs.getString(3));
                                    if (rs.next()) continue;
                                    break block78;
                                } while ((structId = rs.getInt(1)) == lastStructId);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                }
                if (layoutStructure.size() > 0) {
                    this.createLayout(layoutStructure, doc, root, firstStructId);
                    layoutStructure.clear();
                    if (this.log.isDebugEnabled()) {
                        long stopTime = System.currentTimeMillis();
                        this.log.debug((Object)("RDBMUserLayoutStore::getUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to create"));
                    }
                    doc.appendChild(root);
                    if (DEBUG > 1) {
                        System.err.println("--> created document");
                        RDBMUserLayoutStore.dumpDoc(doc, "");
                        System.err.println("<--");
                    }
                }
            }
            finally {
                stmt.close();
                insertStmt.close();
            }
            Document document = doc;
            return document;
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    @Override
    public UserProfile getUserProfileById(IPerson person, int profileId) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT USER_ID, PROFILE_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getUserProfileById(): " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    if (rs.next()) {
                        String temp2 = rs.getString(3);
                        String temp3 = rs.getString(4);
                        String temp4 = rs.getString(5);
                        int layoutId = rs.getInt(6);
                        if (rs.wasNull()) {
                            layoutId = 0;
                        }
                        int structSsId = rs.getInt(7);
                        if (rs.wasNull()) {
                            if (!person.equals(this.getSystemUser())) {
                                structSsId = this.getSystemProfileByFname(temp2).getStructureStylesheetId();
                            } else {
                                String msg = "The system user profile has no structure stylesheet Id.";
                                throw new IllegalStateException(msg);
                            }
                        }
                        int themeSsId = rs.getInt(8);
                        if (rs.wasNull()) {
                            if (!person.equals(this.getSystemUser())) {
                                themeSsId = this.getSystemProfileByFname(temp2).getThemeStylesheetId();
                            } else {
                                String msg = "The system user profile has no theme stylesheet Id.";
                                throw new IllegalStateException(msg);
                            }
                        }
                        UserProfile userProfile = new UserProfile(profileId, temp2, temp3, temp4, layoutId, structSsId, themeSsId);
                        userProfile.setLocaleManager(new LocaleManager(person));
                        UserProfile userProfile2 = userProfile;
                        return userProfile2;
                    }
                    throw new Exception("Unable to find User Profile for user " + userId + " and profile " + profileId);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UserProfile getUserProfileByFname(IPerson person, String profileFname) throws Exception {
        this.log.debug((Object)("Getting profile " + profileFname + " for user " + person.getID()));
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            String query = "SELECT USER_ID, PROFILE_ID, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=? AND PROFILE_FNAME=?";
            PreparedStatement pstmt = con.prepareStatement(query);
            pstmt.setInt(1, userId);
            pstmt.setString(2, profileFname);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::getUserProfileByFname(): " + query + " userId: " + userId + " profileFname: " + profileFname));
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int profileId = rs.getInt(2);
                String profileName = rs.getString(3);
                String profileDesc = rs.getString(4);
                int layoutId = rs.getInt(5);
                if (rs.wasNull()) {
                    layoutId = 0;
                }
                int structSsId = rs.getInt(6);
                if (rs.wasNull()) {
                    if (!person.equals(this.getSystemUser())) {
                        structSsId = this.getSystemProfileByFname(profileFname).getStructureStylesheetId();
                    } else {
                        String msg = "The system user profile has no structure stylesheet Id.";
                        throw new IllegalStateException(msg);
                    }
                }
                int themeSsId = rs.getInt(7);
                if (rs.wasNull()) {
                    if (!person.equals(this.getSystemUser())) {
                        themeSsId = this.getSystemProfileByFname(profileFname).getThemeStylesheetId();
                    } else {
                        String msg = "The system user profile has no theme stylesheet Id.";
                        throw new IllegalStateException(msg);
                    }
                }
                UserProfile userProfile = new UserProfile(profileId, profileFname, profileName, profileDesc, layoutId, structSsId, themeSsId);
                userProfile.setLocaleManager(new LocaleManager(person));
                UserProfile userProfile2 = userProfile;
                return userProfile2;
            }
            this.log.debug((Object)("Copying template profile " + profileFname + " to user " + person.getID()));
            rs.close();
            pstmt.close();
            pstmt = con.prepareStatement("SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID=?");
            pstmt.setInt(1, person.getID());
            rs = pstmt.executeQuery();
            if (!rs.next()) throw new Exception("Unable to find User Profile for userId " + userId + " and profile " + profileFname);
            int defaultProfileUser = rs.getInt(1);
            PersonImpl defaultProfilePerson = new PersonImpl();
            defaultProfilePerson.setID(defaultProfileUser);
            if (defaultProfilePerson.getID() == person.getID()) throw new Exception("Unable to find User Profile for userId " + userId + " and profile " + profileFname);
            UserProfile templateProfile = this.getUserProfileByFname(defaultProfilePerson, profileFname);
            if (templateProfile == null) throw new Exception("Unable to find template profile for " + userId + " and profile " + profileFname);
            UserProfile newUserProfile = new UserProfile(templateProfile);
            newUserProfile.setLayoutId(0);
            UserProfile userProfile = this.addUserProfile(person, newUserProfile);
            return userProfile;
            {
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserProfileList(IPerson person) throws Exception {
        int userId = person.getID();
        Hashtable<Integer, UserProfile> pv = new Hashtable<Integer, UserProfile>();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT USER_ID, PROFILE_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getUserProfileList(): " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        int layoutId = rs.getInt(6);
                        if (rs.wasNull()) {
                            layoutId = 0;
                        }
                        int structSsId = rs.getInt(7);
                        if (rs.wasNull()) {
                            structSsId = 0;
                        }
                        int themeSsId = rs.getInt(8);
                        if (rs.wasNull()) {
                            themeSsId = 0;
                        }
                        UserProfile upl = new UserProfile(rs.getInt(2), rs.getString(3), rs.getString(4), rs.getString(5), layoutId, structSsId, themeSsId);
                        pv.put(new Integer(upl.getProfileId()), upl);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return pv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureChannelAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=3 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureChannelAttribute() : " + sQuery));
            }
            stmt.execute(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=3 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureChannelAttribute() : " + sQuery));
            }
            stmt.execute(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureFolderAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=2 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureFolderAttribute() : " + sQuery));
            }
            stmt.execute(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=2 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureFolderAttribute() : " + sQuery));
            }
            stmt.execute(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStructureStylesheetDescription(int stylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE STRUCT_SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        this.removeThemeStylesheetDescription(rs.getInt("SS_ID"));
                    }
                }
                finally {
                    rs.close();
                }
                sQuery = "DELETE FROM UP_SS_STRUCT WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureStylesheetParam(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=1 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureStylesheetParam() : " + sQuery));
            }
            stmt.execute(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=1 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeStructureStylesheetParam() : " + sQuery));
            }
            stmt.execute(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThemeChannelAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId + " AND TYPE=3 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeThemeChannelAttribute() : " + sQuery));
            }
            stmt.execute(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_TYPE=3 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery));
            }
            stmt.execute(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThemeStylesheetDescription(int stylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "DELETE FROM UP_SS_THEME WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "SELECT USER_ID,PROFILE_ID FROM UP_USER_PROFILE WHERE THEME_SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery));
                }
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        this.deleteUserProfile(rs.getInt("USER_ID"), rs.getInt("PROFILE_ID"));
                    }
                }
                finally {
                    rs.close();
                }
                sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThemeStylesheetParam(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId + " AND TYPE=1 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery));
            }
            stmt.execute(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_TYPE=1 AND PARAM_NAME='" + pName + "'";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery));
            }
            stmt.execute(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    protected abstract Element getStructure(Document var1, LayoutStructure var2) throws Exception;

    protected abstract int saveStructure(Node var1, PreparedStatement var2, PreparedStatement var3) throws Exception;

    @Override
    public abstract void setStructureStylesheetUserPreferences(IPerson var1, int var2, StructureStylesheetUserPreferences var3) throws Exception;

    @Override
    public abstract void setThemeStylesheetUserPreferences(IPerson var1, int var2, ThemeStylesheetUserPreferences var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserBrowserMapping(IPerson person, String userAgent, int profileId) throws Exception {
        if (userAgent.length() > 255) {
            userAgent = userAgent.substring(0, 254);
            this.log.debug((Object)("userAgent trimmed to 255 characters. userAgent: " + userAgent));
        }
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            try {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("DELETE FROM UP_USER_UA_MAP WHERE USER_ID=? AND USER_AGENT=?");
                    ps.setInt(1, userId);
                    ps.setString(2, userAgent);
                    ps.executeUpdate();
                }
                finally {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {}
                }
                try {
                    this.log.debug((Object)("writing to UP_USER_UA_MAP: userId: " + userId + ", userAgent: " + userAgent + ", profileId: " + profileId));
                    ps = con.prepareStatement("INSERT INTO UP_USER_UA_MAP (USER_ID,USER_AGENT,PROFILE_ID) VALUES (?,?,?)");
                    ps.setInt(1, userId);
                    ps.setString(2, userAgent);
                    ps.setInt(3, profileId);
                    ps.executeUpdate();
                }
                finally {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {}
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw new PortalException("userId: " + userId + ", userAgent: " + userAgent + ", profileId: " + profileId, (Throwable)e);
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserLayout(IPerson person, UserProfile profile, Document layoutXML, boolean channelsAdded) throws Exception {
        long startTime = System.currentTimeMillis();
        int userId = person.getID();
        int profileId = profile.getProfileId();
        int layoutId = 0;
        Connection con = RDBMServices.getConnection();
        try {
            int defaultUserId;
            ResultSet rs;
            int firstStructId;
            PreparedStatement pstmt;
            String sql;
            boolean firstLayout;
            block79: {
                RDBMServices.setAutoCommit(con, false);
                layoutId = this.getLayoutID(userId, profileId);
                firstLayout = false;
                if (layoutId == 0) {
                    layoutId = 1;
                    firstLayout = true;
                }
                sql = "DELETE FROM UP_LAYOUT_PARAM WHERE USER_ID=? AND LAYOUT_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, userId);
                    pstmt.setInt(2, layoutId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sql);
                    }
                    pstmt.executeUpdate();
                }
                finally {
                    pstmt.close();
                }
                sql = "DELETE FROM UP_LAYOUT_STRUCT WHERE USER_ID=? AND LAYOUT_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, userId);
                    pstmt.setInt(2, layoutId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sql);
                    }
                    pstmt.executeUpdate();
                }
                finally {
                    pstmt.close();
                }
                PreparedStatement structStmt = con.prepareStatement("INSERT INTO UP_LAYOUT_STRUCT (USER_ID, LAYOUT_ID, STRUCT_ID, NEXT_STRUCT_ID, CHLD_STRUCT_ID,EXTERNAL_ID,CHAN_ID,NAME,TYPE,HIDDEN,IMMUTABLE,UNREMOVABLE) VALUES (" + userId + "," + layoutId + ",?,?,?,?,?,?,?,?,?,?)");
                PreparedStatement parmStmt = con.prepareStatement("INSERT INTO UP_LAYOUT_PARAM (USER_ID, LAYOUT_ID, STRUCT_ID, STRUCT_PARM_NM, STRUCT_PARM_VAL) VALUES (" + userId + "," + layoutId + ",?,?,?)");
                try {
                    firstStructId = this.saveStructure(layoutXML.getFirstChild().getFirstChild(), structStmt, parmStmt);
                }
                finally {
                    structStmt.close();
                    parmStmt.close();
                }
                sql = "SELECT * FROM UP_USER_LAYOUT WHERE USER_ID=? AND LAYOUT_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, userId);
                    pstmt.setInt(2, layoutId);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sql);
                    }
                    rs = pstmt.executeQuery();
                    try {
                        ResultSet rs2;
                        if (rs.next()) break block79;
                        sql = "SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID=?";
                        PreparedStatement pstmt2 = con.prepareStatement(sql);
                        try {
                            pstmt2.clearParameters();
                            pstmt2.setInt(1, userId);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)sql);
                            }
                            rs2 = null;
                            try {
                                rs2 = pstmt2.executeQuery();
                                rs2.next();
                                defaultUserId = rs2.getInt(1);
                            }
                            finally {
                                rs2.close();
                            }
                        }
                        finally {
                            pstmt2.close();
                        }
                        sql = "SELECT USER_ID,LAYOUT_ID,LAYOUT_TITLE,INIT_STRUCT_ID FROM UP_USER_LAYOUT WHERE USER_ID=?";
                        pstmt2 = con.prepareStatement(sql);
                        try {
                            pstmt2.clearParameters();
                            pstmt2.setInt(1, defaultUserId);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)sql);
                            }
                            rs2 = pstmt2.executeQuery();
                            try {
                                PreparedStatement pstmt3;
                                if (rs2.next()) {
                                    sql = "INSERT INTO UP_USER_LAYOUT (USER_ID, LAYOUT_ID, LAYOUT_TITLE, INIT_STRUCT_ID) VALUES (?,?,?,?)";
                                    pstmt3 = con.prepareStatement(sql);
                                    try {
                                        pstmt3.clearParameters();
                                        pstmt3.setInt(1, userId);
                                        pstmt3.setInt(2, rs2.getInt("LAYOUT_ID"));
                                        pstmt3.setString(3, rs2.getString("LAYOUT_TITLE"));
                                        pstmt3.setInt(4, rs2.getInt("INIT_STRUCT_ID"));
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug((Object)sql);
                                        }
                                        pstmt3.executeUpdate();
                                        break block79;
                                    }
                                    finally {
                                        pstmt3.close();
                                    }
                                }
                                sql = "INSERT INTO UP_USER_LAYOUT (USER_ID, LAYOUT_ID, LAYOUT_TITLE, INIT_STRUCT_ID) VALUES (?,?,?,?)";
                                pstmt3 = con.prepareStatement(sql);
                                try {
                                    pstmt3.clearParameters();
                                    pstmt3.setInt(1, userId);
                                    pstmt3.setInt(2, layoutId);
                                    pstmt3.setString(3, "default layout");
                                    pstmt3.setInt(4, 1);
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug((Object)sql);
                                    }
                                    pstmt3.executeUpdate();
                                }
                                finally {
                                    pstmt3.close();
                                }
                            }
                            finally {
                                rs2.close();
                            }
                        }
                        finally {
                            pstmt2.close();
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    pstmt.close();
                }
            }
            sql = "UPDATE UP_USER_LAYOUT SET INIT_STRUCT_ID=? WHERE USER_ID=? AND LAYOUT_ID=?";
            pstmt = con.prepareStatement(sql);
            try {
                pstmt.clearParameters();
                pstmt.setInt(1, firstStructId);
                pstmt.setInt(2, userId);
                pstmt.setInt(3, layoutId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sql);
                }
                pstmt.executeUpdate();
            }
            finally {
                pstmt.close();
            }
            if (channelsAdded) {
                sql = "UPDATE UP_USER SET LST_CHAN_UPDT_DT=? WHERE USER_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setDate(1, new Date(System.currentTimeMillis()));
                    pstmt.setInt(2, userId);
                    this.log.debug((Object)sql);
                    pstmt.executeUpdate();
                }
                finally {
                    pstmt.close();
                }
            }
            if (firstLayout) {
                sql = "SELECT USER_DFLT_USR_ID,USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, userId);
                    this.log.debug((Object)sql);
                    rs = pstmt.executeQuery();
                    try {
                        rs.next();
                        defaultUserId = rs.getInt(1);
                        int defaultLayoutId = rs.getInt(2);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    pstmt.close();
                }
                sql = "UPDATE UP_USER_PROFILE SET LAYOUT_ID=1 WHERE USER_ID=? AND PROFILE_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, userId);
                    pstmt.setInt(2, profileId);
                    this.log.debug((Object)sql);
                    pstmt.executeUpdate();
                }
                finally {
                    pstmt.close();
                }
                sql = "SELECT USER_ID, PROFILE_ID, SS_ID, SS_TYPE, PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=?";
                pstmt = con.prepareStatement(sql);
                try {
                    pstmt.clearParameters();
                    pstmt.setInt(1, defaultUserId);
                    this.log.debug((Object)sql);
                    rs = pstmt.executeQuery();
                    try {
                        while (rs.next()) {
                            sql = "INSERT INTO UP_SS_USER_PARM (USER_ID, PROFILE_ID, SS_ID, SS_TYPE, PARAM_NAME, PARAM_VAL) VALUES(?,?,?,?,?,?)";
                            PreparedStatement pstmt2 = con.prepareStatement(sql);
                            try {
                                pstmt2.clearParameters();
                                pstmt2.setInt(1, userId);
                                pstmt2.setInt(2, rs.getInt("PROFILE_ID"));
                                pstmt2.setInt(3, rs.getInt("SS_ID"));
                                pstmt2.setInt(4, rs.getInt("SS_TYPE"));
                                pstmt2.setString(5, rs.getString("PARAM_NAME"));
                                pstmt2.setString(6, rs.getString("PARAM_VAL"));
                                this.log.debug((Object)sql);
                                pstmt2.executeUpdate();
                            }
                            finally {
                                pstmt2.close();
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    pstmt.close();
                }
            }
            RDBMServices.commit(con);
        }
        catch (Exception e) {
            RDBMServices.rollback(con);
            throw e;
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        if (this.log.isDebugEnabled()) {
            long stopTime = System.currentTimeMillis();
            this.log.debug((Object)("RDBMUserLayoutStore::setUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to save"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int stylesheetId = ssd.getId();
                String sQuery = "UPDATE UP_SS_STRUCT SET SS_NAME='" + ssd.getStylesheetName() + "',SS_URI='" + ssd.getStylesheetURI() + "',SS_DESCRIPTION_URI='" + ssd.getStylesheetDescriptionURI() + "',SS_DESCRIPTION_TEXT='" + ssd.getStylesheetWordDescription() + "' WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                HashSet<String> oparams = new HashSet<String>();
                HashSet<String> ofattrs = new HashSet<String>();
                HashSet<String> ocattrs = new HashSet<String>();
                sQuery = "SELECT PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery));
                }
                Statement stmtOld = con.createStatement();
                ResultSet rsOld = stmtOld.executeQuery(sQuery);
                try {
                    while (rsOld.next()) {
                        int type = rsOld.getInt("TYPE");
                        if (type == 1) {
                            pName = rsOld.getString("PARAM_NAME");
                            oparams.add(pName);
                            if (!ssd.containsParameterName(pName)) {
                                this.removeStructureStylesheetParam(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getStylesheetParameterDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getStylesheetParameterWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=1";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery));
                            }
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 2) {
                            pName = rsOld.getString("PARAM_NAME");
                            ofattrs.add(pName);
                            if (!ssd.containsFolderAttribute(pName)) {
                                this.removeStructureFolderAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getFolderAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getFolderAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "'AND TYPE=2";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery));
                            }
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 3) {
                            pName = rsOld.getString("PARAM_NAME");
                            ocattrs.add(pName);
                            if (!ssd.containsChannelAttribute(pName)) {
                                this.removeStructureChannelAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getChannelAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getChannelAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=3";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery));
                            }
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ")."));
                    }
                }
                finally {
                    rsOld.close();
                    stmtOld.close();
                }
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (oparams.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getStylesheetParameterDefaultValue(pName) + "','" + ssd.getStylesheetParameterWordDescription(pName) + "',1)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ofattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getFolderAttributeDefaultValue(pName) + "','" + ssd.getFolderAttributeWordDescription(pName) + "',2)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ocattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getChannelAttributeDefaultValue(pName) + "','" + ssd.getChannelAttributeWordDescription(pName) + "',3)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int stylesheetId = tsd.getId();
                String sQuery = "UPDATE UP_SS_THEME SET SS_NAME='" + tsd.getStylesheetName() + "',SS_URI='" + tsd.getStylesheetURI() + "',SS_DESCRIPTION_URI='" + tsd.getStylesheetDescriptionURI() + "',SS_DESCRIPTION_TEXT='" + tsd.getStylesheetWordDescription() + "',SAMPLE_ICON_URI='" + tsd.getSampleIconURI() + "',SAMPLE_URI='" + tsd.getSamplePictureURI() + "',MIME_TYPE='" + tsd.getMimeType() + "',DEVICE_TYPE='" + tsd.getDeviceType() + "',SERIALIZER_NAME='" + tsd.getSerializerName() + "',UP_MODULE_CLASS='" + tsd.getCustomUserPreferencesManagerClass() + "' WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery));
                }
                stmt.executeUpdate(sQuery);
                HashSet<String> oparams = new HashSet<String>();
                HashSet<String> ocattrs = new HashSet<String>();
                sQuery = "SELECT PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery));
                }
                Statement stmtOld = con.createStatement();
                ResultSet rsOld = stmtOld.executeQuery(sQuery);
                try {
                    while (rsOld.next()) {
                        int type = rsOld.getInt("TYPE");
                        if (type == 1) {
                            pName = rsOld.getString("PARAM_NAME");
                            oparams.add(pName);
                            if (!tsd.containsParameterName(pName)) {
                                this.removeThemeStylesheetParam(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_THEME_PARM SET PARAM_DEFAULT_VAL='" + tsd.getStylesheetParameterDefaultValue(pName) + "',PARAM_DESCRIPT='" + tsd.getStylesheetParameterWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=1";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery));
                            }
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 2) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : encountered a folder attribute specified for a theme stylesheet ! DB is corrupt. (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ")."));
                            continue;
                        }
                        if (type == 3) {
                            pName = rsOld.getString("PARAM_NAME");
                            ocattrs.add(pName);
                            if (!tsd.containsChannelAttribute(pName)) {
                                this.removeThemeChannelAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_THEME_PARM SET PARAM_DEFAULT_VAL='" + tsd.getChannelAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + tsd.getChannelAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=3";
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery));
                            }
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ")."));
                    }
                }
                finally {
                    rsOld.close();
                    stmtOld.close();
                }
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (oparams.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + tsd.getStylesheetParameterDefaultValue(pName) + "','" + tsd.getStylesheetParameterWordDescription(pName) + "',1)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ocattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + tsd.getChannelAttributeDefaultValue(pName) + "','" + tsd.getChannelAttributeWordDescription(pName) + "',3)";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("RDBMUserLayoutStore::updateThemeStylesheetDescription(): " + sQuery));
                    }
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserProfile(IPerson person, UserProfile profile) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            String query = "UPDATE UP_USER_PROFILE SET LAYOUT_ID=?,THEME_SS_ID=?,STRUCTURE_SS_ID=?,DESCRIPTION=?,PROFILE_NAME=?, PROFILE_FNAME=? WHERE USER_ID=? AND PROFILE_ID=?";
            PreparedStatement pstmt = con.prepareStatement(query);
            pstmt.setInt(1, profile.getLayoutId());
            pstmt.setInt(2, profile.getThemeStylesheetId());
            pstmt.setInt(3, profile.getStructureStylesheetId());
            pstmt.setString(4, profile.getProfileDescription());
            pstmt.setString(5, profile.getProfileName());
            pstmt.setString(6, profile.getProfileFname());
            pstmt.setInt(7, userId);
            pstmt.setInt(8, profile.getProfileId());
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::updateUserProfile() : " + query + " layout_id: " + profile.getLayoutId() + " theme_ss_id: " + profile.getThemeStylesheetId() + " structure_ss_id: " + profile.getStructureStylesheetId() + " description: " + profile.getProfileDescription() + " name: " + profile.getProfileName() + " user_id: " + userId + " fname: " + profile.getProfileFname()));
                }
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    @Override
    public void setSystemBrowserMapping(String userAgent, int profileId) throws Exception {
        this.setUserBrowserMapping(this.getSystemUser(), userAgent, profileId);
    }

    private String getSystemBrowserMapping(String userAgent) throws Exception {
        return this.getUserBrowserMapping(this.getSystemUser(), userAgent);
    }

    @Override
    public UserProfile getUserProfile(IPerson person, String userAgent) throws Exception {
        String profileFname = this.getUserBrowserMapping(person, userAgent);
        if (profileFname == null) {
            return null;
        }
        return this.getUserProfileByFname(person, profileFname);
    }

    @Override
    public UserProfile getSystemProfile(String userAgent) throws Exception {
        String profileFname = this.getSystemBrowserMapping(userAgent);
        if (profileFname == null) {
            return null;
        }
        UserProfile up = this.getUserProfileByFname(this.getSystemUser(), profileFname);
        up.setSystemProfile(true);
        return up;
    }

    @Override
    public UserProfile getSystemProfileById(int profileId) throws Exception {
        UserProfile up = this.getUserProfileById(this.getSystemUser(), profileId);
        up.setSystemProfile(true);
        return up;
    }

    @Override
    public UserProfile getSystemProfileByFname(String profileFname) throws Exception {
        UserProfile up = this.getUserProfileByFname(this.getSystemUser(), profileFname);
        up.setSystemProfile(true);
        return up;
    }

    @Override
    public Hashtable getSystemProfileList() throws Exception {
        Hashtable pl = this.getUserProfileList(this.getSystemUser());
        Enumeration e = pl.elements();
        while (e.hasMoreElements()) {
            UserProfile up = (UserProfile)e.nextElement();
            up.setSystemProfile(true);
        }
        return pl;
    }

    @Override
    public void updateSystemProfile(UserProfile profile) throws Exception {
        this.updateUserProfile(this.getSystemUser(), profile);
    }

    @Override
    public UserProfile addSystemProfile(UserProfile profile) throws Exception {
        return this.addUserProfile(this.getSystemUser(), profile);
    }

    @Override
    public void deleteSystemProfile(int profileId) throws Exception {
        this.deleteUserProfile(this.getSystemUser(), profileId);
    }

    public UserPreferences getUserPreferences(IPerson person, String profileFname) throws Exception {
        UserPreferences up = null;
        UserProfile profile = this.getUserProfileByFname(person, profileFname);
        if (profile != null) {
            up = this.getUserPreferences(person, profile);
        }
        return up;
    }

    @Override
    public UserPreferences getUserPreferences(IPerson person, UserProfile profile) throws Exception {
        int profileId = profile.getProfileId();
        UserPreferences up = new UserPreferences(profile);
        up.setStructureStylesheetUserPreferences(this.getStructureStylesheetUserPreferences(person, profileId, profile.getStructureStylesheetId()));
        up.setThemeStylesheetUserPreferences(this.getThemeStylesheetUserPreferences(person, profileId, profile.getThemeStylesheetId()));
        return up;
    }

    @Override
    public void putUserPreferences(IPerson person, UserPreferences up) throws Exception {
        UserProfile profile = up.getProfile();
        this.updateUserProfile(person, profile);
        this.setStructureStylesheetUserPreferences(person, profile.getProfileId(), up.getStructureStylesheetUserPreferences());
        this.setThemeStylesheetUserPreferences(person, profile.getProfileId(), up.getThemeStylesheetUserPreferences());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLayoutID(int userId, int profileId) throws SQLException {
        String query = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=? AND PROFILE_ID=?";
        Connection con = RDBMServices.getConnection();
        int layoutId = 0;
        try {
            PreparedStatement pstmt = con.prepareStatement(query);
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("RDBMUserLayoutStore::getLayoutID(userId=" + userId + ", profileId=" + profileId + " ): " + query));
                }
                pstmt.setInt(1, userId);
                pstmt.setInt(2, profileId);
                ResultSet rs = pstmt.executeQuery();
                try {
                    if (rs.next()) {
                        layoutId = rs.getInt(1);
                        if (rs.wasNull()) {
                            layoutId = 0;
                        }
                    }
                    if (layoutId == 0) {
                        query = "SELECT PROFILE_FNAME FROM UP_USER_PROFILE WHERE USER_ID=? AND PROFILE_ID=?";
                        pstmt = con.prepareStatement(query);
                        pstmt.setInt(1, userId);
                        pstmt.setInt(2, profileId);
                        rs = pstmt.executeQuery();
                        String profileFname = null;
                        if (rs.next()) {
                            profileFname = rs.getString("PROFILE_FNAME");
                        }
                        query = "SELECT LAYOUT_ID FROM UP_USER_PROFILE LEFT JOIN UP_USER ON UP_USER_PROFILE.USER_ID=UP_USER.USER_DFLT_LAY_ID WHERE UP_USER.USER_ID=? AND UP_USER_PROFILE.PROFILE_FNAME=?";
                        pstmt = con.prepareStatement(query);
                        pstmt.setInt(1, userId);
                        pstmt.setString(2, profileFname);
                        rs = pstmt.executeQuery();
                        int intendedLayoutId = 0;
                        if (rs.next()) {
                            intendedLayoutId = rs.getInt("LAYOUT_ID");
                        }
                        query = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=? AND LAYOUT_ID=?";
                        pstmt = con.prepareStatement(query);
                        pstmt.setInt(1, userId);
                        pstmt.setInt(2, intendedLayoutId);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            query = "UPDATE UP_USER_PROFILE SET LAYOUT_ID=? WHERE USER_ID=? AND PROFILE_ID=?";
                            pstmt = con.prepareStatement(query);
                            pstmt.setInt(1, intendedLayoutId);
                            pstmt.setInt(2, userId);
                            pstmt.setInt(3, profileId);
                            pstmt.execute();
                            layoutId = intendedLayoutId;
                        }
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                pstmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return layoutId;
    }

    private static class SystemUser
    implements IPerson {
        private final int systemUserId;

        public SystemUser(int systemUserId) {
            this.systemUserId = systemUserId;
        }

        @Override
        public void setID(int sID) {
        }

        @Override
        public int getID() {
            return this.systemUserId;
        }

        @Override
        public String getUserName() {
            return null;
        }

        @Override
        public void setUserName(String userName) {
        }

        @Override
        public void setFullName(String sFullName) {
        }

        @Override
        public String getFullName() {
            return "uPortal System Account";
        }

        @Override
        public Object getAttribute(String key) {
            return null;
        }

        @Override
        public Object[] getAttributeValues(String key) {
            return null;
        }

        @Override
        public void setAttribute(String key, Object value) {
        }

        @Override
        public void setAttribute(String key, List<Object> values) {
        }

        public void setAttributes(Map attrs) {
        }

        public Enumeration getAttributes() {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        @Override
        public boolean isGuest() {
            return false;
        }

        @Override
        public ISecurityContext getSecurityContext() {
            return null;
        }

        @Override
        public void setSecurityContext(ISecurityContext context) {
        }

        @Override
        public EntityIdentifier getEntityIdentifier() {
            return null;
        }

        @Override
        public void setEntityIdentifier(EntityIdentifier ei) {
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

