/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.node;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.UserLayoutNodeDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserLayoutFolderDescription
extends UserLayoutNodeDescription
implements IUserLayoutFolderDescription {
    public static final int REGULAR_TYPE = 0;
    public static final int HEADER_TYPE = 1;
    public static final int FOOTER_TYPE = 2;
    public static final String[] folderTypeNames = new String[]{"regular", "header", "footer"};
    protected int folderType = 0;

    public UserLayoutFolderDescription(Element xmlNode) throws PortalException {
        super(xmlNode);
        if (!xmlNode.getNodeName().equals("folder")) {
            throw new PortalException("Given XML Element is not a folder!");
        }
        String typeName = xmlNode.getAttribute("type");
        int int_folderType = 0;
        if (typeName != null) {
            for (int i = 0; i < folderTypeNames.length; ++i) {
                if (!typeName.equals(folderTypeNames[i])) continue;
                int_folderType = i;
            }
        }
        this.setFolderType(int_folderType);
    }

    public UserLayoutFolderDescription() {
    }

    public UserLayoutFolderDescription(IUserLayoutFolderDescription d) {
        super(d);
        this.setFolderType(d.getFolderType());
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getFolderType() {
        return this.folderType;
    }

    @Override
    public void setFolderType(int folderType) {
        this.folderType = folderType;
    }

    @Override
    public Element getXML(Document root) {
        Element node = root.createElement("folder");
        this.addNodeAttributes(node);
        return node;
    }

    @Override
    public void addNodeAttributes(Element node) {
        super.addNodeAttributes(node);
        node.setAttribute("type", folderTypeNames[this.getFolderType()]);
    }
}

