/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.UserPrefsHandler;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.url.PortalHttpServletRequestWrapper;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Element;

public class UpdatePreferencesServlet
extends HttpServlet {
    Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static IUserLayoutStore ulStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    protected static final String BLANK_TAB_NAME = "New Tab";
    protected static final String ACTIVE_TAB_PARAM = "activeTab";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block17: {
            IUserInstanceManager userInstanceManager = null;
            IUserInstance ui = null;
            IPerson per = null;
            UserPreferencesManager upm = null;
            IUserLayoutManager ulm = null;
            if (request.getSession(false) == null) {
                this.log.warn((Object)"Attempting to use AJAX preferences as GUEST user");
                this.printError(response, "Your session has timed out.  Please log in again to make changes to your layout.");
                return;
            }
            try {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
                userInstanceManager = (IUserInstanceManager)applicationContext.getBean("userInstanceManager", IUserInstanceManager.class);
                ui = userInstanceManager.getUserInstance(request);
                per = ui.getPerson();
                if (per.isGuest()) {
                    this.log.warn((Object)"Attempting to use AJAX preferences as GUEST user");
                    this.printError(response, "Your session has timed out.  Please log in again to make changes to your layout.");
                    return;
                }
                upm = (UserPreferencesManager)ui.getPreferencesManager();
                ulm = upm.getUserLayoutManager();
            }
            catch (RuntimeException e) {
                this.log.error((Object)e, (Throwable)e);
                this.printError(response, "An unknown error occurred.");
                return;
            }
            try {
                String action = request.getParameter("action");
                if (action == null) {
                    this.log.warn((Object)"preferences servlet called with no action parameter");
                    break block17;
                }
                if (action.equals("movePortletHere")) {
                    this.moveChannel(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("changeColumns")) {
                    this.changeColumns(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("updateColumnWidths")) {
                    this.updateColumnWidths(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("addChannel")) {
                    this.addChannel(per, upm, ulm, userInstanceManager, request, response);
                    break block17;
                }
                if (action.equals("renameTab")) {
                    this.renameTab(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("addTab")) {
                    this.addTab(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("moveTabHere")) {
                    this.moveTab(per, upm, ulm, request, response);
                    break block17;
                }
                if (action.equals("chooseSkin")) {
                    this.chooseSkin(per, upm, ulm, request, response);
                    break block17;
                }
                if (!action.equals("removeElement")) break block17;
                String elementId = request.getParameter("elementID");
                ulm.deleteNode(elementId);
                try {
                    this.saveUserLayoutPreservingTab(ulm, upm, per);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Error saving layout", (Throwable)e);
                }
                this.printSuccess(response, "Removed element", null);
            }
            catch (RuntimeException e) {
                this.log.error((Object)e, (Throwable)e);
                this.printError(response, "An unknown error occurred.");
                return;
            }
        }
    }

    private void moveChannel(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String sourceId = request.getParameter("sourceID");
        String method = request.getParameter("method");
        String destinationId = request.getParameter("elementID");
        Object node = null;
        if (this.isTab(ulm, destinationId)) {
            Enumeration<String> columns = ulm.getChildIds(destinationId);
            if (columns.hasMoreElements()) {
                ulm.moveNode(sourceId, columns.nextElement(), null);
            } else {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription col = ulm.addNode(newColumn, destinationId, null);
                ulm.moveNode(sourceId, col.getId(), null);
            }
        } else if (ulm.getRootFolderId().equals(ulm.getParentId(ulm.getParentId(destinationId)))) {
            ulm.moveNode(sourceId, destinationId, null);
        } else {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationId;
            }
            ulm.moveNode(sourceId, ulm.getParentId(destinationId), siblingId);
        }
        try {
            this.saveUserLayoutPreservingTab(ulm, upm, per);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        this.printSuccess(response, "Saved new channel location", null);
    }

    private void changeColumns(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String columnId;
        String[] newcolumns = request.getParameterValues("columns");
        int columnNumber = newcolumns.length;
        String tabId = request.getParameter("tabId");
        Enumeration<String> columns = ulm.getChildIds(tabId);
        ArrayList<String> columnList = new ArrayList<String>();
        while (columns.hasMoreElements()) {
            columnList.add(columns.nextElement());
        }
        ArrayList<String> newColumns = new ArrayList<String>();
        if (columnNumber > columnList.size()) {
            for (int i = columnList.size(); i < columnNumber; ++i) {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription node = ulm.addNode(newColumn, tabId, null);
                newColumns.add(node.getId());
            }
        } else if (columnNumber < columnList.size()) {
            String lastColumn = (String)columnList.get(columnNumber - 1);
            for (int i = columnNumber; i < columnList.size(); ++i) {
                columnId = (String)columnList.get(i);
                Enumeration<String> channels = ulm.getChildIds(columnId);
                while (channels.hasMoreElements()) {
                    ulm.addNode(ulm.getNode(channels.nextElement()), lastColumn, null);
                }
                ulm.deleteNode(columnId);
            }
        }
        int count = 0;
        columns = ulm.getChildIds(tabId);
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        while (columns.hasMoreElements()) {
            columnId = columns.nextElement();
            ssup.setFolderAttributeValue(columnId, "width", newcolumns[count] + "%");
            Element folder = ulm.getUserLayoutDOM().getElementById(columnId);
            try {
                UserPrefsHandler.setUserPreference(folder, "width", per);
                this.saveSSUPPreservingTab(ulm, upm, per, ssup);
            }
            catch (Exception e) {
                this.log.error((Object)"Error saving new column widths", (Throwable)e);
            }
            ++count;
        }
        try {
            this.saveUserLayoutPreservingTab(ulm, upm, per);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        StringBuffer buf = new StringBuffer();
        if (newColumns.size() > 0) {
            buf.append("<newColumns>");
            Iterator iter = newColumns.iterator();
            while (iter.hasNext()) {
                buf.append("<id>" + iter.next() + "</id>");
            }
            buf.append("</newColumns>");
        }
        this.printSuccess(response, "Saved new column widths", buf.toString());
    }

    private void moveTab(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws PortalException, IOException {
        String destinationId = request.getParameter("elementID");
        String sourceId = request.getParameter("sourceID");
        String method = request.getParameter("method");
        String tabPosition = request.getParameter("tabPosition");
        String siblingId = null;
        if (method.equals("insertBefore")) {
            siblingId = destinationId;
        }
        ulm.moveNode(sourceId, ulm.getParentId(destinationId), siblingId);
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        try {
            String currentTab = ssup.getParameterValue(ACTIVE_TAB_PARAM);
            UserProfile currentProfile = upm.getUserPreferences().getProfile();
            int profileID = currentProfile.getProfileId();
            int structID = currentProfile.getStructureStylesheetId();
            String defaultTab = ulStore.getStructureStylesheetUserPreferences(per, profileID, structID).getParameterValue(ACTIVE_TAB_PARAM);
            if (defaultTab.equals(currentTab)) {
                ssup.putParameterValue(ACTIVE_TAB_PARAM, tabPosition);
            } else {
                ssup.putParameterValue(ACTIVE_TAB_PARAM, defaultTab);
            }
            ulStore.setStructureStylesheetUserPreferences(per, profileID, ssup);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        ulm.saveUserLayout();
        ssup.putParameterValue(ACTIVE_TAB_PARAM, tabPosition);
        this.printSuccess(response, "Saved new tab position", null);
    }

    private void addChannel(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, IUserInstanceManager userInstanceManager, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String destinationId = request.getParameter("elementID");
        int sourceId = Integer.parseInt(request.getParameter("channelID"));
        String method = request.getParameter("position");
        IChannelRegistryStore channelRegistryStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
        IChannelDefinition definition = channelRegistryStore.getChannelDefinition(sourceId);
        UserLayoutChannelDescription channel = new UserLayoutChannelDescription(definition);
        for (IChannelParameter param : definition.getParameters()) {
            String paramValue;
            if (!param.getOverride() || (paramValue = request.getParameter(param.getName())) == null) continue;
            channel.setParameterValue(param.getName(), param.getValue());
        }
        IUserLayoutNodeDescription node = null;
        if (this.isTab(ulm, destinationId)) {
            Enumeration<String> columns = ulm.getChildIds(destinationId);
            if (columns.hasMoreElements()) {
                while (columns.hasMoreElements() && (node = ulm.addNode(channel, columns.nextElement(), null)) == null) {
                }
            } else {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription col = ulm.addNode(newColumn, destinationId, null);
                node = ulm.addNode(channel, col.getId(), null);
            }
        } else if (this.isColumn(ulm, destinationId)) {
            node = ulm.addNode(channel, destinationId, null);
        } else {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationId;
            }
            node = ulm.addNode(channel, ulm.getParentId(destinationId), siblingId);
        }
        String nodeId = node.getId();
        HttpSession session = request.getSession(false);
        ChannelManager cm = new ChannelManager(upm, session);
        cm.instantiateChannel((HttpServletRequest)new PortalHttpServletRequestWrapper(request, response, userInstanceManager), response, channel.getId());
        try {
            this.saveUserLayoutPreservingTab(ulm, upm, per);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        this.printSuccess(response, "Added new channel", "<newNodeId>" + nodeId + "</newNodeId>");
    }

    private void chooseSkin(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String skinName = request.getParameter("skinName");
        ThemeStylesheetUserPreferences themePrefs = upm.getUserPreferences().getThemeStylesheetUserPreferences();
        themePrefs.putParameterValue("skin", skinName);
        try {
            ulStore.setThemeStylesheetUserPreferences(per, upm.getUserPreferences().getProfile().getProfileId(), themePrefs);
        }
        catch (Exception e) {
            this.log.error((Object)"Error storing user skin preferences", (Throwable)e);
        }
        this.printSuccess(response, "Updated Skin", null);
    }

    private void equalizeColumnWidths(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, String tabId) throws PortalException {
        Enumeration<String> columns = ulm.getChildIds(tabId);
        int count = 0;
        while (columns.hasMoreElements()) {
            columns.nextElement();
            ++count;
        }
        int width = 100 / count;
        String widthString = width + "%";
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        UserProfile currentProfile = upm.getUserPreferences().getProfile();
        columns = ulm.getChildIds(tabId);
        String currentTab = ssup.getParameterValue(ACTIVE_TAB_PARAM);
        try {
            while (columns.hasMoreElements()) {
                String columnId = columns.nextElement();
                ssup.setFolderAttributeValue(columnId, "width", widthString);
                Element folder = ulm.getUserLayoutDOM().getElementById(columnId);
                UserPrefsHandler.setUserPreference(folder, "width", per);
                ++count;
            }
            this.saveSSUPPreservingTab(ulm, upm, per, ssup);
        }
        catch (Exception e) {
            this.log.error((Object)"Error saving new column widths", (Throwable)e);
        }
    }

    private void updateColumnWidths(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String[] columnIds = request.getParameterValues("columnIds");
        String[] columnWidths = request.getParameterValues("columnWidths");
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        String currentTab = ssup.getParameterValue(ACTIVE_TAB_PARAM);
        for (int i = 0; i < columnIds.length; ++i) {
            ssup.setFolderAttributeValue(columnIds[i], "width", columnWidths[i]);
            Element folder = ulm.getUserLayoutDOM().getElementById(columnIds[i]);
            try {
                UserPrefsHandler.setUserPreference(folder, "width", per);
                this.saveSSUPPreservingTab(ulm, upm, per, ssup);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Error saving new column widths", (Throwable)e);
            }
        }
        this.printSuccess(response, "Added new channel", null);
    }

    private void addTab(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String id = "tbd";
        String tabName = BLANK_TAB_NAME;
        UserLayoutFolderDescription newTab = new UserLayoutFolderDescription();
        newTab.setName(tabName);
        newTab.setId(id);
        newTab.setFolderType(0);
        newTab.setHidden(false);
        newTab.setUnremovable(false);
        newTab.setImmutable(false);
        ulm.addNode(newTab, ulm.getRootFolderId(), null);
        try {
            this.saveUserLayoutPreservingTab(ulm, upm, per);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        String nodeId = newTab.getId();
        UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
        newColumn.setName("Column");
        newColumn.setId("tbd");
        newColumn.setFolderType(0);
        newColumn.setHidden(false);
        newColumn.setUnremovable(false);
        newColumn.setImmutable(false);
        ulm.addNode(newColumn, nodeId, null);
        try {
            this.saveUserLayoutPreservingTab(ulm, upm, per);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        this.printSuccess(response, "Added new tab", "<newNodeId>" + nodeId + "</newNodeId>");
    }

    private void renameTab(IPerson per, UserPreferencesManager upm, IUserLayoutManager ulm, HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        String tabId = request.getParameter("tabId");
        String tabName = request.getParameter("tabName");
        IUserLayoutFolderDescription tab = (IUserLayoutFolderDescription)ulm.getNode(tabId);
        if (ulm.canUpdateNode(ulm.getNode(tabId))) {
            if (tabName == null || tabName.trim().length() == 0) {
                tab.setName(BLANK_TAB_NAME);
            } else {
                tab.setName(tabName);
            }
            ulm.updateNode(tab);
            try {
                this.saveUserLayoutPreservingTab(ulm, upm, per);
            }
            catch (Exception e) {
                this.log.warn((Object)"Error saving layout", (Throwable)e);
            }
        } else {
            throw new PortalException("attempt.to.rename.immutable.tab" + tabId);
        }
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        ssup.setFolderAttributeValue(tabId, "name", tabName);
        this.printSuccess(response, "Saved new tab name", null);
    }

    private String getDefaultTab(UserPreferencesManager upm, IPerson per) throws Exception {
        UserProfile currentProfile = upm.getUserPreferences().getProfile();
        int profileID = currentProfile.getProfileId();
        int structID = currentProfile.getStructureStylesheetId();
        String defaultTab = ulStore.getStructureStylesheetUserPreferences(per, profileID, structID).getParameterValue(ACTIVE_TAB_PARAM);
        return defaultTab;
    }

    private void saveUserLayoutPreservingTab(IUserLayoutManager ulm, UserPreferencesManager upm, IPerson per) throws Exception {
        StructureStylesheetUserPreferences ssup = upm.getUserPreferences().getStructureStylesheetUserPreferences();
        String currentTab = ssup.getParameterValue(ACTIVE_TAB_PARAM);
        String defaultTab = this.getDefaultTab(upm, per);
        ssup.putParameterValue(ACTIVE_TAB_PARAM, defaultTab);
        ulm.saveUserLayout();
        ssup.putParameterValue(ACTIVE_TAB_PARAM, currentTab);
    }

    private void saveSSUPPreservingTab(IUserLayoutManager ulm, UserPreferencesManager upm, IPerson per, StructureStylesheetUserPreferences ssup) throws Exception {
        int profileId = upm.getUserPreferences().getProfile().getProfileId();
        String currentTab = ssup.getParameterValue(ACTIVE_TAB_PARAM);
        String defaultTab = this.getDefaultTab(upm, per);
        ssup.putParameterValue(ACTIVE_TAB_PARAM, defaultTab);
        ulStore.setStructureStylesheetUserPreferences(per, profileId, ssup);
        ulm.saveUserLayout();
        ssup.putParameterValue(ACTIVE_TAB_PARAM, currentTab);
    }

    private final boolean isTab(IUserLayoutManager ulm, String folderId) throws PortalException {
        return ulm.getRootFolderId().equals(ulm.getParentId(folderId));
    }

    private final boolean isColumn(IUserLayoutManager ulm, String folderId) throws PortalException {
        return this.isTab(ulm, ulm.getParentId(folderId));
    }

    private void printSuccess(HttpServletResponse response, String message, String data) throws IOException {
        response.setContentType("text/xml");
        response.getWriter().print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        response.getWriter().print("<response>");
        response.getWriter().print("<status>");
        response.getWriter().print("<success>true</success>");
        response.getWriter().print("<message>" + message + "</message>");
        response.getWriter().print("</status>");
        if (data != null) {
            response.getWriter().print(data);
        }
        response.getWriter().print("</response>");
    }

    private void printError(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/xml");
        response.getWriter().print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        response.getWriter().print("<response>");
        response.getWriter().print("<status>");
        response.getWriter().print("<success>false</success>");
        response.getWriter().print("<message>" + message + "</message>");
        response.getWriter().print("</status>");
        response.getWriter().print("</response>");
    }
}

